/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.util.Util;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiAction;
import com.xpn.xwiki.web.XWikiRequest;
import com.xpn.xwiki.web.XWikiResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.annotation.Component;
import org.xwiki.environment.Environment;
import org.xwiki.tika.internal.TikaUtils;

@Component
@Named(value="temp")
@Singleton
@Deprecated
public class TempResourceAction
extends XWikiAction {
    public static final Pattern URI_PATTERN = Pattern.compile(".*?/temp/([^/]*+)/([^/]*+)/([^/]*+)/(.*+)");
    private static final String PATH_SEPARATOR = "/";
    private static final String URL_ENCODING = "UTF-8";
    private static final Logger LOGGER = LoggerFactory.getLogger(TempResourceAction.class);
    private Environment environment = Utils.getComponent(Environment.class);

    @Override
    public String render(XWikiContext context) throws XWikiException {
        XWikiRequest request = context.getRequest();
        XWikiResponse response = context.getResponse();
        String uri = request.getRequestURI();
        File tempFile = this.getTemporaryFile(uri, context);
        if (tempFile == null) {
            throw new XWikiException(11, 11007, "Invalid temporary resource URL");
        }
        response.setDateHeader("Last-Modified", tempFile.lastModified());
        String contentType = "application/octet-stream";
        try {
            contentType = TikaUtils.detect((File)tempFile);
        }
        catch (IOException ex) {
            LOGGER.warn(String.format("Unable to determine mime type for temporary resource [%s]", tempFile.getAbsolutePath()), (Throwable)ex);
        }
        response.setContentType(contentType);
        if ("1".equals(request.getParameter("force-download"))) {
            String fileName = (String)StringUtils.defaultIfBlank((CharSequence)request.getParameter("force-filename"), (CharSequence)tempFile.getName());
            fileName = Util.encodeURI(fileName, context).replaceAll("\\+", "%20");
            response.addHeader("Content-disposition", "attachment; filename*=utf-8''" + fileName);
        }
        try {
            response.setContentLength((int)tempFile.length());
            IOUtils.copy((InputStream)FileUtils.openInputStream((File)tempFile), (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            throw new XWikiException(11, 11011, "Exception while sending response", e);
        }
        return null;
    }

    protected File getTemporaryFile(String uri, XWikiContext context) {
        Matcher matcher = URI_PATTERN.matcher(uri);
        File result = null;
        if (matcher.find()) {
            ArrayList<String> pathSegments = new ArrayList<String>();
            pathSegments.add("temp");
            pathSegments.add(this.withMinimalURLEncoding(matcher.group(3)));
            pathSegments.add(this.encodeURLPathSegment(context.getWikiId()));
            pathSegments.add(this.withMinimalURLEncoding(matcher.group(1)));
            pathSegments.add(this.withMinimalURLEncoding(matcher.group(2)));
            String prefix = StringUtils.join(pathSegments, (String)PATH_SEPARATOR);
            String[] stringArray = matcher.group(4).split(PATH_SEPARATOR);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String filePathSegment = stringArray[n2];
                pathSegments.add(this.withMinimalURLEncoding(filePathSegment));
                ++n2;
            }
            String path = URI.create(StringUtils.join(pathSegments, (String)PATH_SEPARATOR)).normalize().toString();
            if (path.startsWith(prefix)) {
                result = new File(this.environment.getTemporaryDirectory(), path);
                result = result.exists() ? result : null;
            }
        }
        return result;
    }

    private String withMinimalURLEncoding(String encodedPathSegment) {
        return this.encodeURLPathSegment(this.decodeURLPathSegment(encodedPathSegment));
    }

    private String encodeURLPathSegment(String segment) {
        try {
            return URLEncoder.encode(segment, URL_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return segment;
        }
    }

    private String decodeURLPathSegment(String encodedSegment) {
        try {
            return URLDecoder.decode(encodedSegment, URL_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return encodedSegment;
        }
    }
}

