/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.util.Util;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiAction;
import com.xpn.xwiki.web.XWikiResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Date;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.ObjectPropertyReference;
import org.xwiki.model.reference.ObjectReference;
import org.xwiki.security.authorization.AuthorExecutor;

@Component
@Named(value="skin")
@Singleton
public class SkinAction
extends XWikiAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(SkinAction.class);
    private static final String DELIMITER = "/";
    private static final String SKINS_DIRECTORY = "skins";
    private static final String RESOURCES_DIRECTORY = "resources";
    private static final String ENCODING = "UTF-8";
    private static final String DOCDOESNOTEXIST = "docdoesnotexist";

    @Override
    public boolean action(XWikiContext context) throws XWikiException {
        if (!DOCDOESNOTEXIST.equals(Utils.getPage(context.getRequest(), DOCDOESNOTEXIST))) {
            throw new XWikiException(0, 9001, "Template may not be overriden with 'xpage' in [skin] action.");
        }
        return super.action(context);
    }

    @Override
    public String render(XWikiContext context) throws XWikiException {
        try {
            return this.render(context.getRequest().getPathInfo(), context);
        }
        catch (IOException e) {
            context.getResponse().setStatus(404);
            return DOCDOESNOTEXIST;
        }
    }

    public String render(String path, XWikiContext context) throws XWikiException, IOException {
        XWiki xwiki = context.getWiki();
        XWikiDocument doc = context.getDoc();
        String baseskin = xwiki.getBaseSkin(context, true);
        XWikiDocument baseskindoc = xwiki.getDocument(baseskin, context);
        String defaultbaseskin = xwiki.getDefaultBaseSkin(context);
        LOGGER.debug("document: [{}] ; baseskin: [{}] ; defaultbaseskin: [{}]", new Object[]{doc.getDocumentReference(), baseskin, defaultbaseskin});
        int idx = path.lastIndexOf(DELIMITER);
        boolean found = false;
        while (idx > 0) {
            try {
                String filename = Util.decodeURI(path.substring(idx + 1), context);
                LOGGER.debug("Trying [{}]", (Object)filename);
                if (this.renderSkin(filename, doc, context)) {
                    found = true;
                    break;
                }
                if (StringUtils.isNotEmpty((CharSequence)baseskin) && !doc.getName().equals(baseskin) && this.renderSkin(filename, baseskindoc, context)) {
                    found = true;
                    break;
                }
                if (StringUtils.isNotEmpty((CharSequence)baseskin) && !doc.getName().equals(defaultbaseskin) && !baseskin.equals(defaultbaseskin) && this.renderFileFromFilesystem(this.getSkinFilePath(filename, defaultbaseskin), context)) {
                    found = true;
                    break;
                }
                if (this.renderFileFromFilesystem(this.getResourceFilePath(filename), context)) {
                    found = true;
                    break;
                }
            }
            catch (XWikiException ex) {
                if (ex.getCode() == 11011) {
                    throw ex;
                }
                LOGGER.debug(String.valueOf(idx), (Throwable)ex);
            }
            idx = path.lastIndexOf(DELIMITER, idx - 1);
        }
        if (!found) {
            context.getResponse().setStatus(404);
            return DOCDOESNOTEXIST;
        }
        return null;
    }

    public String getSkinFilePath(String filename, String skin) throws IOException {
        String path = URI.create("/skins/" + skin + DELIMITER + filename).normalize().toString();
        if (!path.startsWith("/skins")) {
            LOGGER.warn("Illegal access, tried to use file [{}] as a skin. Possible break-in attempt!", (Object)path);
            throw new IOException("Invalid filename: '" + filename + "' for skin '" + skin + "'");
        }
        return path;
    }

    public String getResourceFilePath(String filename) throws IOException {
        String path = URI.create("/resources/" + filename).normalize().toString();
        if (!path.startsWith("/resources")) {
            LOGGER.warn("Illegal access, tried to use file [{}] as a resource. Possible break-in attempt!", (Object)path);
            throw new IOException("Invalid filename: '" + filename + "'");
        }
        return path;
    }

    private boolean renderSkin(String filename, XWikiDocument doc, XWikiContext context) throws XWikiException, IOException {
        LOGGER.debug("Rendering file [{}] within the [{}] document", (Object)filename, (Object)doc.getDocumentReference());
        try {
            if (!doc.isNew()) {
                return this.renderFileFromObjectField(filename, doc, context) || this.renderFileFromAttachment(filename, doc, context) || SKINS_DIRECTORY.equals(doc.getSpace()) && this.renderFileFromFilesystem(this.getSkinFilePath(filename, doc.getName()), context);
            }
            LOGGER.debug("[{}] is not a document", (Object)doc.getDocumentReference().getName());
        }
        catch (IOException e) {
            throw new XWikiException(11, 11011, "Exception while sending response:", e);
        }
        return this.renderFileFromFilesystem(this.getSkinFilePath(filename, doc.getName()), context);
    }

    private boolean renderFileFromFilesystem(String path, XWikiContext context) throws XWikiException {
        block8: {
            LOGGER.debug("Rendering filesystem file from path [{}]", (Object)path);
            XWikiResponse response = context.getResponse();
            try {
                byte[] data = context.getWiki().getResourceContentAsBytes(path);
                if (data == null || data.length <= 0) break block8;
                String filename = path.substring(path.lastIndexOf(DELIMITER) + 1, path.length());
                Date modified = null;
                String mimetype = context.getEngineContext().getMimeType(filename.toLowerCase());
                if (this.isCssMimeType(mimetype) || this.isJavascriptMimeType(mimetype) || this.isLessCssFile(filename)) {
                    String rawContent = new String(data, ENCODING);
                    DocumentReference superadminUserReference = new DocumentReference(context.getMainXWiki(), "XWiki", "superadmin");
                    String evaluatedContent = this.evaluateVelocity(rawContent, path, superadminUserReference, null, context);
                    byte[] newdata = evaluatedContent.getBytes(ENCODING);
                    if (Arrays.equals(newdata, data)) {
                        modified = context.getWiki().getResourceLastModificationDate(path);
                    } else {
                        modified = new Date();
                        data = newdata;
                    }
                    response.setCharacterEncoding(ENCODING);
                } else {
                    modified = context.getWiki().getResourceLastModificationDate(path);
                }
                this.setupHeaders(response, mimetype, modified, data.length);
                try {
                    response.getOutputStream().write(data);
                }
                catch (IOException e) {
                    throw new XWikiException(11, 11011, "Exception while sending response", e);
                }
                return true;
            }
            catch (IOException ex) {
                LOGGER.info("Skin file [{}] does not exist or cannot be accessed", (Object)path);
            }
        }
        return false;
    }

    public boolean renderFileFromObjectField(String filename, XWikiDocument doc, XWikiContext context) throws IOException {
        LOGGER.debug("... as object property");
        BaseObject object = doc.getObject("XWiki.XWikiSkins");
        String content = null;
        if (object != null) {
            content = object.getStringValue(filename);
        }
        if (!StringUtils.isBlank(content)) {
            XWiki xwiki = context.getWiki();
            String mimetype = xwiki.getEngineContext().getMimeType(filename.toLowerCase());
            if (this.isCssMimeType(mimetype) || this.isJavascriptMimeType(mimetype)) {
                ObjectPropertyReference propertyReference = new ObjectPropertyReference(filename, (ObjectReference)object.getReference());
                content = this.evaluateVelocity(content, (EntityReference)propertyReference, doc.getAuthorReference(), doc.getDocumentReference(), context);
            }
            XWikiResponse response = context.getResponse();
            response.setCharacterEncoding(ENCODING);
            byte[] data = content.getBytes(ENCODING);
            this.setupHeaders(response, mimetype, doc.getDate(), data.length);
            response.getOutputStream().write(data);
            return true;
        }
        LOGGER.debug("Object field not found or empty");
        return false;
    }

    private String evaluateVelocity(String content, EntityReference reference, DocumentReference author, DocumentReference sourceDocument, XWikiContext context) {
        EntityReferenceSerializer serializer = (EntityReferenceSerializer)Utils.getComponent(EntityReferenceSerializer.TYPE_STRING);
        String namespace = (String)serializer.serialize(reference, new Object[0]);
        return this.evaluateVelocity(content, namespace, author, sourceDocument, context);
    }

    private String evaluateVelocity(String content, String namespace, DocumentReference author, DocumentReference sourceDocument, XWikiContext context) {
        String result = content;
        try {
            result = (String)Utils.getComponent(AuthorExecutor.class).call(() -> context.getWiki().evaluateVelocity(content, namespace), author, sourceDocument);
        }
        catch (Exception e) {
            LOGGER.error("Failed to evaluate velocity content for namespace {} with the rights of the user {}", new Object[]{namespace, author, e});
        }
        return result;
    }

    public boolean renderFileFromAttachment(String filename, XWikiDocument doc, XWikiContext context) throws IOException, XWikiException {
        LOGGER.debug("... as attachment");
        XWikiAttachment attachment = doc.getAttachment(filename);
        if (attachment != null) {
            XWiki xwiki = context.getWiki();
            XWikiResponse response = context.getResponse();
            String mimetype = xwiki.getEngineContext().getMimeType(filename.toLowerCase());
            if (this.isCssMimeType(mimetype) || this.isJavascriptMimeType(mimetype)) {
                byte[] data = attachment.getContent(context);
                String velocityCode = new String(data, ENCODING);
                String evaluatedContent = this.evaluateVelocity(velocityCode, (EntityReference)attachment.getReference(), doc.getAuthorReference(), doc.getDocumentReference(), context);
                response.setCharacterEncoding(ENCODING);
                data = evaluatedContent.getBytes(ENCODING);
                this.setupHeaders(response, mimetype, attachment.getDate(), data.length);
                response.getOutputStream().write(data);
            } else {
                this.setupHeaders(response, mimetype, attachment.getDate(), attachment.getContentLongSize(context));
                IOUtils.copy((InputStream)attachment.getContentInputStream(context), (OutputStream)response.getOutputStream());
            }
            return true;
        }
        LOGGER.debug("Attachment not found");
        return false;
    }

    public boolean isJavascriptMimeType(String mimetype) {
        boolean result = "text/javascript".equalsIgnoreCase(mimetype) || "application/x-javascript".equalsIgnoreCase(mimetype) || "application/javascript".equalsIgnoreCase(mimetype);
        return result |= "application/ecmascript".equalsIgnoreCase(mimetype) || "text/ecmascript".equalsIgnoreCase(mimetype);
    }

    public boolean isCssMimeType(String mimetype) {
        return "text/css".equalsIgnoreCase(mimetype);
    }

    private boolean isLessCssFile(String filename) {
        return filename.toLowerCase().endsWith(".less.vm");
    }

    @Deprecated
    protected void setupHeaders(XWikiResponse response, String mimetype, Date lastChanged, int length) {
        this.setupHeaders(response, mimetype, lastChanged, (long)length);
    }

    @Deprecated(since="17.0.0RC1")
    protected void setupHeaders(XWikiResponse response, String mimetype, Date lastChanged, long length) {
        if (!StringUtils.isBlank((CharSequence)mimetype)) {
            response.setContentType(mimetype);
        } else {
            response.setContentType("application/octet-stream");
        }
        response.setDateHeader("Last-Modified", lastChanged.getTime());
        response.setHeader("Cache-Control", "public");
        response.setDateHeader("Expires", new Date().getTime() + 2592000000L);
        this.setContentLength(response, length);
    }
}

