/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web;

import com.xpn.xwiki.util.Util;
import com.xpn.xwiki.web.ObjectPolicyType;
import com.xpn.xwiki.web.XWikiForm;
import com.xpn.xwiki.web.XWikiRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.stability.Unstable;

public class EditForm
extends XWikiForm {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditForm.class);
    private static final Pattern XPROPERTY_REFERENCE_PATTERN = Pattern.compile("^((?:[\\S ]+\\.)+[\\S ]+?)_([0-9]+)_(.+)$");
    private static final Pattern XOBJECTS_REFERENCE_PATTERN = Pattern.compile("^((?:[\\S ]+\\.)+[\\S ]+?)_([0-9]+)$");
    private static final String OBJECTS_CLASS_DELIMITER = "_";
    private String content;
    private String web;
    private String name;
    private String parent;
    private String creator;
    private String template;
    private String language;
    private String defaultLanguage;
    private String defaultTemplate;
    private String title;
    private String comment;
    private boolean isMinorEdit = false;
    private String tags;
    private boolean lockForce;
    private String syntaxId;
    private boolean convertSyntax;
    private String hidden;
    private String enforceRequiredRights;
    private ObjectPolicyType objectPolicy;
    private Map<String, List<Integer>> objectsToRemove;
    private Map<String, List<Integer>> objectsToAdd;
    private Map<String, SortedMap<Integer, Map<String, String[]>>> updateOrCreateMap;
    private List<String> temporaryUploadedFiles;

    @Override
    public void readRequest() {
        XWikiRequest request = this.getRequest();
        this.setContent(request.getParameter("content"));
        this.setWeb(request.getParameter("web"));
        this.setName(request.getParameter("name"));
        this.setParent(request.getParameter("parent"));
        this.setTemplate(request.getParameter("template"));
        this.setDefaultTemplate(request.getParameter("default_template"));
        this.setCreator(request.getParameter("creator"));
        this.setLanguage(request.getParameter("language"));
        this.setTitle(request.getParameter("title"));
        this.setComment(request.getParameter("comment"));
        this.setDefaultLanguage(request.getParameter("defaultLanguage"));
        this.setTags(request.getParameterValues("tags"));
        this.setLockForce("1".equals(request.getParameter("force")));
        this.setMinorEdit(request.getParameter("minorEdit") != null);
        this.setSyntaxId(request.getParameter("syntaxId"));
        this.setConvertSyntax(Boolean.valueOf(request.getParameter("convertSyntax")));
        this.setHidden(request.getParameter("xhidden"));
        this.setEnforceRequiredRights(request.getParameter("enforceRequiredRights"));
        this.setObjectPolicy(request.getParameter("objectPolicy"));
        this.setUpdateOrCreateMap(request);
        this.setObjectsToRemove(request.getParameterValues("deletedObjects"));
        this.setObjectsToAdd(request.getParameterValues("addedObjects"));
        this.setTemporaryUploadedFiles(request.getParameterValues("uploadedFiles"));
    }

    public void setTags(String[] parameter) {
        if (parameter == null) {
            this.tags = null;
            return;
        }
        StringBuilder tags = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < parameter.length; ++i) {
            if (parameter[i].equals("")) continue;
            if (first) {
                first = false;
            } else {
                tags.append("|");
            }
            tags.append(parameter[i]);
        }
        this.tags = tags.toString();
    }

    public String getTags() {
        return this.tags;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getWeb() {
        return this.web;
    }

    public void setWeb(String web) {
        this.web = web;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = Util.normalizeLanguage(language);
    }

    public int getObjectNumbers(String prefix) {
        String nb = this.getRequest().getParameter(prefix + "_nb");
        return NumberUtils.toInt((String)nb);
    }

    public Map<String, String[]> getObject(String prefix) {
        Map allParameters = this.getRequest().getParameterMap();
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        for (String name : allParameters.keySet()) {
            if (!name.startsWith(prefix + OBJECTS_CLASS_DELIMITER)) continue;
            String newname = name.substring(prefix.length() + 1);
            result.put(newname, (String[])allParameters.get(name));
        }
        return result;
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getDefaultTemplate() {
        return this.defaultTemplate;
    }

    public void setDefaultTemplate(String defaultTemplate) {
        this.defaultTemplate = defaultTemplate;
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public void setDefaultLanguage(String defaultLanguage) {
        this.defaultLanguage = Util.normalizeLanguage(defaultLanguage);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean isMinorEdit() {
        return this.isMinorEdit;
    }

    public void setMinorEdit(boolean isMinorEdit) {
        this.isMinorEdit = isMinorEdit;
    }

    public boolean isLockForce() {
        return this.lockForce;
    }

    public void setLockForce(boolean lockForce) {
        this.lockForce = lockForce;
    }

    public String getSyntaxId() {
        return this.syntaxId;
    }

    public void setSyntaxId(String syntaxId) {
        this.syntaxId = syntaxId;
    }

    public boolean isConvertSyntax() {
        return this.convertSyntax;
    }

    public void setConvertSyntax(boolean convertSyntax) {
        this.convertSyntax = convertSyntax;
    }

    public String getHidden() {
        return this.hidden;
    }

    public void setHidden(String hidden) {
        this.hidden = hidden;
    }

    @Unstable
    public String getEnforceRequiredRights() {
        return this.enforceRequiredRights;
    }

    @Unstable
    public void setEnforceRequiredRights(String enforceRequiredRights) {
        this.enforceRequiredRights = enforceRequiredRights;
    }

    public ObjectPolicyType getObjectPolicy() {
        return this.objectPolicy;
    }

    private void setObjectPolicy(ObjectPolicyType objectPolicy) {
        this.objectPolicy = objectPolicy;
    }

    private void setObjectPolicy(String objectPolicyName) {
        this.objectPolicy = ObjectPolicyType.forName(objectPolicyName);
    }

    private void setObjectsToRemove(String[] objectsToRemove) {
        if (objectsToRemove == null) {
            this.objectsToRemove = Collections.emptyMap();
        } else {
            this.objectsToRemove = new HashMap<String, List<Integer>>();
            for (String objectAndId : objectsToRemove) {
                Matcher matcher = XOBJECTS_REFERENCE_PATTERN.matcher(objectAndId);
                if (!matcher.matches()) continue;
                String className = matcher.group(1);
                String objectNumber = matcher.group(2);
                try {
                    Integer objectId = Integer.parseInt(objectNumber);
                    if (!this.objectsToRemove.containsKey(className)) {
                        this.objectsToRemove.put(className, new ArrayList());
                    }
                    List<Integer> objectIds = this.objectsToRemove.get(className);
                    objectIds.add(objectId);
                }
                catch (NumberFormatException e) {
                    LOGGER.warn("Invalid xobject number [{}], ignoring removed xobject [{}].", (Object)objectNumber, (Object)objectAndId);
                }
            }
        }
    }

    public Map<String, List<Integer>> getObjectsToRemove() {
        return this.objectsToRemove;
    }

    private void setObjectsToAdd(String[] objectsToAdd) {
        if (objectsToAdd == null) {
            this.objectsToAdd = Collections.emptyMap();
        } else {
            this.objectsToAdd = new HashMap<String, List<Integer>>();
            for (String objectAndId : objectsToAdd) {
                Matcher matcher = XOBJECTS_REFERENCE_PATTERN.matcher(objectAndId);
                if (!matcher.matches()) continue;
                String className = matcher.group(1);
                String objectNumber = matcher.group(2);
                try {
                    Integer objectId = Integer.parseInt(objectNumber);
                    if (!this.objectsToAdd.containsKey(className)) {
                        this.objectsToAdd.put(className, new ArrayList());
                    }
                    List<Integer> objectIds = this.objectsToAdd.get(className);
                    objectIds.add(objectId);
                }
                catch (NumberFormatException e) {
                    LOGGER.warn("Invalid xobject number [{}], ignoring added xobject [{}].", (Object)objectNumber, (Object)objectAndId);
                }
            }
        }
    }

    private void setTemporaryUploadedFiles(String[] temporaryUploadedFiles) {
        this.temporaryUploadedFiles = temporaryUploadedFiles == null || temporaryUploadedFiles.length == 0 ? Collections.emptyList() : Arrays.asList(temporaryUploadedFiles);
    }

    public List<String> getTemporaryUploadedFiles() {
        return this.temporaryUploadedFiles;
    }

    public Map<String, List<Integer>> getObjectsToAdd() {
        return this.objectsToAdd;
    }

    private void setUpdateOrCreateMap(XWikiRequest request) {
        if (ObjectPolicyType.UPDATE_OR_CREATE.equals((Object)this.getObjectPolicy())) {
            this.updateOrCreateMap = new HashMap<String, SortedMap<Integer, Map<String, String[]>>>();
            Map allParameters = request.getParameterMap();
            for (Map.Entry parameter : allParameters.entrySet()) {
                HashMap<String, String[]> object;
                Integer classNumber;
                Matcher matcher = XPROPERTY_REFERENCE_PATTERN.matcher((CharSequence)parameter.getKey());
                if (!matcher.matches()) continue;
                String className = matcher.group(1);
                String classNumberAsString = matcher.group(2);
                String classPropertyName = matcher.group(3);
                try {
                    classNumber = Integer.parseInt(classNumberAsString);
                }
                catch (NumberFormatException e) {
                    LOGGER.warn("Invalid xobject number [{}], ignoring property update [{}].", (Object)classNumberAsString, parameter.getKey());
                    continue;
                }
                SortedMap<Integer, Map<String, String[]>> objectMap = this.updateOrCreateMap.get(className);
                if (objectMap == null) {
                    objectMap = new TreeMap<Integer, Map<String, String[]>>();
                    this.updateOrCreateMap.put(className, objectMap);
                }
                if ((object = (HashMap<String, String[]>)objectMap.get(classNumber)) == null) {
                    object = new HashMap<String, String[]>();
                    objectMap.put(classNumber, object);
                }
                object.put(classPropertyName, (String[])parameter.getValue());
            }
        } else {
            this.updateOrCreateMap = Collections.emptyMap();
        }
    }

    public Map<String, SortedMap<Integer, Map<String, String[]>>> getUpdateOrCreateMap() {
        return this.updateOrCreateMap;
    }
}

