/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.XWikiPluginManager;
import com.xpn.xwiki.web.DownloadAction;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiRequest;
import com.xpn.xwiki.web.XWikiResponse;
import java.io.IOException;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceManager;
import org.xwiki.resource.entity.EntityResourceReference;

@Component
@Named(value="downloadrev")
@Singleton
public class DownloadRevAction
extends DownloadAction {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String render(XWikiContext context) throws XWikiException {
        XWikiAttachment attachment;
        XWikiRequest request = context.getRequest();
        XWikiResponse response = context.getResponse();
        XWikiDocument doc = context.getDoc();
        String rev = request.getParameter("rev");
        String filename = this.getFileName();
        if (filename != null && context.getWiki().hasAttachmentRecycleBin(context) && request.getParameter("rid") != null) {
            int recycleId = Integer.parseInt(request.getParameter("rid"));
            attachment = new XWikiAttachment(doc, filename);
            attachment = context.getWiki().getAttachmentRecycleBinStore().restoreFromRecycleBin(attachment, recycleId, context, true);
        } else if (request.getParameter("id") != null) {
            int id = Integer.parseInt(request.getParameter("id"));
            attachment = doc.getAttachmentList().get(id);
        } else {
            attachment = doc.getAttachment(filename);
        }
        if (attachment == null) {
            String message;
            Object[] args;
            if (filename == null) {
                ResourceReference resourceReference = Utils.getComponent(ResourceReferenceManager.class).getResourceReference();
                args = new Object[]{resourceReference};
                message = "No attachment found for resource [{0}]";
            } else {
                args = new Object[]{filename};
                message = "Attachment [{0}] not found";
            }
            throw new XWikiException(11, 11003, message, null, args);
        }
        XWikiAttachment args = attachment;
        synchronized (args) {
            try {
                attachment = attachment.getAttachmentRevision(rev, context);
                if (attachment == null) {
                    throw new XWikiException();
                }
            }
            catch (XWikiException e) {
                Object url = context.getDoc().getURL("viewattachrev", true, context);
                url = (String)url + "/" + filename;
                if (request.getParameter("rid") != null) {
                    url = (String)url + "?rid=" + request.getParameter("rid");
                }
                try {
                    context.getResponse().sendRedirect((String)url);
                    return null;
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
        XWikiPluginManager plugins = context.getWiki().getPluginManager();
        attachment = plugins.downloadAttachment(attachment, context);
        this.sendContent(attachment, request, response, context);
        return null;
    }

    private String getFileName() {
        ResourceReference resourceReference = Utils.getComponent(ResourceReferenceManager.class).getResourceReference();
        EntityResourceReference entityResource = (EntityResourceReference)resourceReference;
        String filename = null;
        EntityReference attachmentReference = entityResource.getEntityReference().extractReference(EntityType.ATTACHMENT);
        if (attachmentReference != null) {
            filename = attachmentReference.getName();
        }
        return filename;
    }
}

