/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.XWikiPluginManager;
import com.xpn.xwiki.util.Util;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiAction;
import com.xpn.xwiki.web.XWikiRequest;
import com.xpn.xwiki.web.XWikiResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceManager;
import org.xwiki.resource.entity.EntityResourceReference;
import org.xwiki.store.TemporaryAttachmentSessionsManager;

@Component
@Named(value="download")
@Singleton
public class DownloadAction
extends XWikiAction {
    public static final String ACTION_NAME = "download";
    public static final String ATTACHMENT = "attachment";
    public static final List<String> MIMETYPE_WHITELIST = Arrays.asList("audio/basic", "audio/L24", "audio/mp4", "audio/mpeg", "audio/ogg", "audio/vorbis", "audio/vnd.rn-realaudio", "audio/vnd.wave", "audio/webm", "image/gif", "image/jpeg", "image/pjpeg", "image/png", "image/tiff", "text/csv", "text/plain", "text/xml", "text/rtf", "video/mpeg", "video/ogg", "video/quicktime", "video/webm", "video/x-matroska", "video/x-ms-wmv", "video/x-flv");
    public static final String WHITELIST_PROPERTY = "attachment.download.whitelist";
    public static final String BLACKLIST_PROPERTY = "attachment.download.blacklist";
    public static final String FORCE_DOWNLOAD_PROPERTY = "attachment.download.forceDownload";
    private static final String SEPARATOR = "/";
    private static final String RANGE_HEADER_NAME = "Range";
    private static final Pattern RANGE_HEADER_PATTERN = Pattern.compile("bytes=([0-9]+)?-([0-9]+)?");
    @Inject
    private TemporaryAttachmentSessionsManager temporaryAttachmentSessionsManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String render(XWikiContext context) throws XWikiException {
        XWikiRequest request = context.getRequest();
        XWikiResponse response = context.getResponse();
        XWikiDocument doc = context.getDoc();
        String filename = this.getFileName();
        XWikiAttachment attachment = this.getAttachment(request, doc, filename);
        HashMap<String, Object> backwardCompatibilityContextObjects = null;
        if (attachment == null) {
            Pair<XWikiDocument, XWikiAttachment> result = this.extractAttachmentAndDocumentFromURLWithoutSupportingNestedSpaces(request, context);
            if (result == null) {
                this.throwNotFoundException(filename);
            }
            XWikiDocument backwardCompatibilityDocument = (XWikiDocument)result.getLeft();
            attachment = (XWikiAttachment)result.getRight();
            backwardCompatibilityContextObjects = new HashMap<String, Object>();
            this.pushDocumentInContext(backwardCompatibilityContextObjects, backwardCompatibilityDocument.getDocumentReference());
        }
        try {
            XWikiPluginManager plugins = context.getWiki().getPluginManager();
            attachment = plugins.downloadAttachment(attachment, context);
            if (attachment == null) {
                this.throwNotFoundException(filename);
            }
            try {
                attachment.getContentLongSize(context);
            }
            catch (XWikiException e) {
                Object[] args = new Object[]{filename};
                throw new XWikiException(11, 11003, "Attachment content {0} not found", null, args);
            }
            long lastModifiedOnClient = request.getDateHeader("If-Modified-Since");
            long lastModifiedOnServer = attachment.getDate().getTime();
            if (lastModifiedOnClient != -1L && lastModifiedOnClient >= lastModifiedOnServer) {
                response.setStatus(304);
                String string = null;
                return string;
            }
            if (request.getHeader(RANGE_HEADER_NAME) != null) {
                try {
                    if (this.sendPartialContent(attachment, request, response, context)) {
                        String string = null;
                        return string;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.sendContent(attachment, request, response, context);
            String string = null;
            return string;
        }
        finally {
            if (backwardCompatibilityContextObjects != null) {
                this.popDocumentFromContext(backwardCompatibilityContextObjects);
            }
        }
    }

    @Override
    protected boolean supportRedirections() {
        return true;
    }

    private void throwNotFoundException(String filename) throws XWikiException {
        String message = filename == null ? "Attachment not found" : String.format("Attachment [%s] not found", filename);
        throw new XWikiException(11, 11003, message);
    }

    private boolean sendPartialContent(XWikiAttachment attachment, XWikiRequest request, XWikiResponse response, XWikiContext context) throws XWikiException, IOException {
        String range = request.getHeader(RANGE_HEADER_NAME);
        Matcher m = RANGE_HEADER_PATTERN.matcher(range);
        if (m.matches()) {
            String startStr = m.group(1);
            String endStr = m.group(2);
            Long start = NumberUtils.createLong((String)startStr);
            Long end = NumberUtils.createLong((String)endStr);
            if (start == null && end != null && end > 0L) {
                start = Math.max(attachment.getContentLongSize(context) - end, 0L);
                end = attachment.getContentLongSize(context) - 1L;
            }
            if (!this.isValidRange(start, end)) {
                return false;
            }
            if (end == null) {
                end = attachment.getContentLongSize(context) - 1L;
            }
            end = Math.min(end, attachment.getContentLongSize(context) - 1L);
            this.writeByteRange(attachment, start, end, request, response, context);
            return true;
        }
        return false;
    }

    private void writeByteRange(XWikiAttachment attachment, Long start, Long end, XWikiRequest request, XWikiResponse response, XWikiContext context) throws XWikiException, IOException {
        if (start >= 0L && start < attachment.getContentLongSize(context)) {
            InputStream data = attachment.getContentInputStream(context);
            data = new BoundedInputStream(data, end + 1L);
            data.skip(start);
            this.setCommonHeaders(attachment, request, response, context);
            response.setStatus(206);
            if (end - start + 1L < Integer.MAX_VALUE) {
                this.setContentLength(response, end - start + 1L);
            }
            response.setHeader("Content-Range", "bytes " + start + "-" + end + SEPARATOR + attachment.getContentLongSize(context));
            IOUtils.copyLarge((InputStream)data, (OutputStream)response.getOutputStream());
        } else {
            response.setStatus(416);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated(since="17.0.0RC1")
    protected void sendContent(XWikiAttachment attachment, XWikiRequest request, XWikiResponse response, XWikiContext context) throws XWikiException {
        InputStream stream = null;
        try {
            this.setCommonHeaders(attachment, request, response, context);
            this.setContentLength(response, attachment.getContentLongSize(context));
            stream = attachment.getContentInputStream(context);
            IOUtils.copy((InputStream)stream, (OutputStream)response.getOutputStream());
            if (stream == null) return;
        }
        catch (IOException e) {
            try {
                throw new XWikiException(11, 11011, "Exception while sending response", e);
            }
            catch (Throwable throwable) {
                if (stream == null) throw throwable;
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)stream);
        return;
    }

    private String getFileName() {
        ResourceReference resourceReference = Utils.getComponent(ResourceReferenceManager.class).getResourceReference();
        EntityResourceReference entityResource = (EntityResourceReference)resourceReference;
        EntityReference attachmentReference = entityResource.getEntityReference().extractReference(EntityType.ATTACHMENT);
        return attachmentReference == null ? null : attachmentReference.getName();
    }

    private Pair<XWikiDocument, XWikiAttachment> extractAttachmentAndDocumentFromURLWithoutSupportingNestedSpaces(XWikiRequest request, XWikiContext context) {
        XWikiDocument backwardCompatibilityDocument;
        String attachmentName;
        block6: {
            String path = request.getRequestURI();
            int pos = path.indexOf("/download");
            String subPath = path.substring(pos + "/download".length() + 1);
            ArrayList<String> segments = new ArrayList<String>();
            for (String pathSegment : subPath.split(SEPARATOR, -1)) {
                segments.add(Util.decodeURI(pathSegment, context));
            }
            if (segments.size() < 3) {
                return null;
            }
            String spaceName = (String)segments.get(0);
            String pageName = (String)segments.get(1);
            attachmentName = (String)segments.get(2);
            DocumentReference reference = new DocumentReference(context.getWikiId(), spaceName, pageName);
            XWiki xwiki = context.getWiki();
            try {
                backwardCompatibilityDocument = xwiki.getDocument(reference, context);
                if (!backwardCompatibilityDocument.isNew()) {
                    if (!context.getWiki().checkAccess(context.getAction(), backwardCompatibilityDocument, context)) {
                        return null;
                    }
                    break block6;
                }
                return null;
            }
            catch (XWikiException e) {
                return null;
            }
        }
        XWikiAttachment attachment = this.getAttachment(request, backwardCompatibilityDocument, attachmentName);
        return new ImmutablePair((Object)backwardCompatibilityDocument, (Object)attachment);
    }

    private void pushDocumentInContext(Map<String, Object> backupObjects, DocumentReference documentReference) throws XWikiException {
        XWikiContext xcontext = this.getContext();
        XWikiDocument.backupContext(backupObjects, xcontext);
        xcontext = this.getContext();
        xcontext.getWiki().getDocument(documentReference, xcontext).setAsContextDoc(xcontext);
    }

    private void popDocumentFromContext(Map<String, Object> backupObjects) {
        XWikiDocument.restoreContext(backupObjects, this.getContext());
    }

    private XWikiContext getContext() {
        Execution execution = Utils.getComponent(Execution.class);
        ExecutionContext econtext = execution.getContext();
        return econtext != null ? (XWikiContext)econtext.getProperty("xwikicontext") : null;
    }

    private XWikiAttachment getAttachment(XWikiRequest request, XWikiDocument document, String filename) {
        XWikiAttachment attachment = null;
        String idStr = request.getParameter("id");
        if (StringUtils.isNumeric((CharSequence)idStr)) {
            int id = Integer.parseInt(idStr);
            if (document.getAttachmentList().size() > id) {
                attachment = document.getAttachmentList().get(id);
            }
        } else {
            XWikiAttachment standardAttachment = document.getAttachment(filename);
            DocumentReference documentReference = document.getDocumentReference();
            Optional<XWikiAttachment> uploadedAttachmentOpt = this.temporaryAttachmentSessionsManager.getUploadedAttachment(documentReference, filename);
            attachment = uploadedAttachmentOpt.isEmpty() ? standardAttachment : (standardAttachment == null ? uploadedAttachmentOpt.get() : uploadedAttachmentOpt.get());
        }
        return attachment;
    }

    private void setCommonHeaders(XWikiAttachment attachment, XWikiRequest request, XWikiResponse response, XWikiContext context) {
        String mimetype = attachment.getMimeType(context);
        response.setContentType(mimetype);
        String characterEncoding = attachment.getCharset();
        if (characterEncoding != null) {
            response.setCharacterEncoding(characterEncoding);
        }
        String ofilename = Util.encodeURI(attachment.getFilename(), context).replaceAll("\\+", "%20");
        String dispType = "inline";
        boolean hasPR = false;
        String author = attachment.getAuthor();
        try {
            hasPR = context.getWiki().getRightService().hasAccessLevel("programming", author, "XWiki.XWikiPreferences", context);
        }
        catch (Exception e) {
            hasPR = false;
        }
        if (this.shouldBeDownloaded(hasPR, request, mimetype)) {
            dispType = ATTACHMENT;
        }
        response.addHeader("Content-disposition", dispType + "; filename*=utf-8''" + ofilename);
        response.setDateHeader("Last-Modified", attachment.getDate().getTime());
        response.setHeader("Accept-Ranges", "bytes");
    }

    private boolean isValidRange(Long start, Long end) {
        if (start == null && end == null) {
            return false;
        }
        return start == null || end == null || end >= start;
    }

    private boolean shouldBeDownloaded(boolean hasPR, XWikiRequest request, String mimeType) {
        ConfigurationSource configuration = Utils.getComponent(ConfigurationSource.class, "xwikiproperties");
        boolean whiteListExists = configuration.containsKey(WHITELIST_PROPERTY);
        boolean blackListExists = configuration.containsKey(BLACKLIST_PROPERTY);
        List blackList = (List)configuration.getProperty(BLACKLIST_PROPERTY, Collections.emptyList());
        List whiteList = (List)configuration.getProperty(WHITELIST_PROPERTY, MIMETYPE_WHITELIST);
        List forceDownloadList = (List)configuration.getProperty(FORCE_DOWNLOAD_PROPERTY, Collections.emptyList());
        boolean result = "1".equals(request.getParameter("force-download")) || forceDownloadList.contains(mimeType) ? true : (hasPR ? false : (blackListExists && !whiteListExists ? blackList.contains(mimeType) : !whiteList.contains(mimeType)));
        return result;
    }
}

