/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.doc.XWikiDocumentArchive;
import com.xpn.xwiki.web.DeleteVersionsForm;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiAction;
import com.xpn.xwiki.web.XWikiForm;
import javax.inject.Named;
import javax.inject.Singleton;
import org.suigeneris.jrcs.rcs.Version;
import org.xwiki.component.annotation.Component;

@Component
@Named(value="deleteversions")
@Singleton
public class DeleteVersionsAction
extends XWikiAction {
    @Override
    protected Class<? extends XWikiForm> getFormClass() {
        return DeleteVersionsForm.class;
    }

    @Override
    public boolean action(XWikiContext context) throws XWikiException {
        DeleteVersionsForm form = (DeleteVersionsForm)context.getForm();
        if (!form.isConfirmed() || !this.csrfTokenCheck(context)) {
            return true;
        }
        XWikiDocument doc = context.getDoc();
        String language = form.getLanguage();
        XWikiDocument tdoc = doc.getTranslatedDocument(language, context);
        XWikiDocumentArchive archive = tdoc.getDocumentArchive(context);
        Version[] versions = this.getVersionsFromForm(form, archive);
        Version v1 = versions[0];
        Version v2 = versions[1];
        if (v1 != null && v2 != null) {
            context.getWiki().deleteDocumentVersions(tdoc, v1.toString(), v2.toString(), true, context);
        }
        this.sendRedirect(context);
        return false;
    }

    private Version[] getVersionsFromForm(DeleteVersionsForm form, XWikiDocumentArchive archive) {
        String[] versions = new String[2];
        if (form.getRev() == null) {
            versions[0] = form.getRev1();
            versions[1] = form.getRev2();
        } else {
            versions[0] = form.getRev();
            versions[1] = form.getRev();
        }
        Version[] result = new Version[2];
        for (int i = 0; i < versions.length; ++i) {
            if ("latest".equals(versions[i])) {
                result[i] = archive.getLatestVersion();
                continue;
            }
            if ("previous".equals(versions[i])) {
                Version currentVersion = archive.getLatestVersion();
                result[i] = archive.getPrevVersion(currentVersion);
                continue;
            }
            try {
                result[i] = new Version(versions[i]);
                continue;
            }
            catch (Exception e) {
                result[i] = null;
            }
        }
        return result;
    }

    private void sendRedirect(XWikiContext context) throws XWikiException {
        String redirect = Utils.getRedirect("view", "viewer=history", context);
        this.sendRedirect(context.getResponse(), redirect);
    }

    @Override
    public String render(XWikiContext context) throws XWikiException {
        return "deleteversionsconfirm";
    }
}

