/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.util.Util;
import com.xpn.xwiki.web.CreateActionRequestHandler;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiAction;
import com.xpn.xwiki.web.XWikiRequest;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.script.ScriptContext;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.csrf.CSRFToken;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="create")
@Singleton
public class CreateAction
extends XWikiAction {
    private static final String CREATE_TEMPLATE = "create";
    private static final String PARENT = "parent";
    private static final String SPACE_REFERENCE = "spaceReference";
    private static final String NAME = "name";
    private static final String TEMPLATE = "template";
    private static final String IS_SPACE = "isSpace";
    private static final String WEBHOME = "WebHome";
    private static final String LOCAL_SERIALIZER_HINT = "local";
    private static final String FORM_TOKEN_PARAMETER = "form_token";
    @Inject
    private CSRFToken csrf;

    public CreateAction() {
        this.waitForXWikiInitialization = false;
    }

    @Override
    public String render(XWikiContext context) throws XWikiException {
        CreateActionRequestHandler handler = new CreateActionRequestHandler(context);
        handler.processRequest();
        ScriptContext scontext = this.getCurrentScriptContext();
        scontext.setAttribute(SPACE_REFERENCE, handler.getSpaceReference(), 100);
        scontext.setAttribute(NAME, handler.getName(), 100);
        scontext.setAttribute(IS_SPACE, handler.isSpace(), 100);
        scontext.setAttribute("availableTemplateProviders", handler.getAvailableTemplateProviders(), 100);
        scontext.setAttribute("recommendedTemplateProviders", handler.getRecommendedTemplateProviders(), 100);
        DocumentReference newDocumentReference = handler.getDocumentReference();
        if (newDocumentReference == null) {
            return CREATE_TEMPLATE;
        }
        this.checkRights(newDocumentReference.getLastSpaceReference(), context);
        XWikiDocument newDocument = context.getWiki().getDocument(newDocumentReference, context);
        if (handler.isDocumentAlreadyExisting(newDocument) || handler.isDocumentPathTooLong(newDocumentReference) || !this.isEntityReferenceNameValid((EntityReference)newDocumentReference) || !this.csrf.isTokenValid(context.getRequest().getParameter(FORM_TOKEN_PARAMETER))) {
            return CREATE_TEMPLATE;
        }
        if (!handler.isTemplateInfoProvided() || !handler.isTemplateProviderAllowedToCreateInCurrentSpace()) {
            return CREATE_TEMPLATE;
        }
        if (StringUtils.isBlank((CharSequence)handler.getType()) && !handler.hasTemplate()) {
            return CREATE_TEMPLATE;
        }
        this.doCreate(context, newDocument, handler.isSpace(), handler.getTemplateProvider());
        return null;
    }

    private void checkRights(SpaceReference spaceReference, XWikiContext context) throws XWikiException {
        ContextualAuthorizationManager authManager = Utils.getComponent(ContextualAuthorizationManager.class);
        if (!authManager.hasAccess(Right.EDIT, (EntityReference)spaceReference)) {
            Object[] args = new Object[]{spaceReference.toString(), context.getUser()};
            throw new XWikiException(9, 9001, "The creation of a document into the space {0} has been denied to user {1}", null, args);
        }
    }

    private void doCreate(XWikiContext context, XWikiDocument newDocument, boolean isSpace, BaseObject templateProvider) throws XWikiException {
        XWikiRequest request = context.getRequest();
        XWikiDocument doc = context.getDoc();
        String parent = this.getParent(request, doc, isSpace, context);
        String title = this.getTitle(request, newDocument, isSpace);
        String template = this.getTemplate(templateProvider, request);
        ActionOnCreate actionOnCreate = this.getActionOnCreate(templateProvider);
        String action = null;
        if (actionOnCreate == ActionOnCreate.SAVE_AND_EDIT) {
            this.initAndSaveDocument(context, newDocument, title, template, parent);
            action = newDocument.getDefaultEditMode(context);
        } else {
            action = actionOnCreate == ActionOnCreate.SAVE_AND_VIEW ? "save" : this.getEditMode(template, context);
        }
        String formToken = context.getRequest().getParameter(FORM_TOKEN_PARAMETER);
        String redirectParams = this.getRedirectParameters(parent, title, template, actionOnCreate, formToken);
        String redirectURL = newDocument.getURL(action, redirectParams, context);
        redirectURL = context.getResponse().encodeRedirectURL(redirectURL);
        if (context.getRequest().getParameterMap().containsKey("ajax")) {
            context.getResponse().setHeader("redirect", redirectURL);
        } else {
            this.sendRedirect(context.getResponse(), redirectURL);
        }
    }

    private void initAndSaveDocument(XWikiContext context, XWikiDocument newDocument, String title, String template, String parent) throws XWikiException {
        XWiki xwiki = context.getWiki();
        newDocument.setLocale(Locale.ROOT);
        if (newDocument.getDefaultLocale() == Locale.ROOT) {
            newDocument.setDefaultLocale(xwiki.getLocalePreference(context));
        }
        this.readFromTemplate(newDocument, template, context);
        if (!StringUtils.isEmpty((CharSequence)parent)) {
            DocumentReference parentReference = this.getCurrentMixedDocumentReferenceResolver().resolve((Object)parent, new Object[0]);
            newDocument.setParentReference((EntityReference)parentReference);
        }
        if (title != null) {
            newDocument.setTitle(title);
        }
        DocumentReference currentUserReference = context.getUserReference();
        newDocument.setAuthorReference(currentUserReference);
        newDocument.setCreatorReference(currentUserReference);
        xwiki.checkSavingDocument(currentUserReference, newDocument, context);
        xwiki.saveDocument(newDocument, context);
    }

    private String getRedirectParameters(String parent, String title, String template, ActionOnCreate actionOnCreate, String formToken) {
        if (actionOnCreate == ActionOnCreate.SAVE_AND_EDIT) {
            return null;
        }
        String redirectParams = "template=" + Util.encodeURI(template, null);
        if (parent != null) {
            redirectParams = redirectParams + "&parent=" + Util.encodeURI(parent, null);
        }
        if (title != null) {
            redirectParams = redirectParams + "&title=" + Util.encodeURI(title, null);
        }
        redirectParams = redirectParams + "&form_token=" + Util.encodeURI(formToken, null);
        return redirectParams;
    }

    private String getTemplate(BaseObject templateProvider, XWikiRequest request) {
        String result = "";
        if (templateProvider != null) {
            result = templateProvider.getStringValue(TEMPLATE);
        } else if (request.getParameter(TEMPLATE) != null) {
            result = request.getParameter(TEMPLATE);
        }
        return result;
    }

    private String getParent(XWikiRequest request, XWikiDocument doc, boolean isSpace, XWikiContext context) {
        String parent = request.getParameter(PARENT);
        if (StringUtils.isEmpty((CharSequence)parent)) {
            EntityReferenceSerializer localSerializer = (EntityReferenceSerializer)Utils.getComponent(EntityReferenceSerializer.TYPE_STRING, LOCAL_SERIALIZER_HINT);
            if (doc.isNew()) {
                Provider defaultDocumentReferenceProvider = (Provider)Utils.getComponent(DocumentReference.TYPE_PROVIDER);
                DocumentReference parentRef = ((DocumentReference)defaultDocumentReferenceProvider.get()).setWikiReference(context.getWikiReference());
                parent = (String)localSerializer.serialize((EntityReference)parentRef, new Object[0]);
            } else {
                DocumentReference parentRef = doc.getDocumentReference();
                parent = (String)localSerializer.serialize((EntityReference)parentRef, new Object[0]);
            }
        }
        return parent;
    }

    private String getTitle(XWikiRequest request, XWikiDocument newDocument, boolean isSpace) {
        String title = request.getParameter("title");
        if (StringUtils.isEmpty((CharSequence)title)) {
            if (isSpace) {
                title = newDocument.getDocumentReference().getLastSpaceReference().getName();
            } else {
                title = newDocument.getDocumentReference().getName();
                if (WEBHOME.equals(title)) {
                    title = newDocument.getDocumentReference().getLastSpaceReference().getName();
                }
            }
        }
        return title;
    }

    private ActionOnCreate getActionOnCreate(BaseObject templateProvider) {
        String action;
        ActionOnCreate actionOnCreate;
        if (templateProvider != null && (actionOnCreate = ActionOnCreate.valueOfAction(action = templateProvider.getStringValue("action"))) != null) {
            return actionOnCreate;
        }
        return ActionOnCreate.EDIT;
    }

    private String getEditMode(String template, XWikiContext context) throws XWikiException {
        DocumentReference templateReference;
        String editAction = ActionOnCreate.EDIT.name().toLowerCase();
        XWiki xwiki = context.getWiki();
        if (!StringUtils.isEmpty((CharSequence)template) && xwiki.exists(templateReference = this.getCurrentMixedDocumentReferenceResolver().resolve((Object)template, new Object[0]), context)) {
            editAction = xwiki.getDocument(templateReference, context).getDefaultEditMode(context);
        }
        return editAction;
    }

    private static enum ActionOnCreate {
        EDIT("edit"),
        SAVE_AND_EDIT("saveandedit"),
        SAVE_AND_VIEW("saveandview");

        private static final Map<String, ActionOnCreate> BY_ACTION;
        private final String action;

        private ActionOnCreate(String action) {
            this.action = action;
        }

        public static ActionOnCreate valueOfAction(String action) {
            return BY_ACTION.get(action);
        }

        static {
            BY_ACTION = new HashMap<String, ActionOnCreate>();
            for (ActionOnCreate actionOnCreate : ActionOnCreate.values()) {
                BY_ACTION.put(actionOnCreate.action, actionOnCreate);
            }
        }
    }
}

