/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.doc.XWikiLock;
import com.xpn.xwiki.web.EditForm;
import com.xpn.xwiki.web.XWikiAction;
import com.xpn.xwiki.web.XWikiForm;
import com.xpn.xwiki.web.XWikiRequest;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.annotation.Component;

@Component
@Named(value="admin")
@Singleton
public class AdminAction
extends XWikiAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdminAction.class);

    public AdminAction() {
        this.waitForXWikiInitialization = false;
    }

    @Override
    protected Class<? extends XWikiForm> getFormClass() {
        return EditForm.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String render(XWikiContext context) throws XWikiException {
        XWikiRequest request = context.getRequest();
        String content = request.getParameter("content");
        XWikiDocument doc = context.getDoc();
        XWikiForm form = context.getForm();
        XWikiDocument xWikiDocument = doc;
        synchronized (xWikiDocument) {
            EditForm peform;
            XWikiDocument tdoc;
            block20: {
                String languagetoedit;
                String defaultLanguage;
                String defaultTemplate;
                String creator;
                tdoc = (XWikiDocument)context.get("tdoc");
                peform = (EditForm)form;
                String parent = peform.getParent();
                if (parent != null) {
                    doc.setParent(parent);
                }
                if ((creator = peform.getCreator()) != null) {
                    doc.setCreator(creator);
                }
                if ((defaultTemplate = peform.getDefaultTemplate()) != null) {
                    doc.setDefaultTemplate(defaultTemplate);
                }
                if ((defaultLanguage = peform.getDefaultLanguage()) != null && !defaultLanguage.equals("")) {
                    doc.setDefaultLanguage(defaultLanguage);
                }
                if (doc.getDefaultLanguage().equals("")) {
                    doc.setDefaultLanguage(context.getWiki().getLanguagePreference(context));
                }
                String language = context.getWiki().getLanguagePreference(context);
                String languagefromrequest = context.getRequest().getParameter("language");
                String string = languagetoedit = languagefromrequest == null || languagefromrequest.equals("") ? language : languagefromrequest;
                if (languagetoedit == null || languagetoedit.equals("default")) {
                    languagetoedit = "";
                }
                if (doc.isNew() || doc.getDefaultLanguage().equals(languagetoedit)) {
                    languagetoedit = "";
                }
                if (languagetoedit.equals("")) {
                    tdoc = doc;
                    context.put("tdoc", doc);
                    if (doc.isNew()) {
                        doc.setDefaultLanguage(language);
                        doc.setLanguage("");
                    }
                } else if (tdoc == doc) {
                    tdoc = new XWikiDocument(doc.getDocumentReference());
                    tdoc.setLanguage(languagetoedit);
                    tdoc.setContent(doc.getContent());
                    tdoc.setSyntax(doc.getSyntax());
                    tdoc.setAuthor(context.getUser());
                    tdoc.setStore(doc.getStore());
                    context.put("tdoc", tdoc);
                }
                XWikiDocument tdoc2 = tdoc.clone();
                if (content != null && !content.isEmpty()) {
                    tdoc2.setContent(content);
                }
                context.put("tdoc", tdoc2);
                try {
                    this.readFromTemplate(tdoc2, peform.getTemplate(), context);
                }
                catch (XWikiException e) {
                    if (e.getCode() != 11002) break block20;
                    context.put("exception", e);
                    return "docalreadyexists";
                }
            }
            try {
                XWikiLock lock = tdoc.getLock(context);
                if (lock == null || lock.getUserName().equals(context.getUser()) || peform.isLockForce()) {
                    tdoc.setLock(context.getUser(), context);
                }
            }
            catch (Exception e) {
                LOGGER.error("Exception while setting up lock", (Throwable)e);
            }
        }
        return "admin";
    }
}

