/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.validation;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.web.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.script.ScriptContext;
import org.xwiki.script.ScriptContextManager;

public class XWikiValidationStatus {
    private List errorObjects = new ArrayList();
    private List propertyErrors = new ArrayList();
    private List errors = new ArrayList();
    private List exceptions = new ArrayList();

    public static void addErrorToContext(String className, String propName, String propPrettyName, String validationMessage, XWikiContext context) {
        XWikiValidationStatus errors = XWikiValidationStatus.getValidationStatus(context);
        errors.addError(className, propName, propPrettyName, validationMessage, context);
    }

    private static XWikiValidationStatus getValidationStatus(XWikiContext context) {
        XWikiValidationStatus errors = context.getValidationStatus();
        if (errors == null) {
            errors = new XWikiValidationStatus();
            context.setValidationStatus(errors);
        }
        return errors;
    }

    public static void addExceptionToContext(String className, String propName, Throwable e, XWikiContext context) {
        XWikiValidationStatus errors = XWikiValidationStatus.getValidationStatus(context);
        errors.addException(className, propName, e, context);
    }

    public void addError(String className, String propName, String propPrettyName, String validationMessage, XWikiContext context) {
        this.getErrorObjects().add(className);
        this.getPropertyErrors().add(propName);
        if (validationMessage != null && !validationMessage.trim().equals("")) {
            this.getErrors().add(validationMessage);
        } else {
            ScriptContextManager scriptManager = Utils.getComponent(ScriptContextManager.class);
            ScriptContext scontext = scriptManager.getCurrentScriptContext();
            if (scontext == null) {
                this.getErrors().add("Validation error for property " + propPrettyName + " in class " + className);
            } else {
                scontext.setAttribute("className", className, 100);
                scontext.setAttribute("propName", propPrettyName, 100);
                String message = context.getMessageTool().get("validationerror", Collections.singletonList(propName));
                this.getErrors().add(message);
            }
        }
    }

    public void addException(String className, String propName, Throwable e, XWikiContext context) {
        this.getExceptions().add(e);
    }

    public boolean hasExceptions() {
        return this.getExceptions().size() > 0;
    }

    public List getExceptions() {
        return this.exceptions;
    }

    public List getErrorObjects() {
        return this.errorObjects;
    }

    public void setErrorObjects(List errorObjects) {
        this.errorObjects = errorObjects;
    }

    public List getPropertyErrors() {
        return this.propertyErrors;
    }

    public void setPropertyErrors(List propertyErrors) {
        this.propertyErrors = propertyErrors;
    }

    public List getErrors() {
        return this.errors;
    }

    public void setErrors(List errors) {
        this.errors = errors;
    }

    public void setExceptions(List exceptions) {
        this.exceptions = exceptions;
    }
}

