/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.util;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.monitor.api.MonitorPlugin;
import com.xpn.xwiki.render.WikiSubstitution;
import com.xpn.xwiki.util.UtilCompatibilityAspect;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiRequest;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Vector;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.oro.text.PatternCache;
import org.apache.oro.text.PatternCacheLRU;
import org.apache.oro.text.perl.Perl5Util;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xwiki.environment.Environment;
import org.xwiki.xml.XMLUtils;

public class Util {
    private static final String URL_ENCODING = "UTF-8";
    private static final Logger LOGGER = LoggerFactory.getLogger(Util.class);
    private static PatternCache patterns = new PatternCacheLRU(200);
    private Perl5Matcher matcher = new Perl5Matcher();
    private Perl5Util p5util = new Perl5Util(Util.getPatterns());

    public String substitute(String pattern, String text) {
        return this.getP5util().substitute(pattern, text);
    }

    public boolean match(String pattern, String text) {
        return this.getP5util().match(pattern, text);
    }

    public boolean matched() {
        return this.getP5util().getMatch() != null;
    }

    public String substitute(String pattern, String substitution, String text) {
        WikiSubstitution subst = new WikiSubstitution(this, pattern);
        subst.setSubstitution(substitution);
        return subst.substitute(text);
    }

    public Perl5Matcher getMatcher() {
        return this.matcher;
    }

    public Perl5Util getP5util() {
        return this.p5util;
    }

    public List<String> getAllMatches(String content, String spattern, int group) throws MalformedPatternException {
        ArrayList<String> list = new ArrayList<String>();
        PatternMatcherInput input2 = new PatternMatcherInput(content);
        Pattern pattern = patterns.addPattern(spattern);
        while (this.matcher.contains(input2, pattern)) {
            MatchResult result = this.matcher.getMatch();
            String smatch = result.group(group);
            list.add(smatch);
        }
        return list;
    }

    public List<String> getUniqueMatches(String content, String spattern, int group) throws MalformedPatternException {
        HashSet<String> uniqueMatches = new HashSet<String>();
        uniqueMatches.addAll(this.getAllMatches(content, spattern, group));
        ArrayList<String> matches = new ArrayList<String>();
        matches.addAll(uniqueMatches);
        return matches;
    }

    public static String cleanValue(String value) {
        value = StringUtils.replace((String)value, (String)"\r\r\n", (String)"%_N_%");
        value = StringUtils.replace((String)value, (String)"\r\n", (String)"%_N_%");
        value = StringUtils.replace((String)value, (String)"\n\r", (String)"%_N_%");
        value = StringUtils.replace((String)value, (String)"\r", (String)"\n");
        value = StringUtils.replace((String)value, (String)"\n", (String)"%_N_%");
        value = StringUtils.replace((String)value, (String)"\"", (String)"%_Q_%");
        return value;
    }

    public static String restoreValue(String value) {
        value = StringUtils.replace((String)value, (String)"%_N_%", (String)"\n");
        value = StringUtils.replace((String)value, (String)"%_Q_%", (String)"\"");
        return value;
    }

    public static Hashtable<String, String> keyValueToHashtable(String mapString) throws IOException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        StreamTokenizer st = new StreamTokenizer(new BufferedReader(new StringReader(mapString)));
        st.resetSyntax();
        st.quoteChar(34);
        st.wordChars(97, 122);
        st.wordChars(65, 90);
        st.whitespaceChars(32, 32);
        st.whitespaceChars(61, 61);
        while (st.nextToken() != -1) {
            String key = st.sval;
            st.nextToken();
            String value = st.sval != null ? st.sval : "";
            result.put(key, Util.restoreValue(value));
        }
        return result;
    }

    public static PatternCache getPatterns() {
        return patterns;
    }

    @Deprecated(since="17.0.0RC1")
    public static Map<String, String[]> getObject(XWikiRequest request, String prefix) {
        Map parameters = request.getParameterMap();
        return Util.getSubMap(parameters, prefix);
    }

    public static <T> Map<String, T> getSubMap(Map<String, T> map, String prefix) {
        HashMap<String, T> result = new HashMap<String, T>();
        for (String name : map.keySet()) {
            if (name.startsWith(prefix + "_")) {
                String newname = name.substring(prefix.length() + 1);
                result.put(newname, map.get(name));
                continue;
            }
            if (!name.equals(prefix)) continue;
            result.put("", map.get(name));
        }
        return result;
    }

    public static String getWeb(String fullname) {
        int i = fullname.lastIndexOf(".");
        return fullname.substring(0, i);
    }

    public Vector<String> split(String pattern, String text) {
        Vector<String> results = new Vector<String>();
        this.getP5util().split(results, pattern, text);
        return results;
    }

    public static boolean contains(String name, String list, String sep) {
        Object[] sarray = StringUtils.split((String)list, (String)sep);
        return ArrayUtils.contains((Object[])sarray, (Object)name);
    }

    public static String noaccents(String text) {
        String temp = text;
        temp = temp.replaceAll("\u00c0", "A");
        temp = temp.replaceAll("\u00c1", "A");
        temp = temp.replaceAll("\u00c2", "A");
        temp = temp.replaceAll("\u00c3", "A");
        temp = temp.replaceAll("\u00c4", "A");
        temp = temp.replaceAll("\u00c5", "A");
        temp = temp.replaceAll("\u0100", "A");
        temp = temp.replaceAll("\u0102", "A");
        temp = temp.replaceAll("\u0104", "A");
        temp = temp.replaceAll("\u01cd", "A");
        temp = temp.replaceAll("\u01de", "A");
        temp = temp.replaceAll("\u01e0", "A");
        temp = temp.replaceAll("\u01fa", "A");
        temp = temp.replaceAll("\u0200", "A");
        temp = temp.replaceAll("\u0202", "A");
        temp = temp.replaceAll("\u0226", "A");
        temp = temp.replaceAll("\u00e0", "a");
        temp = temp.replaceAll("\u00e1", "a");
        temp = temp.replaceAll("\u00e2", "a");
        temp = temp.replaceAll("\u00e3", "a");
        temp = temp.replaceAll("\u00e4", "a");
        temp = temp.replaceAll("\u00e5", "a");
        temp = temp.replaceAll("\u0101", "a");
        temp = temp.replaceAll("\u0103", "a");
        temp = temp.replaceAll("\u0105", "a");
        temp = temp.replaceAll("\u01ce", "a");
        temp = temp.replaceAll("\u01df", "a");
        temp = temp.replaceAll("\u01e1", "a");
        temp = temp.replaceAll("\u01fb", "a");
        temp = temp.replaceAll("\u0201", "a");
        temp = temp.replaceAll("\u0203", "a");
        temp = temp.replaceAll("\u0227", "a");
        temp = temp.replaceAll("\u00c6", "AE");
        temp = temp.replaceAll("\u01e2", "AE");
        temp = temp.replaceAll("\u01fc", "AE");
        temp = temp.replaceAll("\u00e6", "ae");
        temp = temp.replaceAll("\u01e3", "ae");
        temp = temp.replaceAll("\u01fd", "ae");
        temp = temp.replaceAll("\u008c", "OE");
        temp = temp.replaceAll("\u0152", "OE");
        temp = temp.replaceAll("\u009c", "oe");
        temp = temp.replaceAll("\u0153", "oe");
        temp = temp.replaceAll("\u00c7", "C");
        temp = temp.replaceAll("\u0106", "C");
        temp = temp.replaceAll("\u0108", "C");
        temp = temp.replaceAll("\u010a", "C");
        temp = temp.replaceAll("\u010c", "C");
        temp = temp.replaceAll("\u00e7", "c");
        temp = temp.replaceAll("\u0107", "c");
        temp = temp.replaceAll("\u0109", "c");
        temp = temp.replaceAll("\u010b", "c");
        temp = temp.replaceAll("\u010d", "c");
        temp = temp.replaceAll("\u00d0", "D");
        temp = temp.replaceAll("\u010e", "D");
        temp = temp.replaceAll("\u0110", "D");
        temp = temp.replaceAll("\u00f0", "d");
        temp = temp.replaceAll("\u010f", "d");
        temp = temp.replaceAll("\u0111", "d");
        temp = temp.replaceAll("\u00c8", "E");
        temp = temp.replaceAll("\u00c9", "E");
        temp = temp.replaceAll("\u00ca", "E");
        temp = temp.replaceAll("\u00cb", "E");
        temp = temp.replaceAll("\u0112", "E");
        temp = temp.replaceAll("\u0114", "E");
        temp = temp.replaceAll("\u0116", "E");
        temp = temp.replaceAll("\u0118", "E");
        temp = temp.replaceAll("\u011a", "E");
        temp = temp.replaceAll("\u0204", "E");
        temp = temp.replaceAll("\u0206", "E");
        temp = temp.replaceAll("\u0228", "E");
        temp = temp.replaceAll("\u00e8", "e");
        temp = temp.replaceAll("\u00e9", "e");
        temp = temp.replaceAll("\u00ea", "e");
        temp = temp.replaceAll("\u00eb", "e");
        temp = temp.replaceAll("\u0113", "e");
        temp = temp.replaceAll("\u0115", "e");
        temp = temp.replaceAll("\u0117", "e");
        temp = temp.replaceAll("\u0119", "e");
        temp = temp.replaceAll("\u011b", "e");
        temp = temp.replaceAll("\u01dd", "e");
        temp = temp.replaceAll("\u0205", "e");
        temp = temp.replaceAll("\u0207", "e");
        temp = temp.replaceAll("\u0229", "e");
        temp = temp.replaceAll("\u011c", "G");
        temp = temp.replaceAll("\u011e", "G");
        temp = temp.replaceAll("\u0120", "G");
        temp = temp.replaceAll("\u0122", "G");
        temp = temp.replaceAll("\u01e4", "G");
        temp = temp.replaceAll("\u01e6", "G");
        temp = temp.replaceAll("\u01f4", "G");
        temp = temp.replaceAll("\u011d", "g");
        temp = temp.replaceAll("\u011f", "g");
        temp = temp.replaceAll("\u0121", "g");
        temp = temp.replaceAll("\u0123", "g");
        temp = temp.replaceAll("\u01e5", "g");
        temp = temp.replaceAll("\u01e7", "g");
        temp = temp.replaceAll("\u01f5", "g");
        temp = temp.replaceAll("\u0124", "H");
        temp = temp.replaceAll("\u0126", "H");
        temp = temp.replaceAll("\u021e", "H");
        temp = temp.replaceAll("\u0125", "h");
        temp = temp.replaceAll("\u0127", "h");
        temp = temp.replaceAll("\u021f", "h");
        temp = temp.replaceAll("\u00cc", "I");
        temp = temp.replaceAll("\u00cd", "I");
        temp = temp.replaceAll("\u00ce", "I");
        temp = temp.replaceAll("\u00cf", "I");
        temp = temp.replaceAll("\u0128", "I");
        temp = temp.replaceAll("\u012a", "I");
        temp = temp.replaceAll("\u012c", "I");
        temp = temp.replaceAll("\u012e", "I");
        temp = temp.replaceAll("\u0130", "I");
        temp = temp.replaceAll("\u01cf", "I");
        temp = temp.replaceAll("\u0208", "I");
        temp = temp.replaceAll("\u020a", "I");
        temp = temp.replaceAll("\u00ec", "i");
        temp = temp.replaceAll("\u00ed", "i");
        temp = temp.replaceAll("\u00ee", "i");
        temp = temp.replaceAll("\u00ef", "i");
        temp = temp.replaceAll("\u0129", "i");
        temp = temp.replaceAll("\u012b", "i");
        temp = temp.replaceAll("\u012d", "i");
        temp = temp.replaceAll("\u012f", "i");
        temp = temp.replaceAll("\u0131", "i");
        temp = temp.replaceAll("\u01d0", "i");
        temp = temp.replaceAll("\u0209", "i");
        temp = temp.replaceAll("\u020b", "i");
        temp = temp.replaceAll("\u0132", "IJ");
        temp = temp.replaceAll("\u0133", "ij");
        temp = temp.replaceAll("\u0134", "J");
        temp = temp.replaceAll("\u0135", "j");
        temp = temp.replaceAll("\u0136", "K");
        temp = temp.replaceAll("\u01e8", "K");
        temp = temp.replaceAll("\u0137", "k");
        temp = temp.replaceAll("\u0138", "k");
        temp = temp.replaceAll("\u01e9", "k");
        temp = temp.replaceAll("\u0139", "L");
        temp = temp.replaceAll("\u013b", "L");
        temp = temp.replaceAll("\u013d", "L");
        temp = temp.replaceAll("\u013f", "L");
        temp = temp.replaceAll("\u0141", "L");
        temp = temp.replaceAll("\u013a", "l");
        temp = temp.replaceAll("\u013c", "l");
        temp = temp.replaceAll("\u013e", "l");
        temp = temp.replaceAll("\u0140", "l");
        temp = temp.replaceAll("\u0142", "l");
        temp = temp.replaceAll("\u0234", "l");
        temp = temp.replaceAll("\u00d1", "N");
        temp = temp.replaceAll("\u0143", "N");
        temp = temp.replaceAll("\u0145", "N");
        temp = temp.replaceAll("\u0147", "N");
        temp = temp.replaceAll("\u014a", "N");
        temp = temp.replaceAll("\u01f8", "N");
        temp = temp.replaceAll("\u00f1", "n");
        temp = temp.replaceAll("\u0144", "n");
        temp = temp.replaceAll("\u0146", "n");
        temp = temp.replaceAll("\u0148", "n");
        temp = temp.replaceAll("\u0149", "n");
        temp = temp.replaceAll("\u014b", "n");
        temp = temp.replaceAll("\u01f9", "n");
        temp = temp.replaceAll("\u0235", "n");
        temp = temp.replaceAll("\u00d2", "O");
        temp = temp.replaceAll("\u00d3", "O");
        temp = temp.replaceAll("\u00d4", "O");
        temp = temp.replaceAll("\u00d5", "O");
        temp = temp.replaceAll("\u00d6", "O");
        temp = temp.replaceAll("\u00d8", "O");
        temp = temp.replaceAll("\u014c", "O");
        temp = temp.replaceAll("\u014e", "O");
        temp = temp.replaceAll("\u0150", "O");
        temp = temp.replaceAll("\u01d1", "O");
        temp = temp.replaceAll("\u01ea", "O");
        temp = temp.replaceAll("\u01ec", "O");
        temp = temp.replaceAll("\u01fe", "O");
        temp = temp.replaceAll("\u020c", "O");
        temp = temp.replaceAll("\u020e", "O");
        temp = temp.replaceAll("\u022a", "O");
        temp = temp.replaceAll("\u022c", "O");
        temp = temp.replaceAll("\u022e", "O");
        temp = temp.replaceAll("\u0230", "O");
        temp = temp.replaceAll("\u00f2", "o");
        temp = temp.replaceAll("\u00f3", "o");
        temp = temp.replaceAll("\u00f4", "o");
        temp = temp.replaceAll("\u00f5", "o");
        temp = temp.replaceAll("\u00f6", "o");
        temp = temp.replaceAll("\u00f8", "o");
        temp = temp.replaceAll("\u014d", "o");
        temp = temp.replaceAll("\u014f", "o");
        temp = temp.replaceAll("\u0151", "o");
        temp = temp.replaceAll("\u01d2", "o");
        temp = temp.replaceAll("\u01eb", "o");
        temp = temp.replaceAll("\u01ed", "o");
        temp = temp.replaceAll("\u01ff", "o");
        temp = temp.replaceAll("\u020d", "o");
        temp = temp.replaceAll("\u020f", "o");
        temp = temp.replaceAll("\u022b", "o");
        temp = temp.replaceAll("\u022d", "o");
        temp = temp.replaceAll("\u022f", "o");
        temp = temp.replaceAll("\u0231", "o");
        temp = temp.replaceAll("\u0156", "R");
        temp = temp.replaceAll("\u0158", "R");
        temp = temp.replaceAll("\u0210", "R");
        temp = temp.replaceAll("\u0212", "R");
        temp = temp.replaceAll("\u0157", "r");
        temp = temp.replaceAll("\u0159", "r");
        temp = temp.replaceAll("\u0211", "r");
        temp = temp.replaceAll("\u0213", "r");
        temp = temp.replaceAll("\u015a", "S");
        temp = temp.replaceAll("\u015c", "S");
        temp = temp.replaceAll("\u015e", "S");
        temp = temp.replaceAll("\u0160", "S");
        temp = temp.replaceAll("\u0218", "S");
        temp = temp.replaceAll("\u015b", "s");
        temp = temp.replaceAll("\u015d", "s");
        temp = temp.replaceAll("\u015f", "s");
        temp = temp.replaceAll("\u0161", "s");
        temp = temp.replaceAll("\u0219", "s");
        temp = temp.replaceAll("\u00de", "T");
        temp = temp.replaceAll("\u0162", "T");
        temp = temp.replaceAll("\u0164", "T");
        temp = temp.replaceAll("\u0166", "T");
        temp = temp.replaceAll("\u021a", "T");
        temp = temp.replaceAll("\u00fe", "t");
        temp = temp.replaceAll("\u0163", "t");
        temp = temp.replaceAll("\u0165", "t");
        temp = temp.replaceAll("\u0167", "t");
        temp = temp.replaceAll("\u021b", "t");
        temp = temp.replaceAll("\u0236", "t");
        temp = temp.replaceAll("\u00d9", "U");
        temp = temp.replaceAll("\u00da", "U");
        temp = temp.replaceAll("\u00db", "U");
        temp = temp.replaceAll("\u00dc", "U");
        temp = temp.replaceAll("\u0168", "U");
        temp = temp.replaceAll("\u016a", "U");
        temp = temp.replaceAll("\u016c", "U");
        temp = temp.replaceAll("\u016e", "U");
        temp = temp.replaceAll("\u0170", "U");
        temp = temp.replaceAll("\u0172", "U");
        temp = temp.replaceAll("\u01d3", "U");
        temp = temp.replaceAll("\u01d5", "U");
        temp = temp.replaceAll("\u01d7", "U");
        temp = temp.replaceAll("\u01d9", "U");
        temp = temp.replaceAll("\u01db", "U");
        temp = temp.replaceAll("\u0214", "U");
        temp = temp.replaceAll("\u0216", "U");
        temp = temp.replaceAll("\u00f9", "u");
        temp = temp.replaceAll("\u00fa", "u");
        temp = temp.replaceAll("\u00fb", "u");
        temp = temp.replaceAll("\u00fc", "u");
        temp = temp.replaceAll("\u0169", "u");
        temp = temp.replaceAll("\u016b", "u");
        temp = temp.replaceAll("\u016d", "u");
        temp = temp.replaceAll("\u016f", "u");
        temp = temp.replaceAll("\u0171", "u");
        temp = temp.replaceAll("\u0173", "u");
        temp = temp.replaceAll("\u01d4", "u");
        temp = temp.replaceAll("\u01d6", "u");
        temp = temp.replaceAll("\u01d8", "u");
        temp = temp.replaceAll("\u01da", "u");
        temp = temp.replaceAll("\u01dc", "u");
        temp = temp.replaceAll("\u0215", "u");
        temp = temp.replaceAll("\u0217", "u");
        temp = temp.replaceAll("\u0174", "W");
        temp = temp.replaceAll("\u0175", "w");
        temp = temp.replaceAll("\u00dd", "Y");
        temp = temp.replaceAll("\u0176", "Y");
        temp = temp.replaceAll("\u0178", "Y");
        temp = temp.replaceAll("\u0232", "Y");
        temp = temp.replaceAll("\u00fd", "y");
        temp = temp.replaceAll("\u00ff", "y");
        temp = temp.replaceAll("\u0177", "y");
        temp = temp.replaceAll("\u0233", "y");
        temp = temp.replaceAll("\u0179", "Z");
        temp = temp.replaceAll("\u017b", "Z");
        temp = temp.replaceAll("\u017d", "Z");
        temp = temp.replaceAll("\u017a", "z");
        temp = temp.replaceAll("\u017c", "z");
        temp = temp.replaceAll("\u017e", "z");
        temp = temp.replaceAll("\u00df", "ss");
        return temp;
    }

    public static boolean isAlphaNumeric(String text) {
        return StringUtils.isAlphanumeric((CharSequence)text.replace('-', 'a').replace('.', 'a'));
    }

    public static String getName(String name) {
        int i0 = name.indexOf(":");
        if (i0 != -1) {
            name = name.substring(i0 + 1);
            return name;
        }
        if (name.indexOf(".") != -1) {
            return name;
        }
        return "XWiki." + name;
    }

    public static String getName(String name, XWikiContext context) {
        String database = null;
        int i0 = name.indexOf(":");
        if (i0 != -1) {
            database = name.substring(0, i0);
            name = name.substring(i0 + 1);
            context.setWikiId(database);
            return name;
        }
        if (name.indexOf(".") != -1) {
            return name;
        }
        return "XWiki." + name;
    }

    public static Cookie getCookie(String cookieName, XWikiContext context) {
        return Util.getCookie(cookieName, context.getRequest());
    }

    public static Cookie getCookie(String cookieName, HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookieName.equals(cookie.getName())) continue;
                return cookie;
            }
        }
        return null;
    }

    public static String getHTMLExceptionMessage(XWikiException xe, XWikiContext context) {
        String title = XMLUtils.escape((String)xe.getMessage());
        String text = XMLUtils.escape((String)xe.getFullMessage());
        return "<div class=\"xwikirenderingerror\" title=\"Read technical information related to this error\" style=\"cursor: pointer;\">" + title + "</div><div class=\"xwikirenderingerrordescription hidden\"><pre>" + text + "</pre></div>";
    }

    public static MonitorPlugin getMonitorPlugin(XWikiContext context) {
        try {
            if (context == null || context.getWiki() == null) {
                return null;
            }
            return (MonitorPlugin)context.getWiki().getPlugin("monitor", context);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Deprecated
    public static String escapeText(String text) {
        text = text.replaceAll("http://", "&#104;ttp://");
        text = text.replaceAll("ftp://", "&#102;tp://");
        text = text.replaceAll("\\-", "&#45;");
        text = text.replaceAll("\\*", "&#42;");
        text = text.replaceAll("\\~", "&#126;");
        text = text.replaceAll("\\[", "&#91;");
        text = text.replaceAll("\\]", "&#93;");
        text = text.replaceAll("\\{", "&#123;");
        text = text.replaceAll("\\}", "&#125;");
        text = text.replaceAll("\\1", "&#49;");
        return text;
    }

    @Deprecated
    public static String escapeURL(String url) {
        url = url.replaceAll("\\~", "%7E");
        url = url.replaceAll("\\[", "%5B");
        url = url.replaceAll("\\]", "%5D");
        url = url.replaceAll("\\{", "%7B");
        if ((url = url.replaceAll("\\}", "%7D")).indexOf("//") == -1) {
            url = url.replaceAll("-", "%2D");
            url = url.replaceAll("\\*", "%2A");
        }
        return url;
    }

    public static String encodeURI(String text, XWikiContext context) {
        try {
            return URLEncoder.encode(text, URL_ENCODING);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String decodeURI(String text, XWikiContext context) {
        try {
            return URLDecoder.decode(text, URL_ENCODING);
        }
        catch (Exception e) {
            return text;
        }
    }

    public static String convertToAlphaNumeric(String text) {
        char[] testChars;
        String textNoAccents = Util.noaccents(text);
        StringBuffer result = new StringBuffer(textNoAccents.length());
        for (char testChar : testChars = textNoAccents.toCharArray()) {
            if (!Character.isLetterOrDigit(testChar) || testChar >= '\u0080') continue;
            result.append(testChar);
        }
        return result.toString();
    }

    public static Date getFileLastModificationDate(String path) {
        try {
            File f = new File(path);
            return new Date(f.lastModified());
        }
        catch (Exception ex) {
            return new Date();
        }
    }

    public static boolean isValidXMLElementName(String elementName) {
        return elementName != null && !elementName.equals("") && !elementName.matches("(?i)^(xml).*") && elementName.matches("(^[a-zA-Z\\_]+[\\w\\.\\-]*$)");
    }

    public static InputStream getResourceAsStream(String resource) {
        File file = new File(resource);
        try {
            if (file.exists()) {
                return new FileInputStream(file);
            }
        }
        catch (Exception e) {
            LOGGER.debug("Failed load resource [{}] using a file path", (Object)resource);
        }
        try {
            Environment environment = Utils.getComponent(Environment.class);
            InputStream res = environment.getResourceAsStream(resource);
            if (res != null) {
                return res;
            }
        }
        catch (Exception e) {
            LOGGER.debug("Failed to load resource [{}] using the application context", (Object)resource);
        }
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
    }

    public static URL getResource(String resource) {
        File file = new File(resource);
        try {
            if (file.exists()) {
                return file.toURI().toURL();
            }
        }
        catch (Exception e) {
            LOGGER.debug("Failed load resource [{}] using a file path", (Object)resource);
        }
        try {
            Environment environment = Utils.getComponent(Environment.class);
            URL res = environment.getResource(resource);
            if (res != null) {
                return res;
            }
        }
        catch (Exception e) {
            LOGGER.debug("Failed to load resource [{}] using the application context", (Object)resource);
        }
        return Thread.currentThread().getContextClassLoader().getResource(resource);
    }

    public static String normalizeLanguage(String languageCode) {
        if (languageCode == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)languageCode)) {
            return "";
        }
        String separator = "_";
        String[] parts = StringUtils.split((String)languageCode.toLowerCase(), (String)"_-.");
        Object result = parts[0];
        if (parts.length > 1) {
            parts[1] = parts[1].toUpperCase();
            result = parts[0] + "_" + parts[1];
        }
        String defaultLanguage = "default";
        if ("default".equals(result)) {
            return "default";
        }
        try {
            Locale l = new Locale(parts[0], parts.length > 1 ? parts[1] : "");
            l.getISO3Language();
            return result;
        }
        catch (MissingResourceException ex) {
            LOGGER.warn("Invalid language: " + languageCode);
            return "default";
        }
    }

    public static long getHash(String uid) {
        long hash = 0L;
        try {
            byte[] digest = DigestUtils.md5((String)uid);
            int l = digest.length;
            for (int i = Math.max(0, digest.length - 9); i < l; ++i) {
                hash = hash << 8 | (long)digest[i] & 0xFFL;
            }
        }
        catch (Exception ex) {
            LOGGER.error("Id computation failed during MD5 processing", (Throwable)ex);
            throw new RuntimeException("MD5 hash is required for id hash");
        }
        return hash;
    }

    public static /* synthetic */ Logger ajc$get$LOGGER() {
        return LOGGER;
    }

    public static /* synthetic */ void ajc$set$LOGGER(Logger logger) {
        LOGGER = logger;
    }

    @Deprecated(since="14.10")
    public Document getDOMDocument() {
        return UtilCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_util_UtilCompatibilityAspect$com_xpn_xwiki_util_Util$getDOMDocument(this);
    }

    @Deprecated(since="14.10")
    public Document getDOMForString(String string) {
        return UtilCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_util_UtilCompatibilityAspect$com_xpn_xwiki_util_Util$getDOMForString(this, string);
    }

    @Deprecated
    public static String getFileContent(File file) throws IOException {
        return UtilCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_util_UtilCompatibilityAspect$com_xpn_xwiki_util_Util$getFileContent(file);
    }

    @Deprecated
    public static String getFileContent(Reader reader) throws IOException {
        return UtilCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_util_UtilCompatibilityAspect$com_xpn_xwiki_util_Util$getFileContent(reader);
    }

    @Deprecated
    public static byte[] getFileContentAsBytes(File file) throws IOException {
        return UtilCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_util_UtilCompatibilityAspect$com_xpn_xwiki_util_Util$getFileContentAsBytes(file);
    }

    @Deprecated
    public static byte[] getFileContentAsBytes(InputStream inputStream) throws IOException {
        return UtilCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_util_UtilCompatibilityAspect$com_xpn_xwiki_util_Util$getFileContentAsBytes(inputStream);
    }

    @Deprecated
    public List<String> getMatches(String string, String string2, int n) throws MalformedPatternException {
        return UtilCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_util_UtilCompatibilityAspect$com_xpn_xwiki_util_Util$getMatches(this, string, string2, n);
    }
}

