/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.util;

import com.xpn.xwiki.XWikiContext;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xwiki.rendering.util.IdGenerator;

public class TOCGenerator {
    public static final String TOC_DATA_NUMBERING = "numbering";
    public static final String TOC_DATA_LEVEL = "level";
    public static final String TOC_DATA_TEXT = "text";

    public static Map<String, Map<String, Object>> generateTOC(String content, int init, int max, boolean numbered, XWikiContext context) {
        IdGenerator idGenerator = new IdGenerator();
        LinkedHashMap<String, Map<String, Object>> tocData = new LinkedHashMap<String, Map<String, Object>>();
        int[] previousNumbers = new int[]{0, 0, 0, 0, 0, 0, 0};
        Pattern pattern = Pattern.compile("(?-s)^[ \\t]*+(1(\\.1){0,5}+)[ \\t]++(.++)$", 8);
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            int level = (matcher.group(1).lastIndexOf("1") + 2) / 2;
            String text = matcher.group(3);
            text = context.getWiki().parseContent(text, context);
            String id = idGenerator.generateUniqueId("H", text);
            HashMap<String, Object> tocEntry = new HashMap<String, Object>();
            tocEntry.put(TOC_DATA_LEVEL, level);
            tocEntry.put(TOC_DATA_TEXT, text);
            if (level < init || level > max) continue;
            if (numbered) {
                Object number = "";
                int currentNumber = 0;
                for (int i = previousNumbers.length - 1; i >= init; --i) {
                    int num = 0;
                    int previousNumber = previousNumbers[i];
                    if (previousNumber > 0) {
                        num = previousNumber;
                        if (i == level) {
                            num = previousNumber + 1;
                        } else if (i > level) {
                            previousNumbers[i] = 0;
                        }
                    } else {
                        num = 1;
                        if (i < level) {
                            previousNumbers[i] = previousNumbers[i] + 1;
                        }
                    }
                    if (i > level) continue;
                    if (((String)number).length() == 0) {
                        number = num + (String)number;
                        currentNumber = num;
                        continue;
                    }
                    number = num + "." + (String)number;
                }
                previousNumbers[level] = currentNumber;
                tocEntry.put(TOC_DATA_NUMBERING, number);
            }
            tocData.put(id, tocEntry);
        }
        return tocData;
    }

    @Deprecated
    public static String makeHeadingID(String text, int occurence, XWikiContext context) {
        text = "H" + (String)text;
        text = ((String)text).replaceAll("[^a-zA-Z0-9]", "");
        if (occurence > 0) {
            return (String)text + "-" + occurence;
        }
        return text;
    }
}

