/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.user.impl.xwiki;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.classes.GroupsClass;
import com.xpn.xwiki.user.api.XWikiGroupService;
import com.xpn.xwiki.user.api.XWikiRightNotFoundException;
import com.xpn.xwiki.user.api.XWikiRightService;
import com.xpn.xwiki.user.api.XWikiUser;
import com.xpn.xwiki.util.Util;
import com.xpn.xwiki.web.Utils;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;

@Deprecated
public class XWikiRightServiceImpl
implements XWikiRightService {
    public static final EntityReference RIGHTCLASS_REFERENCE = new EntityReference("XWikiRights", EntityType.DOCUMENT, new EntityReference("XWiki", EntityType.SPACE));
    public static final EntityReference GLOBALRIGHTCLASS_REFERENCE = new EntityReference("XWikiGlobalRights", EntityType.DOCUMENT, new EntityReference("XWiki", EntityType.SPACE));
    private static final Logger LOGGER = LoggerFactory.getLogger(XWikiRightServiceImpl.class);
    private static final EntityReference XWIKIPREFERENCES_REFERENCE = new EntityReference("XWikiPreferences", EntityType.DOCUMENT, new EntityReference("XWiki", EntityType.SPACE));
    private static final List<String> ALLLEVELS = Arrays.asList("admin", "view", "edit", "comment", "delete", "undelete", "register", "programming");
    private static final EntityReference DEFAULTUSERSPACE = new EntityReference("XWiki", EntityType.SPACE);
    private static Map<String, String> actionMap;
    private DocumentReferenceResolver<String> currentMixedDocumentReferenceResolver = (DocumentReferenceResolver)Utils.getComponent(DocumentReferenceResolver.TYPE_STRING, "currentmixed");
    private EntityReferenceSerializer<String> entityReferenceSerializer = (EntityReferenceSerializer)Utils.getComponent(EntityReferenceSerializer.TYPE_STRING);

    protected void logAllow(String username, String page, String action, String info) {
        LOGGER.debug("Access has been granted for ([{}], [{}], [{}]): [{}]", new Object[]{username, page, action, info});
    }

    protected void logDeny(String username, String page, String action, String info) {
        LOGGER.info("Access has been denied for ([{}], [{}], [{}]): [{}]", new Object[]{username, page, action, info});
    }

    protected void logDeny(String name, String resourceKey, String accessLevel, String info, Exception e) {
        LOGGER.debug("Access has been denied for ([{}], [{}], [{}]) at [{}]", new Object[]{name, resourceKey, accessLevel, info, e});
    }

    @Override
    public List<String> listAllLevels(XWikiContext context) throws XWikiException {
        return new ArrayList<String>(ALLLEVELS);
    }

    public String getRight(String action) {
        String right;
        if (actionMap == null) {
            actionMap = new HashMap<String, String>();
            actionMap.put("login", "login");
            actionMap.put("logout", "login");
            actionMap.put("loginerror", "login");
            actionMap.put("loginsubmit", "login");
            actionMap.put("view", "view");
            actionMap.put("viewrev", "view");
            actionMap.put("get", "view");
            actionMap.put("downloadrev", "view");
            actionMap.put("plain", "view");
            actionMap.put("raw", "view");
            actionMap.put("attach", "view");
            actionMap.put("skin", "view");
            actionMap.put("download", "view");
            actionMap.put("pdf", "view");
            actionMap.put("delete", "delete");
            actionMap.put("deletespace", "admin");
            actionMap.put("deleteversions", "admin");
            actionMap.put("undelete", "undelete");
            actionMap.put("reset", "delete");
            actionMap.put("commentadd", "comment");
            actionMap.put("commentsave", "comment");
            actionMap.put("register", "register");
            actionMap.put("redirect", "view");
            actionMap.put("admin", "admin");
            actionMap.put("export", "view");
            actionMap.put("import", "admin");
            actionMap.put("jsx", "view");
            actionMap.put("ssx", "view");
            actionMap.put("tex", "view");
            actionMap.put("create", "edit");
            actionMap.put("temp", "view");
            actionMap.put("unknown", "view");
        }
        if ((right = actionMap.get(action)) == null) {
            return "edit";
        }
        return right;
    }

    @Override
    public boolean checkAccess(String action, XWikiDocument doc, XWikiContext context) throws XWikiException {
        LOGGER.debug("checkAccess for [{}], [{}]", (Object)action, (Object)doc);
        Object username = null;
        XWikiUser user = null;
        boolean needsAuth = false;
        String right = this.getRight(action);
        if (right.equals("login")) {
            user = context.getWiki().checkAuth(context);
            username = user == null ? "XWiki.XWikiGuest" : user.getUser();
            context.setUser((String)username);
            this.logAllow((String)username, doc.getFullName(), action, "login/logout pages");
            return true;
        }
        if (right.equals("delete")) {
            user = context.getWiki().checkAuth(context);
            String creator = doc.getCreator();
            if (user != null && user.getUser() != null && creator != null && user.getUser().equals(creator)) {
                context.setUser(user.getUser());
                return true;
            }
        }
        if ((user = context.getXWikiUser()) == null) {
            block17: {
                needsAuth = this.needsAuth(right, context);
                try {
                    user = context.getMode() != 2 ? context.getWiki().checkAuth(context) : new XWikiUser(context.getUser());
                    if (user == null && needsAuth) {
                        this.logDeny("unauthentified", doc.getFullName(), action, "Authentication needed");
                        if (context.getRequest() != null && !context.getWiki().Param("xwiki.hidelogin", "false").equalsIgnoreCase("true")) {
                            context.getWiki().getAuthService().showLogin(context);
                        }
                        return false;
                    }
                }
                catch (XWikiException e) {
                    if (!needsAuth) break block17;
                    throw e;
                }
            }
            username = user == null ? "XWiki.XWikiGuest" : user.getUser();
            context.setUser((String)username);
        } else {
            username = user.getUser();
        }
        try {
            Object docname;
            if (context.getWikiId() != null) {
                docname = context.getWikiId() + ":" + doc.getFullName();
                if (((String)username).indexOf(":") == -1) {
                    username = context.getWikiId() + ":" + (String)username;
                }
            } else {
                docname = doc.getFullName();
            }
            if (context.getWiki().getRightService().hasAccessLevel(right, (String)username, (String)docname, context)) {
                this.logAllow((String)username, (String)docname, action, "access manager granted right");
                return true;
            }
        }
        catch (Exception e) {
            this.logDeny((String)username, doc.getFullName(), action, "access manager exception " + e.getMessage());
            e.printStackTrace();
            return false;
        }
        if (user == null) {
            this.logDeny("unauthentified", doc.getFullName(), action, "Guest has been denied");
            if (context.getRequest() != null && !context.getWiki().Param("xwiki.hidelogin", "false").equalsIgnoreCase("true")) {
                context.getWiki().getAuthService().showLogin(context);
            }
            return false;
        }
        this.logDeny((String)username, doc.getFullName(), action, "access manager denied right");
        return false;
    }

    private boolean needsAuth(String right, XWikiContext context) {
        boolean needsAuth = false;
        try {
            needsAuth = "yes".equalsIgnoreCase(context.getWiki().getXWikiPreference("authenticate_" + right, "", context));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            needsAuth |= context.getWiki().getXWikiPreferenceAsInt("authenticate_" + right, 0, context) == 1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            needsAuth |= "yes".equalsIgnoreCase(context.getWiki().getSpacePreference("authenticate_" + right, "", context));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            needsAuth |= context.getWiki().getSpacePreferenceAsInt("authenticate_" + right, 0, context) == 1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return needsAuth;
    }

    @Override
    public boolean hasAccessLevel(String right, String username, String docname, XWikiContext context) throws XWikiException {
        try {
            return this.hasAccessLevel(right, username, docname, true, context);
        }
        catch (XWikiException e) {
            return false;
        }
    }

    public boolean checkRight(String userOrGroupName, XWikiDocument doc, String accessLevel, boolean user, boolean allow, boolean global, XWikiContext context) throws XWikiRightNotFoundException, XWikiException {
        List<BaseObject> rightObjects;
        if (!global && "admin".equals(accessLevel)) {
            throw new XWikiRightNotFoundException();
        }
        EntityReference rightClassReference = global ? GLOBALRIGHTCLASS_REFERENCE : RIGHTCLASS_REFERENCE;
        String fieldName = user ? "users" : "groups";
        boolean found = false;
        DocumentReference userOrGroupDocumentReference = this.currentMixedDocumentReferenceResolver.resolve((Object)userOrGroupName, new Object[0]);
        String prefixedFullName = (String)this.entityReferenceSerializer.serialize((EntityReference)userOrGroupDocumentReference, new Object[0]);
        String shortname = userOrGroupName;
        int i0 = userOrGroupName.indexOf(":");
        if (i0 != -1) {
            shortname = userOrGroupName.substring(i0 + 1);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Checking right: [{}], [{}], [{}], [{}], [{}], [{}]", new Object[]{userOrGroupName, doc.getFullName(), accessLevel, user, allow, global});
        }
        if ((rightObjects = doc.getXObjects(rightClassReference)) != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Checking objects [{}]", (Object)rightObjects.size());
            }
            for (int i = 0; i < rightObjects.size(); ++i) {
                boolean allowdeny;
                LOGGER.debug("Checking object [{}]", (Object)i);
                BaseObject bobj = rightObjects.get(i);
                if (bobj == null) {
                    LOGGER.debug("Bypass object [{}]", (Object)i);
                    continue;
                }
                String users = bobj.getStringValue(fieldName);
                String levels = bobj.getStringValue("levels");
                boolean bl = allowdeny = bobj.getIntValue("allow") == 1;
                if (allowdeny == allow) {
                    LOGGER.debug("Checking match: [{}] in [{}]", (Object)accessLevel, (Object)levels);
                    Object[] levelsarray = StringUtils.split((String)levels, (String)" ,|");
                    if (!ArrayUtils.contains((Object[])levelsarray, (Object)accessLevel)) continue;
                    LOGGER.debug("Found a right for [{}]", (Object)allow);
                    found = true;
                    LOGGER.debug("Checking match: [{}] in [{}]", (Object)userOrGroupName, (Object)users);
                    Object[] userarray = GroupsClass.getListFromString(users).toArray(new String[0]);
                    for (int ii = 0; ii < userarray.length; ++ii) {
                        String value = userarray[ii];
                        if (value.indexOf(".") != -1) continue;
                        userarray[ii] = "XWiki." + value;
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Checking match: [{}] in [{}]", (Object)userOrGroupName, (Object)StringUtils.join((Object[])userarray, (String)","));
                    }
                    if (doc.getWikiName().equals(userOrGroupDocumentReference.getWikiReference().getName())) {
                        if (ArrayUtils.contains((Object[])userarray, (Object)shortname)) {
                            LOGGER.debug("Found matching right in [{}] for [{}]", (Object)users, (Object)shortname);
                            return true;
                        }
                        String veryshortname = shortname.substring(shortname.indexOf(".") + 1);
                        if (ArrayUtils.contains((Object[])userarray, (Object)veryshortname)) {
                            LOGGER.debug("Found matching right in [{}] for [{}]", (Object)users, (Object)shortname);
                            return true;
                        }
                    }
                    if (context.getWikiId() != null && ArrayUtils.contains((Object[])userarray, (Object)userOrGroupName)) {
                        LOGGER.debug("Found matching right in [{}] for [{}]", (Object)users, (Object)userOrGroupName);
                        return true;
                    }
                    LOGGER.debug("Failed match: [{}] in [{}]", (Object)userOrGroupName, (Object)users);
                    continue;
                }
                LOGGER.debug("Bypass object [{}] because wrong allow/deny", (Object)i);
            }
        }
        LOGGER.debug("Searching for matching rights at group level");
        HashMap grouplistcache = (HashMap)context.get("grouplist");
        if (grouplistcache == null) {
            grouplistcache = new HashMap();
            context.put("grouplist", grouplistcache);
        }
        HashSet<String> grouplist = new HashSet<String>();
        this.addMemberGroups(doc.getWikiName(), prefixedFullName, userOrGroupDocumentReference, grouplist, context);
        if (!context.getWikiId().equalsIgnoreCase(userOrGroupDocumentReference.getWikiReference().getName())) {
            this.addMemberGroups(userOrGroupDocumentReference.getWikiReference().getName(), prefixedFullName, userOrGroupDocumentReference, grouplist, context);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Searching for matching rights for [{}] groups: [{}]", (Object)grouplist.size(), grouplist);
        }
        for (String group : grouplist) {
            try {
                boolean result = this.checkRight(group, doc, accessLevel, false, allow, global, context);
                if (!result) continue;
                return true;
            }
            catch (XWikiRightNotFoundException result) {
            }
            catch (Exception e) {
                LOGGER.error("Failed to check right [{}] for group [{}] on document [\u00b6}]", new Object[]{accessLevel, group, doc.getPrefixedFullName(), e});
            }
        }
        LOGGER.debug("Finished searching for rights for [{}]: [{}]", (Object)userOrGroupName, (Object)found);
        if (found) {
            return false;
        }
        throw new XWikiRightNotFoundException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMemberGroups(String wiki, String prefixedFullName, DocumentReference userOrGroupDocumentReference, Collection<String> grouplist, XWikiContext context) throws XWikiException {
        String key;
        List<Object> tmpGroupList;
        XWikiGroupService groupService = context.getWiki().getGroupService(context);
        HashMap<CallSite, List<Object>> grouplistcache = (HashMap<CallSite, List<Object>>)context.get("grouplist");
        if (grouplistcache == null) {
            grouplistcache = new HashMap<CallSite, List<Object>>();
            context.put("grouplist", grouplistcache);
        }
        if ((tmpGroupList = (ArrayList)grouplistcache.get(key = wiki + ":" + prefixedFullName)) == null) {
            String currentWiki = context.getWikiId();
            try {
                context.setWikiId(wiki);
                Collection<DocumentReference> groupReferences = groupService.getAllGroupsReferencesForMember(userOrGroupDocumentReference, 0, 0, context);
                tmpGroupList = new ArrayList(groupReferences.size());
                for (DocumentReference groupReference : groupReferences) {
                    tmpGroupList.add((String)this.entityReferenceSerializer.serialize((EntityReference)groupReference, new Object[0]));
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to get groups for user or group [{}] in wiki [{}]", new Object[]{prefixedFullName, wiki, e});
                tmpGroupList = Collections.emptyList();
            }
            finally {
                context.setWikiId(currentWiki);
            }
            grouplistcache.put((CallSite)((Object)key), tmpGroupList);
        }
        grouplist.addAll((Collection<String>)tmpGroupList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAccessLevel(String accessLevel, String userOrGroupName, String entityReference, boolean user, XWikiContext context) throws XWikiException {
        DocumentReference creator;
        LOGGER.debug("hasAccessLevel for [{}], [{}], [{}]", new Object[]{accessLevel, userOrGroupName, entityReference});
        DocumentReference userOrGroupNameReference = this.currentMixedDocumentReferenceResolver.resolve((Object)userOrGroupName, new Object[0]);
        if (!userOrGroupNameReference.getName().equals("XWikiGuest") && context.getWikiId() != null) {
            userOrGroupName = (String)this.entityReferenceSerializer.serialize((EntityReference)this.currentMixedDocumentReferenceResolver.resolve((Object)userOrGroupName, new Object[]{DEFAULTUSERSPACE}), new Object[0]);
            entityReference = (String)this.entityReferenceSerializer.serialize((EntityReference)this.currentMixedDocumentReferenceResolver.resolve((Object)entityReference, new Object[0]), new Object[0]);
        }
        boolean deny = false;
        boolean allow = false;
        boolean allow_found = false;
        boolean deny_found = false;
        boolean isReadOnly = context.getWiki().isReadOnly();
        String database = context.getWikiId();
        XWikiDocument currentdoc = null;
        if (isReadOnly && ("edit".equals(accessLevel) || "delete".equals(accessLevel) || "undelete".equals(accessLevel) || "comment".equals(accessLevel) || "register".equals(accessLevel))) {
            this.logDeny(userOrGroupName, entityReference, accessLevel, "server in read-only mode");
            return false;
        }
        if (userOrGroupNameReference.getName().equals("XWikiGuest") && this.needsAuth(accessLevel, context)) {
            return false;
        }
        if (accessLevel.equals("delete") && user && ObjectUtils.equals((Object)userOrGroupNameReference, (Object)(creator = (currentdoc = context.getWiki().getDocument(entityReference, context)).getCreatorReference()))) {
            this.logAllow(userOrGroupName, entityReference, accessLevel, "delete right from document ownership");
            return true;
        }
        allow = this.isSuperAdminOrProgramming(userOrGroupName, entityReference, accessLevel, user, context);
        if (allow || accessLevel.equals("programming")) {
            return allow;
        }
        try {
            currentdoc = currentdoc == null ? context.getWiki().getDocument(entityReference, context) : currentdoc;
            DocumentReference docReference = currentdoc.getDocumentReference();
            if (accessLevel.equals("edit") && (docReference.getName().equals("WebPreferences") || docReference.getLastSpaceReference().getName().equals("XWiki") && docReference.getName().equals("XWikiPreferences"))) {
                accessLevel = "admin";
            }
            context.setWikiId(currentdoc.getDatabase());
            String wikiOwner = context.getWiki().getWikiOwner(currentdoc.getDatabase(), context);
            if (wikiOwner != null && wikiOwner.equals(userOrGroupName)) {
                this.logAllow(userOrGroupName, entityReference, accessLevel, "admin level from wiki ownership");
                boolean bl = true;
                return bl;
            }
            XWikiDocument entityWikiPreferences = context.getWiki().getDocument(XWIKIPREFERENCES_REFERENCE, context);
            if (accessLevel.equals("register")) {
                try {
                    allow = this.checkRight(userOrGroupName, entityWikiPreferences, "register", user, true, true, context);
                    if (allow) {
                        this.logAllow(userOrGroupName, entityReference, accessLevel, "register level");
                        boolean bl = true;
                        return bl;
                    }
                    this.logDeny(userOrGroupName, entityReference, accessLevel, "register level");
                    boolean bl = false;
                    return bl;
                }
                catch (XWikiRightNotFoundException e2) {
                    try {
                        deny = this.checkRight(userOrGroupName, entityWikiPreferences, "register", user, false, true, context);
                        if (deny) {
                            boolean bl = false;
                            return bl;
                        }
                    }
                    catch (XWikiRightNotFoundException xWikiRightNotFoundException) {
                        // empty catch block
                    }
                    this.logAllow(userOrGroupName, entityReference, accessLevel, "register level (no right found)");
                    boolean e2 = true;
                    return e2;
                }
            }
            int maxRecursiveSpaceChecks = context.getWiki().getMaxRecursiveSpaceChecks(context);
            boolean isSuperUser = this.isSuperUser(accessLevel, userOrGroupName, entityReference, user, entityWikiPreferences, maxRecursiveSpaceChecks, context);
            if (isSuperUser) {
                this.logAllow(userOrGroupName, entityReference, accessLevel, "admin level");
                boolean bl = true;
                return bl;
            }
            if (this.hasDenyRights()) {
                entityReference = Util.getName(entityReference, context);
                try {
                    currentdoc = currentdoc == null ? context.getWiki().getDocument(entityReference, context) : currentdoc;
                    deny = this.checkRight(userOrGroupName, currentdoc, accessLevel, user, false, false, context);
                    deny_found = true;
                    if (deny) {
                        this.logDeny(userOrGroupName, entityReference, accessLevel, "document level");
                        boolean bl = false;
                        return bl;
                    }
                }
                catch (XWikiRightNotFoundException xWikiRightNotFoundException) {
                    // empty catch block
                }
            }
            try {
                currentdoc = currentdoc == null ? context.getWiki().getDocument(entityReference, context) : currentdoc;
                allow = this.checkRight(userOrGroupName, currentdoc, accessLevel, user, true, false, context);
                allow_found = true;
                if (allow) {
                    this.logAllow(userOrGroupName, entityReference, accessLevel, "document level");
                    boolean bl = true;
                    return bl;
                }
            }
            catch (XWikiRightNotFoundException xWikiRightNotFoundException) {
                // empty catch block
            }
            String space = currentdoc.getSpace();
            ArrayList<String> spacesChecked = new ArrayList<String>();
            int recursiveSpaceChecks = 0;
            while (space != null && recursiveSpaceChecks <= maxRecursiveSpaceChecks) {
                ++recursiveSpaceChecks;
                spacesChecked.add(space);
                XWikiDocument webdoc = context.getWiki().getDocument(space, "WebPreferences", context);
                if (!webdoc.isNew()) {
                    if (this.hasDenyRights()) {
                        try {
                            deny = this.checkRight(userOrGroupName, webdoc, accessLevel, user, false, true, context);
                            deny_found = true;
                            if (deny) {
                                this.logDeny(userOrGroupName, entityReference, accessLevel, "web level");
                                boolean bl = false;
                                return bl;
                            }
                        }
                        catch (XWikiRightNotFoundException xWikiRightNotFoundException) {
                            // empty catch block
                        }
                    }
                    if (!allow_found) {
                        try {
                            allow = this.checkRight(userOrGroupName, webdoc, accessLevel, user, true, true, context);
                            allow_found = true;
                            if (allow) {
                                this.logAllow(userOrGroupName, entityReference, accessLevel, "web level");
                                boolean bl = true;
                                return bl;
                            }
                        }
                        catch (XWikiRightNotFoundException xWikiRightNotFoundException) {
                            // empty catch block
                        }
                    }
                    if ((space = webdoc.getStringValue("XWiki.XWikiPreferences", "parent")) != null && !space.trim().equals("") && !spacesChecked.contains(space)) continue;
                    space = null;
                    continue;
                }
                space = null;
            }
            if (this.hasDenyRights()) {
                try {
                    deny = this.checkRight(userOrGroupName, entityWikiPreferences, accessLevel, user, false, true, context);
                    deny_found = true;
                    if (deny) {
                        this.logDeny(userOrGroupName, entityReference, accessLevel, "xwiki level");
                        boolean bl = false;
                        return bl;
                    }
                }
                catch (XWikiRightNotFoundException xWikiRightNotFoundException) {
                    // empty catch block
                }
            }
            if (!allow_found) {
                try {
                    allow = this.checkRight(userOrGroupName, entityWikiPreferences, accessLevel, user, true, true, context);
                    allow_found = true;
                    if (allow) {
                        this.logAllow(userOrGroupName, entityReference, accessLevel, "xwiki level");
                        boolean bl = true;
                        return bl;
                    }
                }
                catch (XWikiRightNotFoundException xWikiRightNotFoundException) {
                    // empty catch block
                }
            }
            if (!allow_found) {
                if ("delete".equals(accessLevel)) {
                    if (this.hasAccessLevel("admin", userOrGroupName, entityReference, user, context)) {
                        this.logAllow(userOrGroupName, entityReference, accessLevel, "admin rights imply delete on empty wiki");
                        boolean bl = true;
                        return bl;
                    }
                    this.logDeny(userOrGroupName, entityReference, accessLevel, "global level (delete right must be explicit)");
                    boolean bl = false;
                    return bl;
                }
                this.logAllow(userOrGroupName, entityReference, accessLevel, "global level (no restricting right)");
                boolean bl = true;
                return bl;
            }
            this.logDeny(userOrGroupName, entityReference, accessLevel, "global level (restricting right was found)");
            boolean bl = false;
            return bl;
        }
        catch (XWikiException e) {
            this.logDeny(userOrGroupName, entityReference, accessLevel, "global level (exception)", e);
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            context.setWikiId(database);
        }
    }

    private boolean hasDenyRights() {
        return true;
    }

    private boolean isSuperAdmin(String username) {
        DocumentReference userReference = ((DocumentReferenceResolver)Utils.getComponent(DocumentReferenceResolver.TYPE_STRING)).resolve((Object)username, new Object[0]);
        return StringUtils.equalsIgnoreCase((CharSequence)userReference.getName(), (CharSequence)"superadmin");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSuperAdminOrProgramming(String name, String resourceKey, String accessLevel, boolean user, XWikiContext context) throws XWikiException {
        if (name == null) {
            return false;
        }
        String database = context.getWikiId();
        if (this.isSuperAdmin(name)) {
            this.logAllow(name, resourceKey, accessLevel, "super admin level");
            return true;
        }
        try {
            boolean allow;
            context.setWikiId(context.getMainXWiki());
            XWikiDocument xwikimasterdoc = context.getWiki().getDocument(XWIKIPREFERENCES_REFERENCE, context);
            try {
                allow = this.checkRight(name, xwikimasterdoc, "admin", true, true, true, context);
                if (allow) {
                    this.logAllow(name, resourceKey, accessLevel, "master admin level");
                    boolean bl = true;
                    return bl;
                }
            }
            catch (XWikiRightNotFoundException xWikiRightNotFoundException) {
                // empty catch block
            }
            if (accessLevel.equals("programming")) {
                if (!name.startsWith(context.getMainXWiki() + ":")) {
                    boolean bl = false;
                    return bl;
                }
                allow = this.checkRight(name, xwikimasterdoc, "programming", user, true, true, context);
                if (allow) {
                    this.logAllow(name, resourceKey, accessLevel, "programming level");
                    boolean bl = true;
                    return bl;
                }
                this.logDeny(name, resourceKey, accessLevel, "programming level");
                boolean bl = false;
                return bl;
            }
        }
        finally {
            context.setWikiId(database);
        }
        return false;
    }

    private boolean isSuperUser(String accessLevel, String name, String resourceKey, boolean user, XWikiDocument xwikidoc, int maxRecursiveSpaceChecks, XWikiContext context) throws XWikiException {
        boolean allow;
        try {
            allow = this.checkRight(name, xwikidoc, "admin", user, true, true, context);
            if (allow) {
                this.logAllow(name, resourceKey, accessLevel, "admin level");
                return true;
            }
        }
        catch (XWikiRightNotFoundException xWikiRightNotFoundException) {
            // empty catch block
        }
        XWikiDocument documentName = new XWikiDocument();
        documentName.setFullName(resourceKey);
        String space = documentName.getSpace();
        ArrayList<String> spacesChecked = new ArrayList<String>();
        int recursiveSpaceChecks = 0;
        while (space != null && recursiveSpaceChecks <= maxRecursiveSpaceChecks) {
            ++recursiveSpaceChecks;
            spacesChecked.add(space);
            XWikiDocument webdoc = context.getWiki().getDocument(space, "WebPreferences", context);
            if (!webdoc.isNew()) {
                try {
                    allow = this.checkRight(name, webdoc, "admin", user, true, true, context);
                    if (allow) {
                        this.logAllow(name, resourceKey, accessLevel, "web admin level");
                        return true;
                    }
                }
                catch (XWikiRightNotFoundException xWikiRightNotFoundException) {
                    // empty catch block
                }
                if ((space = webdoc.getStringValue("XWiki.XWikiPreferences", "parent")) != null && !space.trim().equals("") && !spacesChecked.contains(space)) continue;
                space = null;
                continue;
            }
            space = null;
        }
        return false;
    }

    @Override
    public boolean hasProgrammingRights(XWikiContext context) {
        if (context.hasDroppedPermissions()) {
            return false;
        }
        XWikiDocument sdoc = (XWikiDocument)context.get("sdoc");
        if (sdoc == null) {
            sdoc = context.getDoc();
        }
        return this.hasProgrammingRights(sdoc, context);
    }

    @Override
    public boolean hasProgrammingRights(XWikiDocument doc, XWikiContext context) {
        try {
            Object docname;
            if (doc == null) {
                return this.isSuperAdminOrProgramming((String)this.entityReferenceSerializer.serialize((EntityReference)context.getUserReference(), new Object[0]), null, "programming", true, context);
            }
            Object username = doc.getContentAuthor();
            if (username == null) {
                return false;
            }
            if (doc.getDatabase() != null) {
                docname = doc.getDatabase() + ":" + doc.getFullName();
                if (((String)username).indexOf(":") == -1) {
                    username = doc.getDatabase() + ":" + (String)username;
                }
            } else {
                docname = doc.getFullName();
            }
            return this.hasAccessLevel("programming", (String)username, (String)docname, context);
        }
        catch (Exception e) {
            LOGGER.error("Failed to check programming right for document [{}]", (Object)doc.getPrefixedFullName(), (Object)e);
            return false;
        }
    }

    @Override
    public boolean hasAdminRights(XWikiContext context) {
        boolean hasAdmin = this.hasWikiAdminRights(context);
        if (!hasAdmin) {
            try {
                hasAdmin = this.hasAccessLevel("admin", context.getUser(), context.getDoc().getSpace() + ".WebPreferences", context);
            }
            catch (Exception e) {
                LOGGER.error("Failed to check space admin right for user [{}]", (Object)context.getUser(), (Object)e);
            }
        }
        return hasAdmin;
    }

    @Override
    public boolean hasWikiAdminRights(XWikiContext context) {
        try {
            return this.hasAccessLevel("admin", context.getUser(), "XWiki.XWikiPreferences", context);
        }
        catch (Exception e) {
            LOGGER.error("Failed to check wiki admin right for user [{}]", (Object)context.getUser(), (Object)e);
            return false;
        }
    }
}

