/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.user.impl.xwiki;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.classes.PasswordClass;
import com.xpn.xwiki.user.api.XWikiUser;
import com.xpn.xwiki.user.impl.xwiki.AbstractXWikiAuthService;
import com.xpn.xwiki.user.impl.xwiki.MyBasicAuthenticator;
import com.xpn.xwiki.user.impl.xwiki.MyFilterConfig;
import com.xpn.xwiki.user.impl.xwiki.MyFormAuthenticator;
import com.xpn.xwiki.user.impl.xwiki.XWikiAuthenticator;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Provider;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.securityfilter.authenticator.persistent.PersistentLoginManagerInterface;
import org.securityfilter.config.SecurityConfig;
import org.securityfilter.filter.SecurityRequestWrapper;
import org.securityfilter.filter.URLPatternMatcher;
import org.securityfilter.realm.SimplePrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;

public class XWikiAuthServiceImpl
extends AbstractXWikiAuthService {
    private static final Logger LOGGER = LoggerFactory.getLogger(XWikiAuthServiceImpl.class);
    private static final EntityReference USERCLASS_REFERENCE = new EntityReference("XWikiUsers", EntityType.DOCUMENT, new EntityReference("XWiki", EntityType.SPACE));
    private DocumentReferenceResolver<String> currentDocumentReferenceResolver = (DocumentReferenceResolver)Utils.getComponent(DocumentReferenceResolver.TYPE_STRING, "current");
    private EntityReferenceSerializer<String> compactWikiEntityReferenceSerializer = (EntityReferenceSerializer)Utils.getComponent(EntityReferenceSerializer.TYPE_STRING, "compactwiki");
    private Provider<PersistentLoginManagerInterface> persistentLoginManagerProvider = (Provider)Utils.getComponent((Type)new DefaultParameterizedType(null, Provider.class, new Type[]{PersistentLoginManagerInterface.class}));
    protected Map<String, XWikiAuthenticator> authenticators = new ConcurrentHashMap<String, XWikiAuthenticator>();

    protected XWikiAuthenticator getAuthenticator(XWikiContext context) throws XWikiException {
        XWikiAuthenticator authenticator;
        String wikiName = context.getWikiId();
        if (wikiName != null) {
            wikiName = wikiName.toLowerCase();
        }
        if ((authenticator = this.authenticators.get(wikiName)) != null) {
            return authenticator;
        }
        try {
            XWiki xwiki = context.getWiki();
            if ("basic".equals(xwiki.Param("xwiki.authentication"))) {
                authenticator = new MyBasicAuthenticator();
                SecurityConfig sconfig = new SecurityConfig(false);
                sconfig.setAuthMethod("BASIC");
                if (xwiki.Param("xwiki.authentication.realmname") != null) {
                    sconfig.setRealmName(xwiki.Param("xwiki.authentication.realmname"));
                } else {
                    sconfig.setRealmName("XWiki");
                }
                authenticator.init(null, sconfig);
            } else {
                authenticator = new MyFormAuthenticator();
                SecurityConfig sconfig = new SecurityConfig(false);
                sconfig.setAuthMethod("FORM");
                if (xwiki.Param("xwiki.authentication.realmname") != null) {
                    sconfig.setRealmName(xwiki.Param("xwiki.authentication.realmname"));
                } else {
                    sconfig.setRealmName("XWiki");
                }
                if (xwiki.Param("xwiki.authentication.defaultpage") != null) {
                    sconfig.setDefaultPage(xwiki.Param("xwiki.authentication.defaultpage"));
                } else {
                    sconfig.setDefaultPage(this.stripContextPathFromURL(context.getURLFactory().createURL(context.getWiki().getDefaultSpace(context), context.getWiki().getDefaultPage(context), "view", context), context));
                }
                if (xwiki.Param("xwiki.authentication.loginpage") != null) {
                    sconfig.setLoginPage(xwiki.Param("xwiki.authentication.loginpage"));
                } else {
                    sconfig.setLoginPage(this.stripContextPathFromURL(context.getURLFactory().createURL("XWiki", "XWikiLogin", "login", context), context));
                }
                if (xwiki.Param("xwiki.authentication.logoutpage") != null) {
                    sconfig.setLogoutPage(xwiki.Param("xwiki.authentication.logoutpage"));
                } else {
                    sconfig.setLogoutPage(this.stripContextPathFromURL(context.getURLFactory().createURL("XWiki", "XWikiLogout", "logout", context), context));
                }
                if (xwiki.Param("xwiki.authentication.errorpage") != null) {
                    sconfig.setErrorPage(xwiki.Param("xwiki.authentication.errorpage"));
                } else {
                    sconfig.setErrorPage(this.stripContextPathFromURL(context.getURLFactory().createURL("XWiki", "XWikiLogin", "loginerror", context), context));
                }
                sconfig.setPersistentLoginManager((PersistentLoginManagerInterface)this.persistentLoginManagerProvider.get());
                MyFilterConfig fconfig = new MyFilterConfig();
                fconfig.setInitParameter("loginSubmitPattern", xwiki.Param("xwiki.authentication.loginsubmitpage", "/loginsubmit/XWiki/XWikiLogin"));
                authenticator.init(fconfig, sconfig);
            }
            this.authenticators.put(wikiName, authenticator);
            return authenticator;
        }
        catch (Exception e) {
            throw new XWikiException(8, 8001, "Cannot initialize authentication system for wiki [" + wikiName + "]", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XWikiUser checkAuth(XWikiContext context) throws XWikiException {
        long time = System.currentTimeMillis();
        HttpServletRequest request = null;
        XWikiResponse response = context.getResponse();
        if (context.getRequest() != null) {
            request = context.getRequest().getHttpServletRequest();
        }
        if (request == null) {
            return null;
        }
        XWikiAuthenticator auth = this.getAuthenticator(context);
        SecurityRequestWrapper wrappedRequest = new SecurityRequestWrapper(request, null, null, auth.getAuthMethod());
        try {
            if (auth.processLogin(wrappedRequest, response, context)) {
                XWikiUser xWikiUser = null;
                return xWikiUser;
            }
            if (auth.processLogout(wrappedRequest, response, new URLPatternMatcher())) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("User " + context.getUser() + " has been logged-out");
                }
                wrappedRequest.setUserPrincipal(null);
                XWikiUser xWikiUser = null;
                return xWikiUser;
            }
            String userName = this.getContextUserName(wrappedRequest.getUserPrincipal(), context);
            if (LOGGER.isInfoEnabled() && userName != null) {
                LOGGER.info("User " + userName + " is authentified");
            }
            if (userName == null) {
                XWikiUser xWikiUser = null;
                return xWikiUser;
            }
            XWikiUser xWikiUser = new XWikiUser(userName);
            return xWikiUser;
        }
        catch (Exception e) {
            LOGGER.error("Failed to authenticate", (Throwable)e);
            XWikiUser xWikiUser = null;
            return xWikiUser;
        }
        finally {
            LOGGER.debug("XWikiAuthServiceImpl.checkAuth(XWikiContext) took " + (System.currentTimeMillis() - time) + " milliseconds to run.");
        }
    }

    @Override
    public XWikiUser checkAuth(String username, String password, String rememberme, XWikiContext context) throws XWikiException {
        HttpServletRequest request = null;
        XWikiResponse response = context.getResponse();
        if (context.getRequest() != null) {
            request = context.getRequest().getHttpServletRequest();
        }
        if (request == null) {
            return null;
        }
        XWikiAuthenticator auth = this.getAuthenticator(context);
        SecurityRequestWrapper wrappedRequest = new SecurityRequestWrapper(request, null, null, auth.getAuthMethod());
        try {
            if (!auth.processLogin(username, password, rememberme, wrappedRequest, response, context)) {
                return null;
            }
            Principal principal = wrappedRequest.getUserPrincipal();
            if (LOGGER.isInfoEnabled() && principal != null) {
                LOGGER.info("User " + principal.getName() + " is authentified");
            }
            if (principal == null) {
                return null;
            }
            return new XWikiUser(this.getContextUserName(principal, context));
        }
        catch (Exception e) {
            LOGGER.error("Failed to authenticate", (Throwable)e);
            return null;
        }
    }

    private String getContextUserName(Principal principal, XWikiContext context) {
        String contextUserName;
        if (principal != null) {
            DocumentReference userDocumentReference = this.currentDocumentReferenceResolver.resolve((Object)principal.getName(), new Object[0]);
            contextUserName = (String)this.compactWikiEntityReferenceSerializer.serialize((EntityReference)userDocumentReference, new Object[0]);
        } else {
            contextUserName = null;
        }
        return contextUserName;
    }

    @Override
    public void showLogin(XWikiContext context) throws XWikiException {
        try {
            if (context.getMode() == 0) {
                this.getAuthenticator(context).showLogin(context.getRequest().getHttpServletRequest(), context.getResponse(), context);
            }
        }
        catch (IOException e) {
            LOGGER.error("Unknown failure when calling showLogin", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Principal authenticate(String username, String password, XWikiContext context) throws XWikiException {
        if (username == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)username)) {
            context.put("message", "nousername");
            return null;
        }
        if (password == null || password.isEmpty()) {
            context.put("message", "nopassword");
            return null;
        }
        String cannonicalUsername = username.replaceAll(" ", "");
        if (this.isSuperAdmin(cannonicalUsername)) {
            return this.authenticateSuperAdmin(password, context);
        }
        if (context != null) {
            String susername = cannonicalUsername;
            String virtualXwikiName = null;
            int i = cannonicalUsername.indexOf(".");
            int j = cannonicalUsername.indexOf(":");
            if (j > 0) {
                virtualXwikiName = cannonicalUsername.substring(0, j);
            }
            if (i != -1) {
                susername = cannonicalUsername.substring(i + 1);
            } else if (j > 0) {
                susername = cannonicalUsername.substring(j + 1);
            }
            String db = context.getWikiId();
            try {
                String user2;
                if (virtualXwikiName != null) {
                    context.setWikiId(virtualXwikiName);
                }
                try {
                    user2 = this.findUser(susername, context);
                    if (user2 != null && this.checkPassword(user2, password, context)) {
                        SimplePrincipal simplePrincipal = new SimplePrincipal((String)(virtualXwikiName != null ? context.getWikiId() + ":" + user2 : user2));
                        return simplePrincipal;
                    }
                }
                catch (Exception user2) {
                    // empty catch block
                }
                if (!context.isMainWiki()) {
                    context.setWikiId(context.getMainXWiki());
                    try {
                        user2 = this.findUser(susername, context);
                        if (user2 != null && this.checkPassword(user2, password, context)) {
                            SimplePrincipal simplePrincipal = new SimplePrincipal(context.getWikiId() + ":" + user2);
                            return simplePrincipal;
                        }
                    }
                    catch (Exception e) {
                        context.put("message", "loginfailed");
                        Principal principal = null;
                        return principal;
                    }
                }
                context.put("message", "invalidcredentials");
                Principal principal = null;
                return principal;
            }
            finally {
                context.setWikiId(db);
            }
        }
        LOGGER.error("XWikiContext is null");
        return null;
    }

    protected String findUser(String username, XWikiContext context) throws XWikiException {
        Object user;
        if (context.getWiki().exists(new DocumentReference(context.getWikiId(), "XWiki", username), context)) {
            user = "XWiki." + username;
        } else {
            String sql = "select distinct doc.fullName from XWikiDocument as doc";
            Object[][] whereParameters = new Object[][]{{"doc.space", "XWiki"}, {"doc.name", username}};
            List list = context.getWiki().search(sql, whereParameters, context);
            user = list.size() == 0 ? null : (String)list.get(0);
        }
        return user;
    }

    protected boolean checkPassword(String username, String password, XWikiContext context) throws XWikiException {
        long time = System.currentTimeMillis();
        try {
            boolean result = false;
            XWikiDocument doc = context.getWiki().getDocument(username, context);
            BaseObject userObject = doc.getXObject(USERCLASS_REFERENCE);
            if (userObject != null) {
                String stored = userObject.getStringValue("password");
                result = new PasswordClass().getEquivalentPassword(stored, password).equals(stored);
            }
            if (LOGGER.isDebugEnabled()) {
                if (result) {
                    LOGGER.debug("Password check for user " + username + " successful");
                } else {
                    LOGGER.debug("Password check for user " + username + " failed");
                }
                LOGGER.debug(System.currentTimeMillis() - time + " milliseconds spent validating password.");
            }
            return result;
        }
        catch (Throwable e) {
            LOGGER.error("Failed to check password", e);
            return false;
        }
    }

    protected String getParam(String name, XWikiContext context) {
        String param = "";
        try {
            param = context.getWiki().getXWikiPreference(name, context);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (param == null || "".equals(param)) {
            try {
                param = context.getWiki().Param("xwiki.authentication." + StringUtils.replace((String)name, (String)"auth_", (String)""));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (param == null) {
            param = "";
        }
        return param;
    }

    protected String createUser(String user, XWikiContext context) throws XWikiException {
        String createuser = this.getParam("auth_createuser", context);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Create user param is " + createuser);
        }
        if (createuser != null) {
            String wikiname = context.getWiki().clearName(user, true, true, context);
            XWikiDocument userdoc = context.getWiki().getDocument(new DocumentReference(context.getWikiId(), "XWiki", wikiname), context);
            if (userdoc.isNew()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("User page does not exist for user " + user);
                }
                if ("empty".equals(createuser)) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Creating emptry user for user " + user);
                    }
                    context.getWiki().createEmptyUser(wikiname, "edit", context);
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("User page already exists for user " + user);
            }
            return wikiname;
        }
        return user;
    }

    protected String stripContextPathFromURL(URL url, XWikiContext context) {
        Object contextPath = context.getWiki().getWebAppPath(context);
        if (((String)contextPath).endsWith("/") && !((String)contextPath).startsWith("/")) {
            contextPath = "/" + StringUtils.chop((String)contextPath);
        } else if ("/".equals(contextPath)) {
            contextPath = "";
        }
        String urlPrefix = url.getProtocol() + "://" + url.getAuthority() + (String)contextPath;
        String encodedUrlPrefix = context.getResponse().encodeURL(urlPrefix);
        encodedUrlPrefix = encodedUrlPrefix.replaceAll(";jsessionid=.*?(?=\\?|$)", "");
        encodedUrlPrefix = StringUtils.substringBeforeLast((String)encodedUrlPrefix, (String)"?");
        Object strippedURL = Strings.CS.removeStart(url.toExternalForm(), (CharSequence)encodedUrlPrefix);
        if (!((String)strippedURL).startsWith("/")) {
            strippedURL = "/" + (String)strippedURL;
        }
        return strippedURL;
    }
}

