/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.user.impl.xwiki;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.internal.user.UserAuthenticatedEventNotifier;
import com.xpn.xwiki.user.impl.xwiki.MyBasicAuthenticator;
import com.xpn.xwiki.user.impl.xwiki.XWikiAuthenticator;
import com.xpn.xwiki.web.Utils;
import java.io.IOException;
import java.net.URLEncoder;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.securityfilter.authenticator.FormAuthenticator;
import org.securityfilter.filter.SecurityRequestWrapper;
import org.securityfilter.filter.URLPatternMatcher;
import org.securityfilter.realm.SimplePrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.container.servlet.filters.SavedRequestManager;
import org.xwiki.security.authentication.AuthenticationFailureManager;

public class MyFormAuthenticator
extends FormAuthenticator
implements XWikiAuthenticator {
    private static final Logger LOGGER = LoggerFactory.getLogger(MyFormAuthenticator.class);
    private UserAuthenticatedEventNotifier userAuthenticatedEventNotifier;

    private UserAuthenticatedEventNotifier getUserAuthenticatedEventNotifier() {
        if (this.userAuthenticatedEventNotifier == null) {
            this.userAuthenticatedEventNotifier = Utils.getComponent(UserAuthenticatedEventNotifier.class);
        }
        return this.userAuthenticatedEventNotifier;
    }

    @Override
    public void showLogin(HttpServletRequest request, HttpServletResponse response, XWikiContext context) throws IOException {
        if ("1".equals(request.getParameter("basicauth"))) {
            String realmName = context.getWiki().Param("xwiki.authentication.realmname");
            if (realmName == null) {
                realmName = "XWiki";
            }
            MyBasicAuthenticator.showLogin(request, response, realmName);
        } else {
            this.showLogin(request, response);
        }
    }

    public void showLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String savedRequestId = request.getParameter(SavedRequestManager.getSavedRequestIdentifier());
        if (StringUtils.isEmpty((CharSequence)savedRequestId)) {
            savedRequestId = SavedRequestManager.saveRequest((HttpServletRequest)request);
        }
        String sridParameter = SavedRequestManager.getSavedRequestIdentifier() + "=" + savedRequestId;
        StringBuilder redirectBack = new StringBuilder(request.getRequestURI());
        redirectBack.append('?');
        String delimiter = "";
        if (StringUtils.isNotEmpty((CharSequence)request.getQueryString())) {
            redirectBack.append(request.getQueryString());
            delimiter = "&";
        }
        if (!request.getParameterMap().containsKey(SavedRequestManager.getSavedRequestIdentifier())) {
            redirectBack.append(delimiter);
            redirectBack.append(sridParameter);
        }
        response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + this.loginPage + "?" + sridParameter + "&xredirect=" + URLEncoder.encode(redirectBack.toString(), "UTF-8")));
    }

    public boolean processLogin(SecurityRequestWrapper request, HttpServletResponse response) throws Exception {
        return this.processLogin(request, response, null);
    }

    private String convertUsername(String username, XWikiContext context) {
        return context.getWiki().convertUsername(username, context);
    }

    @Override
    public boolean processLogin(SecurityRequestWrapper request, HttpServletResponse response, XWikiContext context) throws Exception {
        Principal principal2;
        try {
            principal2 = MyBasicAuthenticator.checkLogin(request, response, context);
            if (principal2 != null) {
                return false;
            }
            if ("1".equals(request.getParameter("basicauth"))) {
                return true;
            }
        }
        catch (Exception principal2) {
            // empty catch block
        }
        if (this.persistentLoginManager != null && ((principal2 = request.getUserPrincipal()) == null || context.getWiki().ParamAsLong("xwiki.authentication.always", 0L) == 1L)) {
            String password;
            String username = this.convertUsername(this.persistentLoginManager.getRememberedUsername((HttpServletRequest)request, response), context);
            principal2 = MyFormAuthenticator.authenticate(username, password = this.persistentLoginManager.getRememberedPassword((HttpServletRequest)request, response), context);
            if (principal2 != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("User " + principal2.getName() + " has been authentified from cookie");
                }
                if (!StringUtils.contains((CharSequence)principal2.getName(), (int)58)) {
                    principal2 = new SimplePrincipal(context.getWikiId() + ":" + principal2.getName());
                }
                request.setUserPrincipal(principal2);
                this.getUserAuthenticatedEventNotifier().notify(principal2.getName());
            } else {
                request.setUserPrincipal(null);
                if (username != null || password != null) {
                    this.persistentLoginManager.forgetLogin((HttpServletRequest)request, response);
                }
            }
        }
        if (this.loginSubmitPattern != null && request.getMatchableURL().endsWith(this.loginSubmitPattern)) {
            String username = this.convertUsername(request.getParameter("j_username"), context);
            String password = request.getParameter("j_password");
            String rememberme = request.getParameter("j_rememberme");
            rememberme = rememberme == null ? "false" : rememberme;
            return this.processLogin(username, password, rememberme, request, response, context);
        }
        return false;
    }

    @Override
    public boolean processLogin(String username, String password, String rememberme, SecurityRequestWrapper request, HttpServletResponse response, XWikiContext context) throws Exception {
        Principal principal = MyFormAuthenticator.authenticate(username, password, context);
        AuthenticationFailureManager authenticationFailureManager = Utils.getComponent(AuthenticationFailureManager.class);
        if (principal != null && authenticationFailureManager.validateForm(username, (HttpServletRequest)request)) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("User " + principal.getName() + " has been logged-in");
            }
            authenticationFailureManager.resetAuthenticationFailureCounter(username);
            if (request.getUserPrincipal() != null && !username.equals(request.getRemoteUser())) {
                request.getSession().invalidate();
            }
            if (this.persistentLoginManager != null) {
                if (rememberme != null) {
                    this.persistentLoginManager.rememberLogin((HttpServletRequest)request, response, username, password);
                } else {
                    this.persistentLoginManager.forgetLogin((HttpServletRequest)request, response);
                }
            }
            if (!StringUtils.contains((CharSequence)principal.getName(), (int)58)) {
                principal = new SimplePrincipal(context.getWikiId() + ":" + principal.getName());
            }
            request.setUserPrincipal(principal);
            this.getUserAuthenticatedEventNotifier().notify(principal.getName());
            Boolean bAjax = (Boolean)context.get("ajax");
            if (bAjax == null || !bAjax.booleanValue()) {
                String continueToURL = this.getContinueToURL((HttpServletRequest)request);
                response.sendRedirect(response.encodeRedirectURL(continueToURL));
            }
        } else {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("User " + username + " login has failed");
            }
            authenticationFailureManager.recordAuthenticationFailure(username, (HttpServletRequest)request);
            response.setStatus(401);
        }
        return true;
    }

    private String getContinueToURL(HttpServletRequest request) {
        String savedURL = request.getParameter("xredirect");
        if (StringUtils.isEmpty((CharSequence)savedURL)) {
            savedURL = SavedRequestManager.getOriginalUrl((HttpServletRequest)request);
        }
        if (!StringUtils.isEmpty((CharSequence)savedURL)) {
            return savedURL;
        }
        return request.getContextPath() + this.defaultPage;
    }

    public static Principal authenticate(String username, String password, XWikiContext context) throws XWikiException {
        return context.getWiki().getAuthService().authenticate(username, password, context);
    }

    public boolean processLogout(SecurityRequestWrapper securityRequestWrapper, HttpServletResponse httpServletResponse, URLPatternMatcher urlPatternMatcher) throws Exception {
        boolean result = super.processLogout(securityRequestWrapper, httpServletResponse, urlPatternMatcher);
        if (result && this.persistentLoginManager != null) {
            this.persistentLoginManager.forgetLogin((HttpServletRequest)securityRequestWrapper, httpServletResponse);
        }
        return result;
    }
}

