/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.user.impl.xwiki;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.user.api.XWikiAuthService;
import com.xpn.xwiki.user.api.XWikiUser;
import com.xpn.xwiki.user.impl.xwiki.XWikiAuthServiceImpl;
import java.security.Principal;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyAuthServiceImpl
extends XWikiAuthServiceImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroovyAuthServiceImpl.class);

    @Override
    protected String getParam(String name, XWikiContext context) {
        String param = "";
        try {
            param = context.getWiki().getXWikiPreference(name, context);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (param == null || "".equals(param)) {
            try {
                param = context.getWiki().Param("xwiki.authentication." + StringUtils.replace((String)name, (String)"groovy_", (String)"groovy."));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (param == null) {
            param = "";
        }
        return param;
    }

    public XWikiAuthService getAuthService(XWikiContext context) {
        String authservicepage = this.getParam("groovy_pagename", context);
        if (authservicepage == null || authservicepage.trim().equals("")) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("No page specified for auth service implementation");
            }
            return null;
        }
        try {
            XWikiDocument doc = context.getWiki().getDocument(authservicepage, context);
            if (context.getWiki().getRightService().hasProgrammingRights(doc, context)) {
                return (XWikiAuthService)context.getWiki().parseGroovyFromString(doc.getContent(), context);
            }
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Auth service implementation page " + authservicepage + " missing programming rights, requires ownership by authorized user.");
            }
            return null;
        }
        catch (XWikiException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Exception while parsing groovy authentication service code", (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public XWikiUser checkAuth(XWikiContext context) throws XWikiException {
        XWikiAuthService authservice = this.getAuthService(context);
        if (authservice == null) {
            return super.checkAuth(context);
        }
        try {
            return authservice.checkAuth(context);
        }
        catch (Exception e) {
            return super.checkAuth(context);
        }
    }

    @Override
    public XWikiUser checkAuth(String username, String password, String rememberme, XWikiContext context) throws XWikiException {
        XWikiAuthService authservice = this.getAuthService(context);
        if (authservice == null) {
            return super.checkAuth(username, password, rememberme, context);
        }
        try {
            return authservice.checkAuth(username, password, rememberme, context);
        }
        catch (Exception e) {
            return super.checkAuth(username, password, rememberme, context);
        }
    }

    @Override
    public void showLogin(XWikiContext context) throws XWikiException {
        XWikiAuthService authservice = this.getAuthService(context);
        if (authservice == null) {
            super.showLogin(context);
        } else {
            try {
                authservice.showLogin(context);
            }
            catch (Exception e) {
                super.showLogin(context);
            }
        }
    }

    @Override
    public Principal authenticate(String username, String password, XWikiContext context) throws XWikiException {
        XWikiAuthService authservice = this.getAuthService(context);
        if (authservice == null) {
            return super.authenticate(username, password, context);
        }
        try {
            return authservice.authenticate(username, password, context);
        }
        catch (Exception e) {
            return super.authenticate(username, password, context);
        }
    }
}

