/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.user.impl.xwiki;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.user.api.XWikiUser;
import com.xpn.xwiki.user.impl.xwiki.XWikiAuthServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppServerTrustedKerberosAuthServiceImpl
extends XWikiAuthServiceImpl {
    private static final String DOT = ".";
    private static final String XWIKI_SPACE = "XWiki";
    private static final String AT_SIGN = "@";
    private static final String ANTI_SLASH = "\\";
    private static final Logger LOGGER = LoggerFactory.getLogger(AppServerTrustedKerberosAuthServiceImpl.class);

    @Override
    public XWikiUser checkAuth(XWikiContext context) throws XWikiException {
        Object user = context.getRequest().getRemoteUser();
        LOGGER.debug("Checking auth for remote user [{}]", user);
        if (StringUtils.isBlank((CharSequence)user)) {
            return super.checkAuth(context);
        }
        user = this.extractUsernameFromPrincipal((String)user);
        user = this.createUser((String)user, context);
        user = "XWiki." + (String)user;
        context.setUser((String)user);
        return new XWikiUser((String)user);
    }

    @Override
    public XWikiUser checkAuth(String username, String password, String rememberme, XWikiContext context) throws XWikiException {
        return this.checkAuth(context);
    }

    private String extractUsernameFromPrincipal(String principal) {
        String username = principal;
        if (username.contains(ANTI_SLASH)) {
            username = StringUtils.substringAfter((String)username, (String)ANTI_SLASH);
        }
        if (username.contains(AT_SIGN)) {
            username = StringUtils.substringBeforeLast((String)username, (String)AT_SIGN);
        }
        return username;
    }
}

