/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.store.migration.hibernate;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.IntegerProperty;
import com.xpn.xwiki.objects.StringProperty;
import com.xpn.xwiki.store.XWikiHibernateBaseStore;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.AbstractHibernateDataMigration;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.xwiki.component.annotation.Component;

@Component
@Named(value="R73000XWIKI12277")
@Singleton
public class R73000XWIKI12277DataMigration
extends AbstractHibernateDataMigration {
    @Override
    public String getDescription() {
        return "Migrate TemplateProviderClass' removed 'type' property values to the new 'terminal' property.";
    }

    @Override
    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(73000);
    }

    @Override
    public void hibernateMigrate() throws DataMigrationException, XWikiException {
        this.getStore().executeWrite(this.getXWikiContext(), new XWikiHibernateBaseStore.HibernateCallback<Object>(){

            @Override
            public Object doInHibernate(Session session) throws HibernateException, XWikiException {
                return R73000XWIKI12277DataMigration.this.doWork(session);
            }
        });
    }

    private Object doWork(Session session) throws HibernateException {
        Query query = session.createQuery(this.createQueryString(), Object[].class);
        for (Object[] result : query.list()) {
            BaseObject object = (BaseObject)result[0];
            StringProperty typeProperty = (StringProperty)result[1];
            this.migrateProperty(typeProperty, object, session);
        }
        return Boolean.TRUE;
    }

    private String createQueryString() {
        StringBuilder query = new StringBuilder();
        query.append("SELECT templateProviderObj, typeProp ");
        query.append("FROM BaseObject templateProviderObj, StringProperty typeProp ");
        query.append("WHERE templateProviderObj.className='XWiki.TemplateProviderClass'");
        query.append(" AND templateProviderObj.name<>'XWiki.TemplateProviderTemplate'");
        query.append(" AND typeProp.id.id=templateProviderObj.id");
        query.append(" AND typeProp.name='type'");
        return query.toString();
    }

    private void migrateProperty(StringProperty typeProperty, BaseObject object, Session session) throws HibernateException {
        IntegerProperty terminalProperty = new IntegerProperty();
        int value = 1;
        if ("space".equals(typeProperty.getValue())) {
            value = 0;
        }
        terminalProperty.setValue(value);
        terminalProperty.setName("terminal");
        terminalProperty.setObject(object);
        session.saveOrUpdate((Object)terminalProperty);
        session.delete((Object)typeProperty);
    }
}

