/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.store.migration.hibernate;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiSpace;
import com.xpn.xwiki.store.XWikiHibernateBaseStore;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.AbstractHibernateDataMigration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.model.reference.SpaceReferenceResolver;
import org.xwiki.model.reference.WikiReference;

@Component
@Named(value="R72001XWIKI12228")
@Singleton
public class R72001XWIKI12228DataMigration
extends AbstractHibernateDataMigration {
    private static final WikiReference WIKI = new WikiReference("wiki");
    @Inject
    private SpaceReferenceResolver<String> spaceResolver;

    @Override
    public String getDescription() {
        return "Make sure xwikidocument and xwikispace tables are in sync";
    }

    @Override
    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(72001);
    }

    @Override
    public void hibernateMigrate() throws DataMigrationException, XWikiException {
        this.getStore().executeWrite(this.getXWikiContext(), new XWikiHibernateBaseStore.HibernateCallback<Object>(){

            @Override
            public Object doInHibernate(Session session) throws HibernateException, XWikiException {
                Collection<SpaceReference> visibleSpaces = R72001XWIKI12228DataMigration.this.createVisibleSpaces(session);
                R72001XWIKI12228DataMigration.this.createHiddenSpaces(visibleSpaces, session);
                return Boolean.TRUE;
            }
        });
    }

    private String createSpaceQuery(boolean hidden) {
        StringBuilder query = new StringBuilder("select DISTINCT doc.space from XWikiDocument as doc where");
        if (hidden) {
            query.append(" doc.space not in (" + this.createSpaceQuery(false) + ")");
        } else {
            query.append(" doc.hidden <> true OR doc.hidden IS NULL");
        }
        return query.toString();
    }

    private Collection<SpaceReference> getVisibleSpaces(Session session) {
        Query query = session.createQuery(this.createSpaceQuery(false), String.class);
        ArrayList<SpaceReference> databaseSpaces = new ArrayList<SpaceReference>();
        for (String space : query.list()) {
            databaseSpaces.add(this.spaceResolver.resolve((Object)space, new Object[]{WIKI}));
        }
        HashSet<SpaceReference> spaces = new HashSet<SpaceReference>(databaseSpaces);
        for (SpaceReference space : databaseSpaces) {
            EntityReference parent = space.getParent();
            while (parent instanceof SpaceReference) {
                spaces.add((SpaceReference)parent);
                parent = parent.getParent();
            }
        }
        return spaces;
    }

    private Collection<SpaceReference> getHiddenSpaces(Collection<SpaceReference> visibleSpaces, Session session) {
        Query query = session.createQuery(this.createSpaceQuery(true), String.class);
        ArrayList<SpaceReference> databaseSpaces = new ArrayList<SpaceReference>();
        for (String space : query.list()) {
            databaseSpaces.add(this.spaceResolver.resolve((Object)space, new Object[]{WIKI}));
        }
        HashSet<SpaceReference> spaces = new HashSet<SpaceReference>(databaseSpaces);
        for (SpaceReference space : databaseSpaces) {
            EntityReference parent = space.getParent();
            while (parent instanceof SpaceReference) {
                if (!visibleSpaces.contains(parent)) {
                    spaces.add((SpaceReference)parent);
                }
                parent = parent.getParent();
            }
        }
        return spaces;
    }

    private Collection<SpaceReference> createVisibleSpaces(Session session) {
        Collection<SpaceReference> spaces = this.getVisibleSpaces(session);
        this.createSpaces(spaces, false, session);
        return spaces;
    }

    private void createHiddenSpaces(Collection<SpaceReference> visibleSpaces, Session session) {
        Collection<SpaceReference> spaces = this.getHiddenSpaces(visibleSpaces, session);
        this.createSpaces(spaces, true, session);
    }

    private void createSpaces(Collection<SpaceReference> spaces, boolean hidden, Session session) {
        for (SpaceReference spaceReference : spaces) {
            XWikiSpace space = new XWikiSpace(spaceReference);
            space.setHidden(hidden);
            session.save((Object)space);
        }
    }
}

