/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.store.migration.hibernate;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.rcs.XWikiPatch;
import com.xpn.xwiki.doc.rcs.XWikiRCSNodeContent;
import com.xpn.xwiki.doc.rcs.XWikiRCSNodeId;
import com.xpn.xwiki.store.XWikiHibernateBaseStore;
import com.xpn.xwiki.store.XWikiHibernateVersioningStore;
import com.xpn.xwiki.store.XWikiVersioningStoreInterface;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.AbstractHibernateDataMigration;
import java.util.Iterator;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;

@Component
@Named(value="R6079XWIKI1878")
@Singleton
public class R6079XWIKI1878DataMigration
extends AbstractHibernateDataMigration {
    @Inject
    private Logger logger;

    @Override
    public String getDescription() {
        return "See https://jira.xwiki.org/browse/XWIKI-1878";
    }

    @Override
    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(6079);
    }

    @Override
    public boolean shouldExecute(XWikiDBVersion startupVersion) {
        return startupVersion.getVersion() >= 4360;
    }

    private XWikiHibernateVersioningStore getVersioningStore() throws XWikiException {
        try {
            return (XWikiHibernateVersioningStore)this.componentManager.getInstance(XWikiVersioningStoreInterface.class, "hibernate");
        }
        catch (ComponentLookupException e) {
            throw new XWikiException(3, 3005, String.format("Unable to reach the versioning store for database %s", this.getXWikiContext().getWikiId()), e);
        }
    }

    @Override
    public void hibernateMigrate() throws DataMigrationException, XWikiException {
        this.getStore().executeWrite(this.getXWikiContext(), new XWikiHibernateBaseStore.HibernateCallback<Object>(){

            @Override
            public Object doInHibernate(Session session) throws HibernateException, XWikiException {
                try {
                    Query query = session.createQuery("select rcs.id, rcs.patch, doc.fullName from XWikiDocument as doc, XWikiRCSNodeContent as rcs where doc.id = rcs.id.docId and rcs.patch.diff = true and rcs.patch.content like '<?xml%'", Object[].class);
                    Iterator it = query.list().iterator();
                    XWikiContext context = R6079XWIKI1878DataMigration.this.getXWikiContext();
                    XWikiHibernateVersioningStore versioningStore = R6079XWIKI1878DataMigration.this.getVersioningStore();
                    Transaction originalTransaction = versioningStore.getTransaction(context);
                    versioningStore.setSession(null, context);
                    versioningStore.setTransaction(null, context);
                    while (it.hasNext()) {
                        Object[] result = (Object[])it.next();
                        if (R6079XWIKI1878DataMigration.this.logger.isInfoEnabled()) {
                            R6079XWIKI1878DataMigration.this.logger.info("Fixing document [{}]...", result[2]);
                        }
                        XWikiRCSNodeId nodeId = (XWikiRCSNodeId)result[0];
                        XWikiRCSNodeContent fixedNodeContent = new XWikiRCSNodeContent(nodeId);
                        XWikiPatch patch = (XWikiPatch)result[1];
                        patch.setDiff(false);
                        fixedNodeContent.setPatch(patch);
                        session.update((Object)fixedNodeContent);
                    }
                    versioningStore.setSession(session, context);
                    versioningStore.setTransaction(originalTransaction, context);
                }
                catch (Exception e) {
                    throw new XWikiException(3, 3005, R6079XWIKI1878DataMigration.this.getName() + " migration failed", e);
                }
                return Boolean.TRUE;
            }
        });
    }
}

