/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.store.migration.hibernate;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.store.DatabaseProduct;
import com.xpn.xwiki.store.XWikiHibernateBaseStore;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.AbstractHibernateDataMigration;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.jdbc.Work;
import org.xwiki.component.annotation.Component;

@Component
@Named(value="R42000XWIKI7726")
@Singleton
public class R42000XWIKI7726DataMigration
extends AbstractHibernateDataMigration {
    @Override
    public String getDescription() {
        return "Increase the size of the standard BLOB and CLOB columns which were created with the default 16M size.";
    }

    @Override
    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(42000);
    }

    @Override
    public boolean shouldExecute(XWikiDBVersion startupVersion) {
        try {
            return this.getStore().getDatabaseProductName() == DatabaseProduct.HSQLDB;
        }
        catch (DataMigrationException ex) {
            return false;
        }
    }

    @Override
    public void hibernateMigrate() throws DataMigrationException, XWikiException {
        this.getStore().executeWrite(this.getXWikiContext(), new XWikiHibernateBaseStore.HibernateCallback<Object>(){

            @Override
            public Object doInHibernate(Session session) throws HibernateException, XWikiException {
                session.doWork((Work)new R42000Work());
                return Boolean.TRUE;
            }
        });
    }

    private static final class R42000Work
    implements Work {
        private R42000Work() {
        }

        public void execute(Connection connection) throws SQLException {
            this.processColumn("XWIKIRCS", "XWR_PATCH", connection);
            this.processColumn("XWIKIRECYCLEBIN", "XDD_XML", connection);
            this.processColumn("XWIKIATTRECYCLEBIN", "XDA_XML", connection);
            this.processColumn("XWIKIATTACHMENT_CONTENT", "XWA_CONTENT", connection);
            this.processColumn("XWIKIATTACHMENT_ARCHIVE", "XWA_ARCHIVE", connection);
        }

        private void processColumn(String tableName, String columnName, Connection connection) throws SQLException {
            String command = "ALTER TABLE %s ALTER COLUMN %s SET DATA TYPE %s(%d)";
            PreparedStatement getCurrentColumnType = connection.prepareStatement("select DATA_TYPE from INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = ? AND COLUMN_NAME=?");
            getCurrentColumnType.setString(1, tableName);
            getCurrentColumnType.setString(2, columnName);
            ResultSet result = getCurrentColumnType.executeQuery();
            if (!result.next()) {
                return;
            }
            String currentColumnType = result.getString(1);
            result.close();
            getCurrentColumnType.close();
            connection.createStatement().execute(String.format(command, tableName, columnName, currentColumnType, 0x40000000));
        }
    }
}

