/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.store.migration.hibernate;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.store.DatabaseProduct;
import com.xpn.xwiki.store.XWikiHibernateBaseStore;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.AbstractHibernateDataMigration;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.jdbc.Work;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.annotation.Component;

@Component
@Named(value="R35102XWIKI7771")
@Singleton
public class R35102XWIKI7771DataMigration
extends AbstractHibernateDataMigration {
    @Override
    public String getDescription() {
        return "See https://jira.xwiki.org/browse/XWIKI-7771";
    }

    @Override
    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(35102);
    }

    @Override
    public boolean shouldExecute(XWikiDBVersion startupVersion) {
        boolean shouldExecute = false;
        try {
            this.getStore().beginTransaction(this.getXWikiContext());
            shouldExecute = startupVersion.getVersion() > 0 && this.getStore().getDatabaseProductName() == DatabaseProduct.POSTGRESQL;
            this.getStore().endTransaction(this.getXWikiContext(), false);
        }
        catch (XWikiException xWikiException) {
        }
        catch (DataMigrationException dataMigrationException) {
            // empty catch block
        }
        return shouldExecute;
    }

    @Override
    public void hibernateMigrate() throws DataMigrationException, XWikiException {
        this.getStore().executeWrite(this.getXWikiContext(), new XWikiHibernateBaseStore.HibernateCallback<Object>(){

            @Override
            public Object doInHibernate(Session session) throws HibernateException, XWikiException {
                session.doWork((Work)new R35102Work("xwikircs", "xwr_patch", "xwr_docid", "History for document with ID"));
                session.doWork((Work)new R35102Work("xwikirecyclebin", "xdd_xml", "xdd_id", "Deleted document with ID"));
                session.doWork((Work)new R35102Work("xwikiattrecyclebin", "xda_xml", "xda_id", "Deleted attachment with ID"));
                return Boolean.TRUE;
            }
        });
    }

    private static class R35102Work
    implements Work {
        private String tableName;
        private String columnName;
        private String idColumnName;
        private String dataType;
        private Logger logger = LoggerFactory.getLogger(R35102Work.class);

        R35102Work(String tableName, String columnName, String idColumnName, String dataType) {
            this.tableName = tableName;
            this.columnName = columnName;
            this.idColumnName = idColumnName;
            this.dataType = dataType;
        }

        public void execute(Connection connection) throws SQLException {
            Statement stmt = connection.createStatement();
            ResultSet lobs = stmt.executeQuery("SELECT " + this.columnName + ", " + this.idColumnName + " FROM " + this.tableName + ";");
            HashMap<String, Long> lobsToProcess = new HashMap<String, Long>();
            while (lobs.next()) {
                if (!StringUtils.isNumeric((CharSequence)lobs.getString(1))) continue;
                lobsToProcess.put(lobs.getString(1), lobs.getLong(2));
            }
            PreparedStatement inlineLob = connection.prepareStatement(MessageFormat.format("UPDATE {0} SET {1} = convert_from(loread(lo_open({1}::int, 262144), 10000000), ''LATIN1'') WHERE {1} = ?", this.tableName, this.columnName));
            PreparedStatement emptyLob = connection.prepareStatement(MessageFormat.format("UPDATE {0} SET {1} = '''' WHERE {1} = ?", this.tableName, this.columnName));
            PreparedStatement removeLob = connection.prepareStatement("select lo_unlink(?)");
            for (Map.Entry lob : lobsToProcess.entrySet()) {
                try {
                    inlineLob.setString(1, (String)lob.getKey());
                    inlineLob.executeUpdate();
                    removeLob.setLong(1, Long.valueOf((String)lob.getKey()));
                    removeLob.execute();
                    connection.commit();
                }
                catch (SQLException ex) {
                    if (ex.getMessage().contains("0x00")) {
                        connection.rollback();
                        this.logger.warn(this.dataType + " [{}] cannot be recovered", lob.getValue());
                        emptyLob.setString(1, (String)lob.getKey());
                        emptyLob.executeUpdate();
                        removeLob.setLong(1, Long.valueOf((String)lob.getKey()));
                        removeLob.execute();
                        connection.commit();
                        continue;
                    }
                    throw ex;
                }
            }
        }
    }
}

