/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.store.migration.hibernate;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.store.XWikiHibernateBaseStore;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.AbstractHibernateDataMigration;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.xwiki.component.annotation.Component;

@Component
@Named(value="R15428XWIKI2977")
@Singleton
public class R15428XWIKI2977DataMigration
extends AbstractHibernateDataMigration {
    @Override
    public String getDescription() {
        return "Add a GUID to existing objects when upgrading from pre-1.8M1.";
    }

    @Override
    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(15428);
    }

    @Override
    public void hibernateMigrate() throws DataMigrationException, XWikiException {
        this.getStore().executeWrite(this.getXWikiContext(), new XWikiHibernateBaseStore.HibernateCallback<Object>(){

            @Override
            public Object doInHibernate(Session session) throws HibernateException, XWikiException {
                Query q = session.createQuery("select o from BaseObject o where o.guid is null", BaseObject.class);
                List lst = q.list();
                if (!lst.isEmpty()) {
                    ArrayList<BaseObject> lst2 = new ArrayList<BaseObject>(lst.size());
                    for (BaseObject o : lst) {
                        o.setGuid(UUID.randomUUID().toString());
                        lst2.add(o);
                    }
                    for (BaseObject o : lst2) {
                        session.update((Object)o);
                    }
                }
                return null;
            }
        });
    }
}

