/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.store.migration.hibernate;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.DocumentRevisionProvider;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.doc.XWikiDocumentArchive;
import com.xpn.xwiki.doc.rcs.XWikiRCSNodeInfo;
import com.xpn.xwiki.internal.mandatory.XWikiUsersDocumentInitializer;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.AbstractHibernateDataMigration;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.environment.Environment;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryFilter;
import org.xwiki.query.QueryManager;
import org.xwiki.user.UserReferenceSerializer;

@Component
@Singleton
@Named(value="140600000XWIKI19869")
public class R140600000XWIKI19869DataMigration
extends AbstractHibernateDataMigration {
    public static final String HINT = "140600000XWIKI19869";
    private static final String FILENAME = "140600000XWIKI19869DataMigration-users.txt";
    private static final String XWQL_QUERY = "select distinct doc.fullName from Document doc, doc.object(XWiki.XWikiUsers) objUser where objUser.password not like 'hash:%' and objUser.password <> '' order by doc.fullName";
    private static final String PASSWORD_FIELD = "password";
    private static final int BATCH_SIZE = 100;
    @Inject
    private QueryManager queryManager;
    @Inject
    private DocumentReferenceResolver<String> documentReferenceResolver;
    @Inject
    private DocumentRevisionProvider documentRevisionProvider;
    @Inject
    private Provider<UserReferenceSerializer<String>> userReferenceSerializerProvider;
    @Inject
    @Named(value="count")
    private Provider<QueryFilter> countFilterProvider;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    private Environment environment;
    @Inject
    @Named(value="xwikiproperties")
    private Provider<ConfigurationSource> propertiesConfigurationProvider;
    @Inject
    private Logger logger;

    @Override
    public String getDescription() {
        return "Migrate wrongly stored passwords information.";
    }

    @Override
    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(140600000);
    }

    @Override
    public boolean shouldExecute(XWikiDBVersion startupVersion) {
        if (this.getXWikiContext().isMainWiki()) {
            int version = startupVersion.getVersion();
            return !(version >= 131008000 && version < 140000000 || version >= 140403000 && version < 140500000);
        }
        return false;
    }

    @Override
    protected void hibernateMigrate() throws DataMigrationException, XWikiException {
        ConfigurationSource configurationSource = (ConfigurationSource)this.propertiesConfigurationProvider.get();
        boolean resetPassword = (Boolean)configurationSource.getProperty("security.migration.R140600000XWIKI19869.resetPassword", (Object)true);
        long numberOfUsersToMigrate = this.getNumberOfUsersToMigrate();
        this.logger.info("The migration will need to process [{}] user documents", (Object)numberOfUsersToMigrate);
        File migrationFile = new File(this.environment.getPermanentDirectory(), FILENAME);
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(migrationFile.toPath(), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.APPEND);){
            List<DocumentReference> users;
            do {
                if ((users = this.getUsers()).isEmpty()) continue;
                this.logger.info("Start processing [{}] users over [{}]", (Object)users.size(), (Object)numberOfUsersToMigrate);
                for (DocumentReference userReference : users) {
                    this.handleUser(userReference, resetPassword, bufferedWriter);
                }
                bufferedWriter.flush();
            } while (!users.isEmpty());
        }
        catch (IOException e) {
            throw new DataMigrationException("Error while trying to create the migration file for sending users instructions to reset their password. If you cannot resolve the problem, you can skip this check by setting the property 'security.migration.R140600000XWIKI19869.requireMigrationFile' in xwiki.properties.", e);
        }
    }

    private long getNumberOfUsersToMigrate() {
        long result = -1L;
        try {
            Query query = this.queryManager.createQuery(XWQL_QUERY, "xwql").addFilter((QueryFilter)this.countFilterProvider.get());
            List countValue = query.execute();
            result = (Long)countValue.get(0);
        }
        catch (QueryException e) {
            this.logger.warn("Error while trying to count the number of users", (Throwable)e);
        }
        return result;
    }

    private List<DocumentReference> getUsers() throws DataMigrationException {
        try {
            Query query = this.queryManager.createQuery(XWQL_QUERY, "xwql").setLimit(100);
            List usersList = query.execute();
            return usersList.stream().map(x$0 -> this.documentReferenceResolver.resolve(x$0, new Object[0])).collect(Collectors.toList());
        }
        catch (QueryException e) {
            throw new DataMigrationException("Error while querying the list of users", e);
        }
    }

    private void handleUser(DocumentReference userDocReference, boolean resetPassword, BufferedWriter bufferedWriter) throws XWikiException {
        XWikiContext context = this.getXWikiContext();
        XWikiDocument userDoc = context.getWiki().getDocument(userDocReference, context);
        if (this.fixPasswordHash(userDoc, true, resetPassword)) {
            String serializedUserRef = (String)this.entityReferenceSerializer.serialize((EntityReference)userDocReference, new Object[0]);
            this.handleHistory(userDoc);
            context.getWiki().saveDocument(userDoc, context);
            try {
                bufferedWriter.write(serializedUserRef + "\n");
            }
            catch (IOException e) {
                this.logger.warn("Error when writing in migration file (root cause was [{}]. Please reach individually [{}] for resetting their password.", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e), (Object)serializedUserRef);
            }
        }
    }

    private void handleHistory(XWikiDocument userDoc) throws XWikiException {
        XWikiContext context = this.getXWikiContext();
        XWikiDocumentArchive documentArchive = userDoc.getDocumentArchive(context);
        Collection<XWikiRCSNodeInfo> archiveNodes = documentArchive.getNodes();
        for (XWikiRCSNodeInfo node : new ArrayList<XWikiRCSNodeInfo>(archiveNodes)) {
            try {
                XWikiDocument revision = this.documentRevisionProvider.getRevision(userDoc, node.getVersion().toString());
                if (!this.fixPasswordHash(revision, false, false)) continue;
                String author = (String)((UserReferenceSerializer)this.userReferenceSerializerProvider.get()).serialize(revision.getAuthors().getOriginalMetadataAuthor());
                documentArchive.updateArchive(revision, author, revision.getDate(), revision.getComment(), revision.getRCSVersion(), context);
            }
            catch (Exception e) {
                this.logger.warn("Failed to handler revision [{}] for user page [{}]: {}. It's recommended to delete this version.", new Object[]{node.getVersion().toString(), userDoc.getDocumentReference(), ExceptionUtils.getRootCauseMessage((Throwable)e)});
            }
        }
    }

    private boolean fixPasswordHash(XWikiDocument userDoc, boolean isMain, boolean resetPassword) {
        boolean result = false;
        XWikiContext context = this.getXWikiContext();
        BaseObject userObj = userDoc.getXObject((EntityReference)XWikiUsersDocumentInitializer.XWIKI_USERS_DOCUMENT_REFERENCE);
        if (userObj != null) {
            String password = userObj.getStringValue(PASSWORD_FIELD);
            if (!password.startsWith("hash:")) {
                try {
                    if (isMain && resetPassword) {
                        userObj.set(PASSWORD_FIELD, "", context);
                    } else {
                        userObj.set(PASSWORD_FIELD, password, context);
                    }
                }
                catch (XWikiException e) {
                    this.logger.error("Error while reseting password field for user [{}]", (Object)userDoc, (Object)e);
                }
                result = true;
            } else if (isMain) {
                this.logger.warn("User document was wrongly retrieved [{}] it won't be modified.", (Object)userDoc.getDocumentReference());
            }
        } else if (isMain) {
            this.logger.warn("Null user object for document [{}] this should never happen.", (Object)userDoc.getDocumentReference());
        }
        return result;
    }
}

