/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.store.migration.hibernate;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.AbstractHibernateDataMigration;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;

@Component
@Named(value="R140000000XWIKI19125")
@Singleton
public class R140000000XWIKI19125DataMigration
extends AbstractHibernateDataMigration {
    @Inject
    private Logger logger;

    @Override
    public String getDescription() {
        return "Copy author value to the new originalMetadataAuthorReference column";
    }

    @Override
    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(140000000);
    }

    @Override
    protected void hibernateMigrate() throws DataMigrationException, XWikiException {
        Integer updatedDocuments = this.getStore().executeWrite(this.getXWikiContext(), this::updateDocuments);
        this.logger.info("[{}] documents updated on database [{}]", (Object)updatedDocuments, (Object)this.getXWikiContext().getWikiId());
    }

    private int updateDocuments(Session session) {
        Query query = session.createQuery("update XWikiDocument doc set doc.originalMetadataAuthorReference = doc.author");
        return query.executeUpdate();
    }
}

