/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.store.migration.hibernate;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.internal.store.hibernate.HibernateStore;
import com.xpn.xwiki.stats.impl.RefererStats;
import com.xpn.xwiki.stats.impl.VisitStats;
import com.xpn.xwiki.store.DatabaseProduct;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.AbstractHibernateDataMigration;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hibernate.boot.Metadata;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;

@Component
@Named(value="R130200000XWIKI17200")
@Singleton
public class R130200000XWIKI17200DataMigration
extends AbstractHibernateDataMigration {
    @Inject
    private Logger logger;
    @Inject
    private HibernateStore hibernateStore;

    @Override
    public String getDescription() {
        return "Make sure the database follow the currently expected type for some large string columns.";
    }

    @Override
    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(130200000);
    }

    @Override
    protected void hibernateMigrate() throws DataMigrationException, XWikiException {
    }

    @Override
    public boolean shouldExecute(XWikiDBVersion startupVersion) {
        return this.hibernateStore.getDatabaseProductName() == DatabaseProduct.MYSQL;
    }

    @Override
    public String getPreHibernateLiquibaseChangeLog() throws DataMigrationException {
        StringBuilder builder = new StringBuilder();
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("org.xwiki.eventstream.store.internal.LegacyEvent", Arrays.asList("url", "title", "body", "param1", "param2", "param3", "param4", "param5"));
        map.put(RefererStats.class.getName(), Arrays.asList("referer"));
        map.put(VisitStats.class.getName(), Arrays.asList("userAgent", "cookie"));
        map.put("XWiki.XWikiPreferences", Arrays.asList("leftPanels", "rightPanels", "documentBundles"));
        try (SessionImplementor session = (SessionImplementor)this.hibernateStore.getSessionFactory().openSession();){
            JdbcConnectionAccess jdbcConnectionAccess = session.getJdbcConnectionAccess();
            try (Connection connection = jdbcConnectionAccess.obtainConnection();){
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                this.deleteIndexIfExist(VisitStats.class, "xwv_cookie", databaseMetaData, builder);
                for (Map.Entry entry : map.entrySet()) {
                    for (String property : (List)entry.getValue()) {
                        this.maybeUpdateField(databaseMetaData, (String)entry.getKey(), property, builder);
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new DataMigrationException("Error while extracting metadata", e);
        }
        if (builder.length() > 0) {
            return String.format("<changeSet author=\"xwiki\" id=\"R%s\">%s</changeSet>", this.getVersion().getVersion(), builder.toString());
        }
        return null;
    }

    private void deleteIndexIfExist(Class entityClass, String indexName, DatabaseMetaData databaseMetaData, StringBuilder builder) throws SQLException {
        String databaseName = this.hibernateStore.getAdapter().getDatabaseFromWikiName();
        PersistentClass persistentClass = this.hibernateStore.getConfigurationMetadata().getEntityBinding(entityClass.getName());
        String tableName = this.hibernateStore.getAdapter().getTableName(persistentClass);
        ResultSet resultSet = this.hibernateStore.getAdapter().isCatalog() ? databaseMetaData.getIndexInfo(databaseName, null, tableName, false, false) : databaseMetaData.getIndexInfo(null, databaseName, tableName, false, false);
        while (resultSet.next()) {
            String databaseIndexName = resultSet.getString("INDEX_NAME");
            if (!indexName.equalsIgnoreCase(databaseIndexName)) continue;
            builder.append("<dropIndex indexName=\"");
            builder.append(databaseIndexName);
            builder.append("\"  tableName=\"");
            builder.append(tableName);
            builder.append("\"/>\n");
            break;
        }
    }

    private void maybeUpdateField(DatabaseMetaData databaseMetaData, String entity, String propertyName, StringBuilder update) throws SQLException {
        Metadata configurationMetadata = this.hibernateStore.getConfigurationMetadata();
        PersistentClass persistentClass = configurationMetadata.getEntityBinding(entity);
        Property property = persistentClass.getProperty(propertyName);
        String tableName = this.hibernateStore.getAdapter().getTableName(persistentClass);
        String columnName = this.hibernateStore.getConfiguredColumnName(persistentClass, propertyName);
        try (ResultSet resultSet = this.getColumns(databaseMetaData, tableName, columnName);){
            if (resultSet.next()) {
                String currentColumnType = resultSet.getString("TYPE_NAME");
                Column column = (Column)property.getColumnIterator().next();
                String expectedColumnType = this.hibernateStore.getDialect().getTypeName(column.getSqlTypeCode((Mapping)configurationMetadata));
                if (!currentColumnType.equalsIgnoreCase(expectedColumnType)) {
                    int expectedLenght = column.getLength();
                    int currentColumnSize = resultSet.getInt("COLUMN_SIZE");
                    if (currentColumnSize > expectedLenght) {
                        column.setLength(currentColumnSize);
                    }
                    String dataType = this.getDataType(column, configurationMetadata);
                    update.append("<sql>");
                    update.append(this.hibernateStore.getDialect().getAlterTableString(tableName));
                    update.append(" MODIFY ");
                    update.append(column.getQuotedName(this.hibernateStore.getDialect()));
                    update.append(' ');
                    update.append(dataType);
                    update.append("</sql>");
                    this.logger.info("Updating the type of [{}.{}] to [{}]", new Object[]{tableName, columnName, dataType});
                }
            }
        }
    }

    private String getDataType(Column column, Metadata configurationMetadata) {
        Dialect dialect = this.hibernateStore.getDialect();
        StringBuilder builder = new StringBuilder(column.getSqlType(dialect, (Mapping)configurationMetadata));
        if (column.isNullable()) {
            builder.append(dialect.getNullColumnString());
        } else {
            builder.append(" not null");
        }
        return builder.toString();
    }

    private ResultSet getColumns(DatabaseMetaData databaseMetaData, String tableName, String columnName) throws SQLException {
        if (this.hibernateStore.getAdapter().isCatalog()) {
            return databaseMetaData.getColumns(this.hibernateStore.getAdapter().getDatabaseFromWikiName(), null, tableName, columnName);
        }
        return databaseMetaData.getColumns(null, this.hibernateStore.getAdapter().getDatabaseFromWikiName(), tableName, columnName);
    }
}

