/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.store.migration.hibernate;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.mandatory.XWikiUsersDocumentInitializer;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.AbstractHibernateDataMigration;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;

@Component
@Named(value="R1138000XWIKI16709")
@Singleton
public class R1138000XWIKI16709DataMigration
extends AbstractHibernateDataMigration {
    private static final String OLD_DISABLED_PROPERTY = "disabled";
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> documentReferenceResolver;
    @Inject
    private Logger logger;

    @Override
    public String getDescription() {
        return "Remove disable property and add checked_email property in XWikiUser documents.";
    }

    @Override
    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(1138000);
    }

    @Override
    protected void hibernateMigrate() throws DataMigrationException, XWikiException {
        List allUsers = this.getStore().executeRead(this.getXWikiContext(), this::getAllUsers);
        this.logger.info("Migration needed for [{}] users on database [{}].", (Object)allUsers.size(), (Object)this.getXWikiContext().getWikiId());
        DocumentReference wikiUserClassReference = new DocumentReference(XWikiUsersDocumentInitializer.XWIKI_USERS_DOCUMENT_REFERENCE, this.getXWikiContext().getWikiReference());
        BaseClass xwikiUserClass = this.getXWikiContext().getWiki().getXClass(wikiUserClassReference, this.getXWikiContext());
        if (xwikiUserClass != null) {
            this.removeDisableProperty(xwikiUserClass);
            int i = 0;
            int failures = 0;
            for (String user : allUsers) {
                try {
                    this.applyMigrationsOnUser(user, xwikiUserClass);
                }
                catch (XWikiException e) {
                    this.logger.error("Error while migrating information for user [{}] on database [{}]", new Object[]{user, this.getXWikiContext().getWikiId(), e});
                    ++failures;
                }
                if (++i % 100 != 0) continue;
                this.logger.info("[{}] users on [{}] have been migrated on database [{}]...", new Object[]{i - failures, allUsers.size(), this.getXWikiContext().getWikiId()});
            }
            this.logger.info("[{}] users on [{}] have been migrated on database [{}].", new Object[]{allUsers.size() - failures, allUsers.size(), this.getXWikiContext().getWikiId()});
            if (failures > 0) {
                this.logger.warn("[{}] users have not been properly migrated, please check the logs above.", (Object)failures);
            }
        } else {
            throw new XWikiException(3, 3005, String.format("The XWikiUsers XClass with reference [%s] has not been found, the migration [%s] cannot be performed.", wikiUserClassReference, this.getName()));
        }
    }

    private List<String> getAllUsers(Session session) throws HibernateException, XWikiException {
        Query query = session.createQuery("select obj.name from BaseObject obj where obj.className = 'XWiki.XWikiUsers' and obj.id not in (select prop.id.id from IntegerProperty prop where prop.id.name='email_checked')", String.class);
        return query.list();
    }

    private void applyMigrationsOnUser(String docUser, BaseClass xwikiUserXClass) throws XWikiException {
        XWikiContext context = this.getXWikiContext();
        XWiki xwiki = context.getWiki();
        DocumentReference userDocReference = this.documentReferenceResolver.resolve((Object)docUser, new Object[0]);
        XWikiDocument userDocument = xwiki.getDocument(userDocReference, context);
        BaseObject userObject = (userDocument = userDocument.clone()).getXObject(xwikiUserXClass.getReference());
        if (userObject != null) {
            int disable = userObject.getIntValue(OLD_DISABLED_PROPERTY, 0);
            int active = userObject.getIntValue("active", 1);
            int newActive = active == 1 && disable == 0 ? 1 : 0;
            userObject.setIntValue("email_checked", active);
            userObject.setIntValue("active", newActive);
            userObject.removeField(OLD_DISABLED_PROPERTY);
            xwiki.saveDocument(userDocument, context);
        }
    }

    private void removeDisableProperty(BaseClass xwikiUserXClass) throws XWikiException {
        XWikiContext context = this.getXWikiContext();
        XWiki xwiki = context.getWiki();
        xwikiUserXClass.removeField(OLD_DISABLED_PROPERTY);
        xwiki.saveDocument(xwikiUserXClass.getOwnerDocument(), context);
    }
}

