/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.store.migration.hibernate;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.store.hibernate.HibernateStore;
import com.xpn.xwiki.store.XWikiHibernateBaseStore;
import com.xpn.xwiki.store.XWikiStoreInterface;
import com.xpn.xwiki.store.migration.AbstractDataMigrationManager;
import com.xpn.xwiki.store.migration.DataMigration;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.HibernateDataMigration;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import liquibase.Contexts;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ResourceAccessor;
import liquibase.sdk.resource.MockResourceAccessor;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;

@Component
@Named(value="hibernate")
@Singleton
public class HibernateDataMigrationManager
extends AbstractDataMigrationManager {
    private static final String LIQUIBASE_RESOURCE = "liquibase-xwiki/";
    public static final String CHANGELOG_NAME = "liquibase.xml";

    public XWikiHibernateBaseStore getBaseStore() throws DataMigrationException {
        try {
            return (XWikiHibernateBaseStore)this.componentManager.getInstance(XWikiStoreInterface.class, "hibernate");
        }
        catch (ComponentLookupException e) {
            throw new DataMigrationException("Unable to reach the base store", e);
        }
    }

    private HibernateStore getStore() throws DataMigrationException {
        try {
            return (HibernateStore)this.componentManager.getInstance(HibernateStore.class);
        }
        catch (ComponentLookupException e) {
            throw new DataMigrationException("Unable to reach the store", e);
        }
    }

    @Override
    public XWikiDBVersion getDBVersionFromDatabase() throws DataMigrationException {
        XWikiDBVersion ver = this.getDBVersionFromConfig();
        if (ver != null) {
            return ver;
        }
        XWikiContext context = this.getXWikiContext();
        HibernateStore store = this.getStore();
        if (!store.tableExists(XWikiDBVersion.class)) {
            if (!store.tableExists(XWikiDocument.class)) {
                return null;
            }
            return new XWikiDBVersion(0);
        }
        XWikiHibernateBaseStore baseStore = this.getBaseStore();
        try {
            ver = baseStore.executeRead(context, new XWikiHibernateBaseStore.HibernateCallback<XWikiDBVersion>(){

                @Override
                public XWikiDBVersion doInHibernate(Session session) throws HibernateException {
                    CriteriaBuilder builder = session.getCriteriaBuilder();
                    CriteriaQuery query = builder.createQuery(XWikiDBVersion.class);
                    Root root = query.from(XWikiDBVersion.class);
                    query.select((Selection)root);
                    List versions = session.createQuery(query).getResultList();
                    return versions.isEmpty() ? new XWikiDBVersion(0) : (XWikiDBVersion)versions.get(0);
                }
            });
        }
        catch (XWikiException e) {
            throw new DataMigrationException("Failed to get the database version", e);
        }
        return ver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initializeEmptyDB() throws DataMigrationException {
        XWikiContext context = this.getXWikiContext();
        XWikiHibernateBaseStore store = this.getBaseStore();
        Session originalSession = store.getSession(context);
        Transaction originalTransaction = store.getTransaction(context);
        store.setSession(null, context);
        store.setTransaction(null, context);
        try {
            this.updateSchema(null);
            this.setDBVersion(this.getLatestVersion());
        }
        finally {
            store.setSession(originalSession, context);
            store.setTransaction(originalTransaction, context);
        }
    }

    @Override
    protected void setDBVersionToDatabase(XWikiDBVersion version) throws DataMigrationException {
        XWikiContext context = this.getXWikiContext();
        try {
            this.getBaseStore().executeWrite(context, session -> {
                session.createQuery("delete from " + XWikiDBVersion.class.getName()).executeUpdate();
                session.save((Object)version);
                return null;
            });
        }
        catch (Exception e) {
            throw new DataMigrationException(String.format("Unable to store new data version %d into database %s", version.getVersion(), context.getWikiId()), e);
        }
    }

    @Override
    protected void updateSchema(Collection<AbstractDataMigrationManager.XWikiMigration> migrations) throws DataMigrationException {
        try {
            this.liquibaseUpdate(migrations, true);
            this.hibernateShemaUpdate();
            this.liquibaseUpdate(migrations, false);
        }
        catch (Exception e) {
            throw new DataMigrationException(String.format("Unable to update schema of wiki [%s]", this.getXWikiContext().getWikiId()), e);
        }
    }

    private void hibernateShemaUpdate() throws DataMigrationException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Checking Hibernate mapping and updating schema if needed for wiki [{}]", (Object)this.getXWikiContext().getWikiId());
        }
        this.getBaseStore().updateSchema(this.getXWikiContext(), true);
    }

    private void liquibaseUpdate(Collection<AbstractDataMigrationManager.XWikiMigration> migrations, boolean preHibernate) throws XWikiException, DataMigrationException {
        String database = this.getXWikiContext().getWikiId();
        if (migrations != null) {
            for (AbstractDataMigrationManager.XWikiMigration migration : migrations) {
                if (!(migration.dataMigration instanceof HibernateDataMigration)) continue;
                this.liquibaseUpdate((HibernateDataMigration)migration.dataMigration, preHibernate, database);
            }
        }
        if (!preHibernate) {
            try {
                if (this.getClass().getClassLoader().getResources(LIQUIBASE_RESOURCE).hasMoreElements()) {
                    this.logger.info("Execute liquibase changes from [{}] resource on database [{}]", (Object)LIQUIBASE_RESOURCE, (Object)database);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void liquibaseUpdate(HibernateDataMigration migration, boolean preHibernate, String database) throws XWikiException, DataMigrationException {
        String liquibaseChangeLogs = preHibernate ? migration.getPreHibernateLiquibaseChangeLog() : migration.getLiquibaseChangeLog();
        if (liquibaseChangeLogs == null || liquibaseChangeLogs.length() == 0) {
            return;
        }
        if (this.logger.isInfoEnabled()) {
            if (preHibernate) {
                this.logger.info("Running early schema updates (using liquibase) for migration [{}] on database [{}]", (Object)migration.getName(), (Object)database);
            } else {
                this.logger.info("Running additional schema updates (using liquibase) for migration [{}] on database [{}]", (Object)migration.getName(), (Object)database);
            }
        }
        this.liquibaseUpdate(liquibaseChangeLogs, database);
    }

    private void liquibaseUpdate(String liquibaseChangeLogs, final String database) throws XWikiException, DataMigrationException {
        final StringBuilder changeLogs = new StringBuilder(10000);
        changeLogs.append(this.getLiquibaseChangeLogHeader());
        changeLogs.append(liquibaseChangeLogs);
        changeLogs.append(this.getLiquibaseChangeLogFooter());
        final XWikiHibernateBaseStore store = this.getBaseStore();
        store.executeRead(this.getXWikiContext(), new XWikiHibernateBaseStore.HibernateCallback<Object>(){

            @Override
            public Object doInHibernate(Session session) throws XWikiException {
                session.doWork(connection -> {
                    Liquibase lb;
                    try {
                        Database lbDatabase = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(connection));
                        lbDatabase.setDefaultSchemaName(store.getSchemaFromWikiName(HibernateDataMigrationManager.this.getXWikiContext()));
                        lb = new Liquibase(HibernateDataMigrationManager.CHANGELOG_NAME, (ResourceAccessor)new MockResourceAccessor(Map.of(HibernateDataMigrationManager.CHANGELOG_NAME, changeLogs.toString())), lbDatabase);
                    }
                    catch (LiquibaseException e) {
                        throw new HibernateException((Throwable)new XWikiException(3, 3005, String.format("Unable to launch liquibase for database %s, schema update failed.", database), e));
                    }
                    try {
                        lb.update((Contexts)null);
                    }
                    catch (LiquibaseException e) {
                        throw new HibernateException((Throwable)new XWikiException(3, 3005, String.format("Unable to update schema of database %s.", database), e));
                    }
                });
                return null;
            }
        });
    }

    private String getLiquibaseChangeLogHeader() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<databaseChangeLog\n    xmlns=\"http://www.liquibase.org/xml/ns/dbchangelog\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xmlns:ext=\"http://www.liquibase.org/xml/ns/dbchangelog-ext\"\n    xsi:schemaLocation=\"http://www.liquibase.org/xml/ns/dbchangelog http://www.liquibase.org/xml/ns/dbchangelog/dbchangelog-3.1.xsd\">";
    }

    private String getLiquibaseChangeLogFooter() {
        return "</databaseChangeLog>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void startMigrations() throws DataMigrationException {
        XWikiContext context = this.getXWikiContext();
        XWikiHibernateBaseStore store = this.getBaseStore();
        Session originalSession = store.getSession(context);
        Transaction originalTransaction = store.getTransaction(context);
        store.setSession(null, context);
        store.setTransaction(null, context);
        try {
            super.startMigrations();
        }
        finally {
            store.setSession(originalSession, context);
            store.setTransaction(originalTransaction, context);
        }
    }

    @Override
    protected List<? extends DataMigration> getAllMigrations() throws DataMigrationException {
        try {
            return this.componentManager.getInstanceList(HibernateDataMigration.class);
        }
        catch (ComponentLookupException e) {
            throw new DataMigrationException("Unable to retrieve the list of hibernate data migrations", e);
        }
    }
}

