/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.store.migration.hibernate;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.DeletedAttachment;
import com.xpn.xwiki.doc.XWikiDeletedDocument;
import com.xpn.xwiki.internal.store.hibernate.HibernateStore;
import com.xpn.xwiki.store.DatabaseProduct;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.AbstractHibernateDataMigration;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.hibernate.Session;
import org.hibernate.boot.Metadata;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.query.NativeQuery;
import org.slf4j.Logger;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.version.internal.DefaultVersion;
import org.xwiki.store.hibernate.HibernateAdapter;
import org.xwiki.store.hibernate.HibernateStoreException;
import org.xwiki.store.hibernate.internal.MySQLHibernateAdapter;

public abstract class AbstractResizeMigration
extends AbstractHibernateDataMigration {
    private static final int MAXSIZE_MIN = 720;
    private static final int MAXSIZE_MAX = 768;
    private static final Version MYSQL57 = new DefaultVersion("5.7");
    private static final Version MARIADB102 = new DefaultVersion("10.2");
    @Inject
    private Logger logger;
    @Inject
    private HibernateStore hibernateStore;

    @Override
    public String getDescription() {
        return "Increase the maximum size of all the columns potentially containing a document reference to the maximum index supported by MySQL.";
    }

    @Override
    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(130200001);
    }

    @Override
    protected void hibernateMigrate() throws DataMigrationException, XWikiException {
    }

    private void warnDatabaseTooOld(String databaseName, Version databaseVersion) {
        this.logger.warn("The migration cannot run on {} versions lower than {}. The short String limitation will remain 255.", (Object)databaseName, (Object)databaseVersion);
    }

    @Override
    public boolean shouldExecute(XWikiDBVersion startupVersion) {
        if (this.hibernateStore.getDatabaseProductName() == DatabaseProduct.MYSQL) {
            DatabaseMetaData databaMetadata = this.hibernateStore.getDatabaseMetaData();
            try {
                String productName = databaMetadata.getDatabaseProductName();
                String versionString = databaMetadata.getDatabaseProductVersion();
                DefaultVersion version = new DefaultVersion(versionString);
                if (productName.equalsIgnoreCase("mariadb")) {
                    if (version.compareTo((Object)MARIADB102) < 0) {
                        this.warnDatabaseTooOld("MariaDB", MARIADB102);
                        return false;
                    }
                } else if (version.compareTo((Object)MYSQL57) < 0) {
                    this.warnDatabaseTooOld("MySQL", MYSQL57);
                    return false;
                }
            }
            catch (SQLException e) {
                this.logger.warn("Failed to get database information: {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        } else if (this.hibernateStore.getDatabaseProductName() == DatabaseProduct.MSSQL) {
            this.logger.warn("The migration cannot run on Microsoft SQL Server");
            return false;
        }
        return true;
    }

    private void appendXmlAttribute(String property, String value, StringBuilder stringBuilder) {
        stringBuilder.append(' ');
        stringBuilder.append(property);
        stringBuilder.append("=\"");
        stringBuilder.append(value);
        stringBuilder.append("\" ");
    }

    private void updateColumn(Column column, DatabaseMetaData databaseMetaData, Set<String> dynamicTables, Map<String, String> rowFormats, StringBuilder builder, Session session) throws SQLException, HibernateStoreException {
        Integer databaseSize;
        int expectedLenght = column.getLength();
        if (expectedLenght >= 720 && expectedLenght <= 768 && (databaseSize = this.getDatabaseSize(column, databaseMetaData)) != null && databaseSize < expectedLenght) {
            this.update(column, dynamicTables, rowFormats, builder, session);
        }
    }

    private Integer getDatabaseSize(Column column, DatabaseMetaData databaseMetaData) throws SQLException {
        String databaseName = this.hibernateStore.getAdapter().getDatabaseFromWikiName();
        String tableName = this.hibernateStore.getAdapter().getTableName(column.getValue().getTable());
        String columnName = this.hibernateStore.getConfiguredColumnName(column);
        ResultSet resultSet = this.hibernateStore.getAdapter().isCatalog() ? databaseMetaData.getColumns(databaseName, null, tableName, columnName) : databaseMetaData.getColumns(null, databaseName, tableName, columnName);
        if (resultSet.next()) {
            return resultSet.getInt("COLUMN_SIZE");
        }
        return null;
    }

    private void updateProperty(Property property, DatabaseMetaData databaseMetaData, Set<String> dynamicTables, Map<String, String> rowFormats, StringBuilder builder, Session session) throws SQLException, HibernateStoreException {
        if (property != null) {
            this.updateValue(property.getValue(), databaseMetaData, dynamicTables, rowFormats, builder, session);
        }
    }

    private void updateValue(Value value, DatabaseMetaData databaseMetaData, Set<String> dynamicTables, Map<String, String> rowFormats, StringBuilder builder, Session session) throws SQLException, HibernateStoreException {
        block3: {
            block2: {
                if (!(value instanceof org.hibernate.mapping.Collection)) break block2;
                org.hibernate.mapping.Collection collection = (org.hibernate.mapping.Collection)value;
                Table collectionTable = collection.getCollectionTable();
                Iterator it = collectionTable.getColumnIterator();
                while (it.hasNext()) {
                    this.updateColumn((Column)it.next(), databaseMetaData, dynamicTables, rowFormats, builder, session);
                }
                break block3;
            }
            if (value == null) break block3;
            Iterator it = value.getColumnIterator();
            while (it.hasNext()) {
                Selectable selectable = (Selectable)it.next();
                if (!(selectable instanceof Column)) continue;
                Column column = (Column)selectable;
                this.updateColumn(column, databaseMetaData, dynamicTables, rowFormats, builder, session);
            }
        }
    }

    @Override
    public String getPreHibernateLiquibaseChangeLog() throws DataMigrationException {
        StringBuilder builder = new StringBuilder();
        try (SessionImplementor session = (SessionImplementor)this.hibernateStore.getSessionFactory().openSession();){
            JdbcConnectionAccess jdbcConnectionAccess = session.getJdbcConnectionAccess();
            try (Connection connection = jdbcConnectionAccess.obtainConnection();){
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                Collection bindings = this.hibernateStore.getConfigurationMetadata().getEntityBindings();
                HashSet<String> updatedTables = new HashSet<String>();
                ArrayList<PersistentClass> existingTables = new ArrayList<PersistentClass>(bindings.size());
                for (PersistentClass entity : this.hibernateStore.getConfigurationMetadata().getEntityBindings()) {
                    if (!this.exists(entity, databaseMetaData)) continue;
                    existingTables.add(entity);
                }
                Map<String, String> rowFormats = null;
                MySQLHibernateAdapter adapter = this.getMySQLAdapter();
                if (adapter != null) {
                    rowFormats = adapter.getRowFormats((Session)session);
                    for (PersistentClass entity : existingTables) {
                        this.setTableRowFormat(entity, rowFormats, builder, updatedTables, (Session)session);
                    }
                    this.removeAttachmentRecycleFilenameMultiKey(builder, (Session)session);
                    this.removeRecycleFilenameMultiKey(builder, (Session)session);
                }
                this.updateColumns(existingTables, databaseMetaData, builder, updatedTables, rowFormats, (Session)session);
            }
        }
        catch (Exception e) {
            throw new DataMigrationException("Error while extracting metadata", e);
        }
        if (builder.length() > 0) {
            String script = String.format("<changeSet author=\"xwiki\" id=\"R%s\">%s</changeSet>", this.getVersion().getVersion(), builder.toString());
            this.logger.debug("Liquibase script: {}", (Object)script);
            return script;
        }
        return null;
    }

    private void removeAttachmentRecycleFilenameMultiKey(StringBuilder builder, Session session) {
        PersistentClass persistentClass = this.hibernateStore.getConfigurationMetadata().getEntityBinding(DeletedAttachment.class.getName());
        String tableName = this.hibernateStore.getAdapter().getTableName(persistentClass);
        this.removeFilenameMultiKey(tableName, builder, session);
    }

    private void removeRecycleFilenameMultiKey(StringBuilder builder, Session session) {
        PersistentClass persistentClass = this.hibernateStore.getConfigurationMetadata().getEntityBinding(XWikiDeletedDocument.class.getName());
        String tableName = this.hibernateStore.getAdapter().getTableName(persistentClass);
        this.removeFilenameMultiKey(tableName, builder, session);
    }

    private void removeFilenameMultiKey(String tableName, StringBuilder builder, Session session) {
        String databaseName = this.hibernateStore.getAdapter().getDatabaseFromWikiName();
        for (String key : this.getUniqueKeys(databaseName, tableName, session)) {
            builder.append("<dropUniqueConstraint");
            this.appendXmlAttribute("constraintName", key, builder);
            this.appendXmlAttribute("tableName", tableName, builder);
            builder.append("/>");
        }
    }

    private List<String> getUniqueKeys(String databaseName, String tableName, Session session) {
        NativeQuery query = session.createNativeQuery("SELECT DISTINCT CONSTRAINT_NAME FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE TABLE_SCHEMA = :schema AND TABLE_NAME = :table AND CONSTRAINT_TYPE = 'UNIQUE'");
        query.setParameter("schema", (Object)databaseName);
        query.setParameter("table", (Object)tableName);
        return query.list();
    }

    private void updateColumns(List<PersistentClass> existingTables, DatabaseMetaData databaseMetaData, StringBuilder builder, Set<String> dynamicTables, Map<String, String> rowFormats, Session session) throws SQLException, HibernateStoreException {
        for (PersistentClass entity : existingTables) {
            Iterator it = entity.getPropertyIterator();
            while (it.hasNext()) {
                this.updateProperty((Property)it.next(), databaseMetaData, dynamicTables, rowFormats, builder, session);
            }
            this.updateValue((Value)entity.getKey(), databaseMetaData, dynamicTables, rowFormats, builder, session);
        }
    }

    private MySQLHibernateAdapter getMySQLAdapter() {
        MySQLHibernateAdapter mysqlApater;
        HibernateAdapter adapter = this.hibernateStore.getAdapter();
        return adapter instanceof MySQLHibernateAdapter ? (mysqlApater = (MySQLHibernateAdapter)adapter) : null;
    }

    private void setTableRowFormat(PersistentClass entity, Map<String, String> rowFormats, StringBuilder builder, Set<String> updatedTables, Session session) throws HibernateStoreException {
        String tableName = this.getMySQLAdapter().getTableName(entity);
        boolean compressed = entity.getMetaAttribute("xwiki-compressed") != null;
        this.setTableRowFormat(tableName, compressed, rowFormats, builder, updatedTables, session);
    }

    private void setTableRowFormat(String tableName, boolean compressed, Map<String, String> rowFormats, StringBuilder builder, Set<String> updatedTables, Session session) throws HibernateStoreException {
        MySQLHibernateAdapter adapater = (MySQLHibernateAdapter)this.hibernateStore.getAdapter();
        String statement = adapater.getAlterRowFormatString(tableName, compressed, rowFormats, session);
        if (statement != null) {
            this.logger.debug("Converting raw format for table [{}]", (Object)tableName);
            builder.append("<sql>");
            builder.append(statement);
            builder.append("</sql>");
            updatedTables.add(tableName);
        }
    }

    private boolean exists(PersistentClass entity, DatabaseMetaData databaseMetaData) throws SQLException {
        String databaseName = this.hibernateStore.getAdapter().getDatabaseFromWikiName();
        String tableName = this.hibernateStore.getAdapter().getTableName(entity);
        ResultSet resultSet = this.hibernateStore.getAdapter().isCatalog() ? databaseMetaData.getTables(databaseName, null, tableName, null) : databaseMetaData.getTables(null, databaseName, tableName, null);
        return resultSet.next();
    }

    private void update(Column column, Set<String> dynamicTables, Map<String, String> rowFormats, StringBuilder builder, Session session) throws HibernateStoreException {
        MySQLHibernateAdapter mysqlAdapater = this.getMySQLAdapter();
        if (mysqlAdapater != null) {
            JdbcEnvironment jdbcEnvironment = this.hibernateStore.getConfigurationMetadata().getDatabase().getJdbcEnvironment();
            String tableName = jdbcEnvironment.getQualifiedObjectNameFormatter().format(column.getValue().getTable().getQualifiedTableName(), this.hibernateStore.getDialect());
            String quotedColumn = column.getQuotedName(this.hibernateStore.getDialect());
            this.logger.debug("Updating column [{}] in table [{}]", (Object)quotedColumn, (Object)tableName);
            this.setTableRowFormat(tableName, false, rowFormats, builder, dynamicTables, session);
            builder.append("<sql>");
            builder.append(this.hibernateStore.getDialect().getAlterTableString(tableName));
            builder.append(" MODIFY ");
            builder.append(quotedColumn);
            builder.append(' ');
            builder.append(this.getDataType(column, this.hibernateStore.getConfigurationMetadata()));
            builder.append("</sql>");
        } else {
            builder.append("<modifyDataType");
            this.appendXmlAttribute("tableName", this.hibernateStore.getAdapter().getTableName(column.getValue().getTable()), builder);
            this.appendXmlAttribute("columnName", this.hibernateStore.getConfiguredColumnName(column), builder);
            this.appendXmlAttribute("newDataType", column.getSqlType(this.hibernateStore.getDialect(), (Mapping)this.hibernateStore.getConfigurationMetadata()), builder);
            builder.append("/>");
        }
    }

    private String getDataType(Column column, Metadata configurationMetadata) {
        Dialect dialect = this.hibernateStore.getDialect();
        StringBuilder builder = new StringBuilder(column.getSqlType(dialect, (Mapping)configurationMetadata));
        if (column.isNullable()) {
            builder.append(dialect.getNullColumnString());
        } else {
            builder.append(" not null");
        }
        return builder.toString();
    }
}

