/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.store.migration.hibernate;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.store.XWikiHibernateBaseStore;
import com.xpn.xwiki.store.XWikiStoreInterface;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.DataMigrationManager;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.HibernateDataMigration;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;

public abstract class AbstractHibernateDataMigration
implements HibernateDataMigration {
    @Inject
    protected ComponentManager componentManager;
    @Inject
    @Named(value="hibernate")
    protected Provider<DataMigrationManager> manager;
    @Inject
    private Execution execution;

    protected XWikiContext getXWikiContext() {
        ExecutionContext context = this.execution.getContext();
        return (XWikiContext)context.getProperty("xwikicontext");
    }

    protected XWikiHibernateBaseStore getStore() throws DataMigrationException {
        try {
            return (XWikiHibernateBaseStore)this.componentManager.getInstance(XWikiStoreInterface.class, "hibernate");
        }
        catch (ComponentLookupException e) {
            throw new DataMigrationException(String.format("Unable to reach the store for database %s", this.getXWikiContext().getWikiId()), e);
        }
    }

    @Override
    public String getName() {
        String hint = null;
        Named named = this.getClass().getAnnotation(Named.class);
        if (named != null) {
            hint = named.value();
        }
        return hint;
    }

    @Override
    public boolean shouldExecute(XWikiDBVersion startupVersion) {
        return true;
    }

    protected abstract void hibernateMigrate() throws DataMigrationException, XWikiException;

    @Override
    public void migrate() throws DataMigrationException {
        try {
            this.hibernateMigrate();
        }
        catch (Exception e) {
            throw new DataMigrationException(String.format("Data migration %s failed", this.getName()), e);
        }
    }

    @Override
    public String getPreHibernateLiquibaseChangeLog() throws DataMigrationException {
        return null;
    }

    @Override
    public String getLiquibaseChangeLog() throws DataMigrationException {
        return null;
    }

    protected XWikiDBVersion getCurrentDBVersion() throws DataMigrationException {
        return ((DataMigrationManager)this.manager.get()).getDBVersion();
    }
}

