/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.store.migration.hibernate;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.store.XWikiHibernateBaseStore;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.hibernate.AbstractHibernateDataMigration;
import org.hibernate.boot.Metadata;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PersistentClass;

public abstract class AbstractDropNotNullDataMigration
extends AbstractHibernateDataMigration {
    private Class<?> table;
    private String property;

    public AbstractDropNotNullDataMigration(Class<?> table, String property) {
        this.table = table;
        this.property = property;
    }

    @Override
    public String getLiquibaseChangeLog() throws DataMigrationException {
        XWikiHibernateBaseStore store = this.getStore();
        Dialect dialect = store.getDialect();
        Metadata metadata = store.getMetadata();
        PersistentClass pClass = metadata.getEntityBinding(this.table.getName());
        Column column = (Column)pClass.getProperty(this.property).getColumnIterator().next();
        String columnType = column.getSqlType(dialect, (Mapping)metadata);
        StringBuilder builder = new StringBuilder();
        builder.append("<changeSet author=\"xwiki\" id=\"R").append(this.getVersion().getVersion()).append("\">\n");
        builder.append("    <dropNotNullConstraint\n");
        builder.append("            columnDataType=\"").append(columnType).append('\"').append('\n');
        builder.append("            columnName=\"").append(column.getName()).append('\"').append('\n');
        builder.append("            tableName=\"").append(pClass.getTable().getName()).append("\"/>\n");
        builder.append("</changeSet>");
        return builder.toString();
    }

    @Override
    protected void hibernateMigrate() throws DataMigrationException, XWikiException {
    }
}

