/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.store.migration;

import com.xpn.xwiki.XWikiConfig;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.internal.store.hibernate.HibernateConfiguration;
import com.xpn.xwiki.store.migration.DataMigration;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.DataMigrationManager;
import com.xpn.xwiki.store.migration.DataMigrationStatus;
import com.xpn.xwiki.store.migration.MigrationRequiredException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.HibernateDataMigration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.xwiki.bridge.event.WikiDeletedEvent;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.job.event.status.JobProgressManager;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;

public abstract class AbstractDataMigrationManager
implements DataMigrationManager,
Initializable {
    @Inject
    protected ComponentManager componentManager;
    @Inject
    protected ObservationManager observationManager;
    @Inject
    protected JobProgressManager progress;
    @Inject
    protected HibernateConfiguration hibernateConfiguration;
    protected Collection<XWikiMigration> migrations;
    @Inject
    protected Logger logger;
    @Inject
    private Execution execution;
    private final ThreadLock lock = new ThreadLock();
    private final Map<String, MigrationStatus> statusCache = new HashMap<String, MigrationStatus>();
    private XWikiDBVersion targetVersion;

    protected XWikiContext getXWikiContext() {
        ExecutionContext context = this.execution.getContext();
        return (XWikiContext)context.getProperty("xwikicontext");
    }

    @Deprecated
    protected XWikiConfig getXWikiConfig() {
        return this.getXWikiContext().getWiki().getConfig();
    }

    @Deprecated
    protected boolean isVirtualMode() {
        return true;
    }

    @Deprecated
    protected List<String> getVirtualWikisDatabaseNames() throws DataMigrationException {
        try {
            return this.getXWikiContext().getWiki().getVirtualWikisDatabaseNames(this.getXWikiContext());
        }
        catch (XWikiException e) {
            throw new DataMigrationException("Unable to retrieve the list of wiki names", e);
        }
    }

    protected String getMainXWiki() {
        return this.getXWikiContext().getMainXWiki();
    }

    public void initialize() throws InitializationException {
        this.checkMigrationsVersions();
        try {
            TreeMap<XWikiDBVersion, XWikiMigration> availableMigrations = new TreeMap<XWikiDBVersion, XWikiMigration>();
            Map<XWikiDBVersion, XWikiMigration> forcedMigrations = this.getForcedMigrations();
            if (!forcedMigrations.isEmpty()) {
                availableMigrations.putAll(forcedMigrations);
            } else {
                HashSet<String> ignoredMigrations = new HashSet<String>(this.hibernateConfiguration.getIgnoredMigrations());
                for (DataMigration dataMigration : this.getAllMigrations()) {
                    XWikiDBVersion migratorVersion = dataMigration.getVersion();
                    if (this.isMigrationIgnored(dataMigration, ignoredMigrations)) continue;
                    XWikiMigration migration = new XWikiMigration(dataMigration, false);
                    availableMigrations.put(migratorVersion, migration);
                }
            }
            this.targetVersion = !availableMigrations.isEmpty() ? (XWikiDBVersion)availableMigrations.lastKey() : new XWikiDBVersion(0);
            this.migrations = availableMigrations.values();
        }
        catch (Exception e) {
            throw new InitializationException("Migration Manager initialization failed", (Throwable)e);
        }
        this.observationManager.addListener((EventListener)new WikiDeletedEventListener());
    }

    public boolean isMigrationIgnored(DataMigration migration, Set<String> ignoredMigrations) {
        return ignoredMigrations.contains(migration.getClass().getName()) || ignoredMigrations.contains(migration.getVersion().toString());
    }

    private void checkMigrationsVersions() throws InitializationException {
        try {
            List migrationList = this.componentManager.getInstanceList(HibernateDataMigration.class);
            HashSet<String> ignoredMigrations = new HashSet<String>(this.hibernateConfiguration.getIgnoredMigrations());
            HashMap<XWikiDBVersion, String> hintMap = new HashMap<XWikiDBVersion, String>();
            for (HibernateDataMigration dataMigration : migrationList) {
                XWikiDBVersion version = dataMigration.getVersion();
                if (hintMap.containsKey(version)) {
                    if (this.isMigrationIgnored(dataMigration, ignoredMigrations)) {
                        this.logger.warn("Two migrations with same version [{}] were found: [{}] and [{}] but migration [{}] is ignored.", new Object[]{version, hintMap.get(version), dataMigration.getClass().getName(), dataMigration.getClass().getName()});
                    } else {
                        throw new InitializationException(String.format("Two migrations with same version [%s] were found: [%s] and [%s]", version, hintMap.get(version), dataMigration.getClass().getName()));
                    }
                }
                hintMap.put(version, dataMigration.getClass().getName());
            }
        }
        catch (ComponentLookupException e) {
            throw new InitializationException("Unable to retrieve the list of hibernate data migrations", (Throwable)e);
        }
    }

    protected XWikiDBVersion getDBVersionFromConfig() {
        String ver = this.hibernateConfiguration.getMigrationVersion();
        return ver == null ? null : new XWikiDBVersion(Integer.parseInt(ver));
    }

    protected XWikiDBVersion getDBVersionFromDatabase() throws DataMigrationException {
        return this.getDBVersionFromConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final XWikiDBVersion getDBVersion() throws DataMigrationException {
        this.lock.lock();
        try {
            String wikiName = this.getXWikiContext().getWikiId();
            MigrationStatus dbStatus = this.statusCache.get(wikiName);
            if (dbStatus == null) {
                Map<String, MigrationStatus> map = this.statusCache;
                synchronized (map) {
                    XWikiDBVersion version = this.getDBVersionFromDatabase();
                    if (version != null) {
                        this.statusCache.put(wikiName, new MigrationStatus(version));
                    }
                    XWikiDBVersion xWikiDBVersion = version;
                    return xWikiDBVersion;
                }
            }
            XWikiDBVersion xWikiDBVersion = dbStatus.getDBVersion();
            return xWikiDBVersion;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataMigrationStatus getDataMigrationStatus() throws DataMigrationException {
        this.lock.lock();
        try {
            Object object;
            String wikiName = this.getXWikiContext().getWikiId();
            MigrationStatus dbStatus = this.statusCache.get(wikiName);
            if (dbStatus == null) {
                object = this.statusCache;
                synchronized (object) {
                    XWikiDBVersion version = this.getDBVersionFromDatabase();
                    if (version != null) {
                        dbStatus = new MigrationStatus(version);
                        this.statusCache.put(wikiName, dbStatus);
                    }
                }
            }
            object = dbStatus;
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public final XWikiDBVersion getLatestVersion() {
        return this.targetVersion;
    }

    @Override
    public synchronized void initNewDB() throws DataMigrationException {
        this.lock.lock();
        try {
            this.initializeEmptyDB();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected abstract void initializeEmptyDB() throws DataMigrationException;

    protected abstract void setDBVersionToDatabase(XWikiDBVersion var1) throws DataMigrationException;

    protected final void setDBVersion(XWikiDBVersion version) throws DataMigrationException {
        this.updateMigrationStatus(version, false, null);
    }

    private void updateMigrationStatus(XWikiDBVersion version) throws DataMigrationException {
        this.updateMigrationStatus(version, true, null);
    }

    private void updateMigrationStatus(XWikiDBVersion version, Exception e) throws DataMigrationException {
        this.updateMigrationStatus(version, true, e);
    }

    private synchronized void updateMigrationStatus(XWikiDBVersion version, boolean migrationAttempted, Exception e) throws DataMigrationException {
        String wikiName = this.getXWikiContext().getWikiId();
        if (!migrationAttempted || e == null) {
            this.setDBVersionToDatabase(version);
        }
        if (version != null) {
            this.statusCache.put(wikiName, migrationAttempted ? new MigrationStatus(version, e) : new MigrationStatus(version));
        }
    }

    protected abstract void updateSchema(Collection<XWikiMigration> var1) throws DataMigrationException;

    @Override
    public void checkDatabase() throws MigrationRequiredException, DataMigrationException {
        if (!this.lock.tryLock()) {
            return;
        }
        try {
            if (this.getDatabaseStatus() == null) {
                this.initializeCurrentDatabase();
            }
            if (this.migrations != null) {
                this.tryToProcceedToMigration();
            }
            this.preventAccessToOutdatedDb();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void initializeCurrentDatabase() throws DataMigrationException {
        try {
            this.initNewDB();
        }
        catch (DataMigrationException e) {
            String message = String.format("The empty database %s seems to be not writable, please check your configuration!", this.getXWikiContext().getWikiId());
            this.logger.error(message, (Throwable)e);
            throw new DataMigrationException(message, e);
        }
    }

    private DataMigrationStatus getDatabaseStatus() throws DataMigrationException {
        DataMigrationStatus status;
        try {
            status = this.getDataMigrationStatus();
        }
        catch (DataMigrationException e) {
            String message = String.format("Database %s seems to be inaccessible, please check your configuration!", this.getXWikiContext().getWikiId());
            this.logger.error(message, (Throwable)e);
            throw new DataMigrationException(message, e);
        }
        return status;
    }

    private void preventAccessToOutdatedDb() throws DataMigrationException, MigrationRequiredException {
        DataMigrationStatus status = this.getDataMigrationStatus();
        if (this.getLatestVersion().compareTo(status.getDBVersion()) > 0) {
            if (status.hasDataMigrationBeenAttempted() && !status.hasBeenSuccessfullyMigrated()) {
                String message = String.format("Migration of database [%s] has failed, it could not be safely used! Database is currently in version [%d] while the required version is [%d].", this.getXWikiContext().getWikiId(), status.getDBVersion().getVersion(), this.getLatestVersion().getVersion());
                throw new DataMigrationException(message, status.getLastMigrationException());
            }
            String message = String.format("Since database [%s] needs to be migrated, it couldn't be safely used! Please check your configuration to enable required migration for upgrading database from version [%d] to version [%d].", this.getXWikiContext().getWikiId(), status.getDBVersion().getVersion(), this.getLatestVersion().getVersion());
            throw new MigrationRequiredException(message);
        }
    }

    private void tryToProcceedToMigration() throws DataMigrationException {
        if (this.hibernateConfiguration.isMigrationEnabled()) {
            this.logger.info("Storage schema updates and data migrations are enabled");
            this.startMigrationsOnlyOnce();
            if (this.hibernateConfiguration.isExitAfterMigration()) {
                this.logger.error("Exiting because xwiki.store.migration.exitAfterEnd is set");
                System.exit(0);
            }
        }
    }

    private synchronized void startMigrationsOnlyOnce() throws DataMigrationException {
        if (this.migrations == null) {
            return;
        }
        try {
            this.startMigrations();
        }
        finally {
            this.migrations = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startMigrations() throws DataMigrationException {
        Set<String> databasesToMigrate = this.getDatabasesToMigrate();
        this.progress.pushLevelProgress(databasesToMigrate.size(), (Object)this);
        try {
            if (!this.migrateDatabase(this.getMainXWiki())) {
                String message = "Main wiki database migration failed, it is not safe to continue!";
                this.logger.error(message);
                throw new DataMigrationException(message);
            }
            int errorCount = 0;
            for (String database : databasesToMigrate) {
                this.progress.startStep((Object)this);
                if (!this.migrateDatabase(database)) {
                    ++errorCount;
                }
                this.progress.endStep((Object)this);
            }
            if (errorCount > 0) {
                String message = String.format("%s wiki database migration(s) failed.", errorCount);
                this.logger.error(message);
                throw new DataMigrationException(message);
            }
        }
        finally {
            this.progress.popLevelProgress((Object)this);
        }
    }

    private Set<String> getDatabasesToMigrate() throws DataMigrationException {
        HashSet<String> databasesToMigrate = new HashSet<String>();
        List<String> databases = this.hibernateConfiguration.getMigrationDatabases();
        if (databases.isEmpty() || databases.size() == 1 && databases.get(0).equals("all")) {
            List<String> allwikis = this.getVirtualWikisDatabaseNames();
            databasesToMigrate.addAll(allwikis);
        } else {
            databasesToMigrate.addAll(databases);
        }
        databasesToMigrate.remove(this.getMainXWiki());
        return databasesToMigrate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean migrateDatabase(String database) {
        XWikiContext context = this.getXWikiContext();
        String currentDatabase = context.getWikiId();
        String currentOriginalDatabase = context.getOriginalWikiId();
        try {
            context.setWikiId(database);
            context.setOriginalWikiId(database);
            Collection<XWikiMigration> neededMigrations = this.getNeededMigrations();
            this.updateSchema(neededMigrations);
            this.startMigrations(neededMigrations);
        }
        catch (Exception e) {
            try {
                this.updateMigrationStatus(this.getDBVersion(), e);
            }
            catch (DataMigrationException dataMigrationException) {
                // empty catch block
            }
            String message = String.format("Failed to migrate database [%s]...", database);
            this.logger.error(message, (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            context.setWikiId(currentDatabase);
            context.setOriginalWikiId(currentOriginalDatabase);
        }
        return true;
    }

    protected Collection<XWikiMigration> getNeededMigrations() throws DataMigrationException {
        XWikiDBVersion curversion = this.getDBVersion();
        ArrayList<XWikiMigration> neededMigrations = new ArrayList<XWikiMigration>();
        for (XWikiMigration migration : this.migrations) {
            if (!migration.isForced && (migration.dataMigration.getVersion().compareTo(curversion) <= 0 || !migration.dataMigration.shouldExecute(curversion))) continue;
            neededMigrations.add(migration);
        }
        if (this.logger.isInfoEnabled()) {
            this.logNeededMigrationReport(curversion, neededMigrations);
        }
        return neededMigrations;
    }

    private void logNeededMigrationReport(XWikiDBVersion curversion, Collection<XWikiMigration> neededMigrations) {
        String database = this.getXWikiContext().getWikiId();
        if (!neededMigrations.isEmpty()) {
            this.logger.info("The following data migration(s) will be applied for wiki [{}] currently in version [{}]:", (Object)database, (Object)curversion);
            for (XWikiMigration migration : neededMigrations) {
                this.logger.info("  {} - {}{}", new Object[]{migration.dataMigration.getName(), migration.dataMigration.getDescription(), migration.isForced ? " (forced)" : ""});
            }
        } else if (curversion != null) {
            this.logger.info("No data migration to apply for wiki [{}] currently in version [{}]", (Object)database, (Object)curversion);
        } else {
            this.logger.info("No data migration to apply for empty wiki [{}]", (Object)database);
        }
    }

    protected Map<XWikiDBVersion, XWikiMigration> getForcedMigrations() throws DataMigrationException {
        TreeMap<XWikiDBVersion, XWikiMigration> forcedMigrations = new TreeMap<XWikiDBVersion, XWikiMigration>();
        for (String hint : this.hibernateConfiguration.getForcedMigrations()) {
            try {
                DataMigration dataMigration = (DataMigration)this.componentManager.getInstance(DataMigration.class, hint);
                forcedMigrations.put(dataMigration.getVersion(), new XWikiMigration(dataMigration, true));
            }
            catch (ComponentLookupException e) {
                throw new DataMigrationException("Forced dataMigration " + hint + " component could not be found", e);
            }
        }
        return forcedMigrations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startMigrations(Collection<XWikiMigration> migrations) throws DataMigrationException {
        XWikiDBVersion curversion = this.getDBVersion();
        String database = null;
        if (this.logger.isInfoEnabled()) {
            database = this.getXWikiContext().getWikiId();
        }
        this.progress.pushLevelProgress(migrations.size(), (Object)this);
        try {
            for (XWikiMigration migration : migrations) {
                this.progress.startStep((Object)this);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Starting data migration [{}] with version [{}] on database [{}]", new Object[]{migration.dataMigration.getName(), migration.dataMigration.getVersion(), database});
                }
                migration.dataMigration.migrate();
                if (migration.dataMigration.getVersion().compareTo(curversion) > 0) {
                    curversion = migration.dataMigration.getVersion();
                    this.updateMigrationStatus(curversion);
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Data migration [{}] applied successfully, database [{}] upgraded to version [{}]", new Object[]{migration.dataMigration.getName(), database, this.getDBVersion()});
                    }
                } else if (this.logger.isInfoEnabled()) {
                    this.logger.info("Data migration [{}] applied successfully, database [{}] stay in version [{}]", new Object[]{migration.dataMigration.getName(), database, this.getDBVersion()});
                }
                this.progress.endStep((Object)this);
            }
        }
        finally {
            this.progress.popLevelProgress((Object)this);
        }
        this.setDatabaseToLastestVersion(curversion);
    }

    private void setDatabaseToLastestVersion(XWikiDBVersion currentVersion) throws DataMigrationException {
        if (currentVersion == null) {
            this.setDBVersion(this.getLatestVersion());
        } else if (this.getLatestVersion().compareTo(currentVersion) > 0) {
            this.updateMigrationStatus(this.getLatestVersion());
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Database [{}] upgraded to latest version [{}] without needing{} data migration", new Object[]{this.getXWikiContext().getWikiId(), this.getDBVersion(), this.migrations.size() > 0 ? " further" : ""});
            }
        }
    }

    protected abstract List<? extends DataMigration> getAllMigrations() throws DataMigrationException;

    private static final class ThreadLock
    extends ThreadLocal<Integer> {
        private ThreadLock() {
        }

        @Override
        protected Integer initialValue() {
            return 0;
        }

        public void unlock() {
            int i = (Integer)this.get();
            if (i > 0) {
                this.set(--i);
            }
        }

        public void lock() {
            this.set((Integer)this.get() + 1);
        }

        public boolean tryLock() {
            int i = (Integer)this.get();
            if (i > 0) {
                return false;
            }
            this.set(++i);
            return true;
        }
    }

    protected class XWikiMigration {
        public boolean isForced;
        public DataMigration dataMigration;

        public XWikiMigration(DataMigration dataMigration, boolean isForced) {
            this.dataMigration = dataMigration;
            this.isForced = isForced;
        }
    }

    private final class WikiDeletedEventListener
    implements EventListener {
        private WikiDeletedEventListener() {
        }

        public String getName() {
            return "dbversioncache";
        }

        public List<Event> getEvents() {
            return Arrays.asList(new WikiDeletedEvent());
        }

        public void onEvent(Event event, Object source, Object data) {
            AbstractDataMigrationManager.this.statusCache.remove(((WikiDeletedEvent)event).getWikiId());
        }
    }

    private static class MigrationStatus
    implements DataMigrationStatus {
        private XWikiDBVersion version;
        private Exception migrationException;
        private boolean migrationAttempted;

        public MigrationStatus(XWikiDBVersion version) {
            this.version = version;
            this.migrationAttempted = false;
        }

        public MigrationStatus(XWikiDBVersion version, Exception migrationException) {
            this.version = version;
            this.migrationAttempted = true;
            this.migrationException = migrationException;
        }

        @Override
        public XWikiDBVersion getDBVersion() {
            return this.version;
        }

        @Override
        public boolean hasDataMigrationBeenAttempted() {
            return this.migrationAttempted;
        }

        @Override
        public boolean hasBeenSuccessfullyMigrated() {
            return this.migrationAttempted && this.migrationException == null;
        }

        @Override
        public Exception getLastMigrationException() {
            return this.migrationException;
        }
    }
}

