/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.store.hibernate.query;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.internal.store.hibernate.HibernateStore;
import com.xpn.xwiki.internal.store.hibernate.query.HqlQueryUtils;
import com.xpn.xwiki.store.XWikiHibernateStore;
import com.xpn.xwiki.util.Util;
import com.xpn.xwiki.web.Utils;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.hibernate.Session;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.NamedQueryDefinition;
import org.hibernate.engine.spi.NamedSQLQueryDefinition;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.context.Execution;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryExecutor;
import org.xwiki.query.QueryFilter;
import org.xwiki.query.QueryParameter;
import org.xwiki.query.SecureQuery;
import org.xwiki.query.WrappingQuery;
import org.xwiki.query.hql.internal.HQLStatementValidator;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="hql")
@Singleton
public class HqlQueryExecutor
implements QueryExecutor,
Initializable {
    private static final String MAPPING_PATH = "queries.hbm.xml";
    private static final String ESCAPE_LIKE_PARAMETERS_FILTER = "escapeLikeParameters";
    @Inject
    private HibernateStore hibernate;
    @Inject
    private Execution execution;
    @Inject
    private ContextualAuthorizationManager authorization;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    private HQLStatementValidator queryValidator;
    @Inject
    private Logger logger;
    private volatile Set<String> safeNamedQueries;

    public void initialize() throws InitializationException {
        Configuration configuration = this.hibernate.getConfiguration();
        configuration.addInputStream(Util.getResourceAsStream(MAPPING_PATH));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getSafeNamedQueries() {
        if (this.safeNamedQueries == null) {
            HqlQueryExecutor hqlQueryExecutor = this;
            synchronized (hqlQueryExecutor) {
                if (this.safeNamedQueries == null) {
                    HashSet<String> safeQueries = new HashSet<String>();
                    Collection namedQueries = this.hibernate.getConfigurationMetadata().getNamedQueryDefinitions();
                    for (NamedQueryDefinition definition : namedQueries) {
                        try {
                            if (!this.queryValidator.isSafe(definition.getQuery())) continue;
                            safeQueries.add(definition.getName());
                        }
                        catch (QueryException e) {
                            this.logger.warn("Failed to validate named query [{}] with statement [{}]: {}", new Object[]{definition.getName(), definition.getQuery(), ExceptionUtils.getRootCauseMessage((Throwable)e)});
                        }
                    }
                    this.safeNamedQueries = safeQueries;
                }
            }
        }
        return this.safeNamedQueries;
    }

    @Deprecated(since="17.0.0RC1, 16.10.2, 15.10.16, 16.4.6")
    protected static boolean isSafeSelect(String statement) {
        HQLStatementValidator validator = Utils.getComponent(HQLStatementValidator.class);
        try {
            return validator.isSafe(statement);
        }
        catch (QueryException e) {
            return false;
        }
    }

    protected void checkAllowed(org.xwiki.query.Query query) throws QueryException {
        if (query instanceof SecureQuery) {
            this.checkAllowed((SecureQuery)query);
        }
    }

    private void checkAllowed(SecureQuery secureQuery) throws QueryException {
        if (secureQuery.isCurrentAuthorChecked() && !this.authorization.hasAccess(Right.PROGRAM)) {
            if (secureQuery.isNamed() && !this.getSafeNamedQueries().contains(secureQuery.getStatement())) {
                throw new QueryException("Named queries requires programming right", (org.xwiki.query.Query)secureQuery, null);
            }
            if (!this.queryValidator.isSafe(secureQuery.getStatement())) {
                throw new QueryException("The query requires programming right", (org.xwiki.query.Query)secureQuery, null);
            }
        }
    }

    public <T> List<T> execute(org.xwiki.query.Query query) throws QueryException {
        String oldDatabase = this.getContext().getWikiId();
        try {
            if (query.getWiki() != null) {
                this.getContext().setWikiId(query.getWiki());
            }
            this.checkAllowed(query);
            org.xwiki.query.Query filteredQuery = this.filterQuery(query);
            List results = this.getStore().executeRead(this.getContext(), session -> {
                Query hquery = this.createQuery(session, filteredQuery);
                return hquery.list();
            });
            if (query.getFilters() != null && !query.getFilters().isEmpty()) {
                for (QueryFilter filter : query.getFilters()) {
                    results = filter.filterResults(results);
                }
            }
            List list = results;
            return list;
        }
        catch (Exception e) {
            throw new QueryException("Exception while executing query", query, (Throwable)e);
        }
        finally {
            this.getContext().setWikiId(oldDatabase);
        }
    }

    protected org.xwiki.query.Query filterQuery(org.xwiki.query.Query query) {
        org.xwiki.query.Query filteredQuery = query;
        if (!filteredQuery.isNamed()) {
            filteredQuery = HqlQueryUtils.toCompleteQuery(filteredQuery);
            filteredQuery = this.filterQuery(filteredQuery, "hql");
        }
        return filteredQuery;
    }

    protected <T> Query<T> createQuery(Session session, org.xwiki.query.Query query) {
        Query<T> hquery;
        if (!query.isNamed()) {
            hquery = session.createQuery(query.getStatement());
            this.populateParameters(hquery, query);
        } else {
            hquery = this.createNamedHibernateQuery(session, query);
        }
        return hquery;
    }

    @Deprecated(since="13.10.6")
    protected <T> Query<T> createHibernateQuery(Session session, org.xwiki.query.Query query) {
        return this.createQuery(session, this.filterQuery(query));
    }

    private org.xwiki.query.Query filterQuery(org.xwiki.query.Query query, String language) {
        Object filteredQuery = query;
        this.addEscapeLikeParametersFilter(query);
        if (query.getFilters() != null && !query.getFilters().isEmpty()) {
            for (QueryFilter filter : query.getFilters()) {
                final String filteredStatement = filter.filterStatement(filteredQuery.getStatement(), language);
                if (!filteredStatement.equals(filteredQuery.getStatement())) {
                    filteredQuery = new WrappingQuery((org.xwiki.query.Query)filteredQuery){

                        public String getStatement() {
                            return filteredStatement;
                        }
                    };
                }
                filteredQuery = filter.filterQuery(filteredQuery);
            }
        }
        return filteredQuery;
    }

    private void addEscapeLikeParametersFilter(org.xwiki.query.Query query) {
        QueryFilter escapeFilter;
        if (!this.hasQueryParametersType(query)) {
            return;
        }
        try {
            escapeFilter = (QueryFilter)((ComponentManager)this.componentManagerProvider.get()).getInstance(QueryFilter.class, ESCAPE_LIKE_PARAMETERS_FILTER);
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException(String.format("Failed to locate [%s] Query Filter", ESCAPE_LIKE_PARAMETERS_FILTER), e);
        }
        boolean found = false;
        for (QueryFilter filter : query.getFilters()) {
            if (escapeFilter.getClass() != filter.getClass()) continue;
            found = true;
            break;
        }
        if (!found) {
            query.addFilter(escapeFilter);
        }
    }

    private boolean hasQueryParametersType(org.xwiki.query.Query query) {
        boolean found = false;
        for (Object value : query.getNamedParameters().values()) {
            if (!(value instanceof QueryParameter)) continue;
            found = true;
            break;
        }
        if (!found) {
            for (Object value : query.getPositionalParameters().values()) {
                if (!(value instanceof QueryParameter)) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    protected String completeShortFormStatement(String statement) {
        return HqlQueryUtils.toCompleteStatement(statement);
    }

    private <T> Query<T> createNamedHibernateQuery(Session session, org.xwiki.query.Query query) {
        Query hQuery = session.getNamedQuery(query.getStatement());
        org.xwiki.query.Query filteredQuery = query;
        if (filteredQuery.getFilters() != null && !filteredQuery.getFilters().isEmpty()) {
            boolean isNative = hQuery instanceof NativeQuery;
            String language = isNative ? "sql" : "hql";
            final String statement = hQuery.getQueryString();
            filteredQuery = this.filterQuery((org.xwiki.query.Query)new WrappingQuery(filteredQuery){

                public String getStatement() {
                    return statement;
                }
            }, language);
            if (isNative) {
                hQuery = session.createSQLQuery(filteredQuery.getStatement());
                NamedSQLQueryDefinition definition = this.hibernate.getConfigurationMetadata().getNamedNativeQueryDefinition(query.getStatement());
                if (!StringUtils.isEmpty((CharSequence)definition.getResultSetRef())) {
                    ((NativeQuery)hQuery).setResultSetMapping(definition.getResultSetRef());
                }
            } else {
                hQuery = session.createQuery(filteredQuery.getStatement());
            }
        }
        this.populateParameters(hQuery, filteredQuery);
        return hQuery;
    }

    protected void populateParameters(Query<?> hquery, org.xwiki.query.Query query) {
        if (query.getOffset() > 0) {
            hquery.setFirstResult(query.getOffset());
        }
        if (query.getLimit() > 0) {
            hquery.setMaxResults(query.getLimit());
        }
        for (Map.Entry e : query.getNamedParameters().entrySet()) {
            this.setNamedParameter(hquery, (String)e.getKey(), e.getValue());
        }
        Map positionalParameters = query.getPositionalParameters();
        if (positionalParameters.size() > 0) {
            positionalParameters.forEach((arg_0, arg_1) -> hquery.setParameter(arg_0, arg_1));
        }
    }

    protected void setNamedParameter(Query<?> query, String name, Object value) {
        if (value instanceof Collection) {
            query.setParameterList(name, (Collection)value);
        } else if (value.getClass().isArray()) {
            query.setParameterList(name, (Object[])value);
        } else {
            query.setParameter(name, value);
        }
    }

    protected XWikiHibernateStore getStore() {
        return this.getContext().getWiki().getHibernateStore();
    }

    protected XWikiContext getContext() {
        return (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
    }
}

