/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.store.hibernate;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.DeletedAttachment;
import com.xpn.xwiki.doc.DeletedAttachmentContent;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.store.StoreConfiguration;
import com.xpn.xwiki.internal.store.hibernate.HibernateDeletedAttachmentContent;
import com.xpn.xwiki.store.AttachmentRecycleBinContentStore;
import com.xpn.xwiki.store.AttachmentRecycleBinStore;
import com.xpn.xwiki.store.XWikiHibernateBaseStore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.reference.AttachmentReference;

@Component
@Named(value="hibernate")
@Singleton
public class HibernateAttachmentRecycleBinStore
extends XWikiHibernateBaseStore
implements AttachmentRecycleBinStore {
    private static final String DOC_ID = "docId";
    private static final String DATE = "date";
    @Inject
    private StoreConfiguration storeConfiguration;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Logger logger;

    @Deprecated
    public HibernateAttachmentRecycleBinStore(XWikiContext context) {
        super(context.getWiki(), context);
    }

    public HibernateAttachmentRecycleBinStore() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveToRecycleBin(final XWikiAttachment attachment, final String deleter, final Date date, XWikiContext inputxcontext, final boolean bTransaction) throws XWikiException {
        XWikiContext context = this.getExecutionXContext(inputxcontext, true);
        try {
            this.executeWrite(context, new XWikiHibernateBaseStore.HibernateCallback<Object>(){

                @Override
                public Object doInHibernate(Session session) throws XWikiException {
                    AttachmentRecycleBinContentStore contentStore = HibernateAttachmentRecycleBinStore.this.getDefaultAttachmentRecycleBinContentStore();
                    DeletedAttachment trashAttachment = HibernateAttachmentRecycleBinStore.this.createDeletedAttachment(attachment, deleter, date, contentStore);
                    long index = ((Number)session.save((Object)trashAttachment)).longValue();
                    if (contentStore != null) {
                        contentStore.save(attachment, date, index, bTransaction);
                    }
                    return null;
                }
            });
        }
        finally {
            this.restoreExecutionXContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XWikiAttachment restoreFromRecycleBin(XWikiAttachment attachment, long index, XWikiContext inputxcontext, boolean bTransaction) throws XWikiException {
        XWikiContext context = this.getExecutionXContext(inputxcontext, true);
        try {
            DeletedAttachment deletedAttachment = this.getDeletedAttachment(index, context, bTransaction);
            XWikiAttachment xWikiAttachment = deletedAttachment == null ? null : deletedAttachment.restoreAttachment();
            return xWikiAttachment;
        }
        finally {
            this.restoreExecutionXContext();
        }
    }

    @Override
    public DeletedAttachment getDeletedAttachment(long index, XWikiContext context, boolean bTransaction) throws XWikiException {
        return this.loadDeletedAttachment(index, context, true);
    }

    private DeletedAttachment loadDeletedAttachment(long index, XWikiContext context, boolean resolve) throws XWikiException {
        return this.executeRead(context, session -> {
            DeletedAttachment deletedAttachment = (DeletedAttachment)session.get(DeletedAttachment.class, (Serializable)Long.valueOf(index));
            if (deletedAttachment != null && resolve) {
                deletedAttachment = this.resolveDeletedAttachmentContent(deletedAttachment, false, false);
            }
            return deletedAttachment;
        });
    }

    @Override
    public List<DeletedAttachment> getAllDeletedAttachments(XWikiAttachment attachment, XWikiContext context, boolean bTransaction) throws XWikiException {
        List deletedAttachments = this.executeRead(context, session -> {
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery query = builder.createQuery(DeletedAttachment.class);
            Root root = query.from(DeletedAttachment.class);
            query.select((Selection)root);
            if (attachment != null) {
                Predicate[] predicates;
                if (StringUtils.isNotBlank((CharSequence)attachment.getFilename())) {
                    predicates = new Predicate[2];
                    predicates[1] = builder.equal((Expression)root.get("filename"), (Object)attachment.getFilename());
                } else {
                    predicates = new Predicate[]{builder.equal((Expression)root.get(DOC_ID), (Object)attachment.getDocId())};
                }
                query.where(predicates);
            }
            query.orderBy(new Order[]{builder.desc((Expression)root.get(DATE))});
            return session.createQuery(query).getResultList();
        });
        return this.resolveAttachmentContents(deletedAttachments, bTransaction);
    }

    @Override
    public List<DeletedAttachment> getAllDeletedAttachments(XWikiDocument doc, XWikiContext context, boolean bTransaction) throws XWikiException {
        List deletedAttachments = this.executeRead(context, session -> {
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery query = builder.createQuery(DeletedAttachment.class);
            Root root = query.from(DeletedAttachment.class);
            query.select((Selection)root);
            query.where((Expression)builder.equal((Expression)root.get(DOC_ID), (Object)doc.getId()));
            query.orderBy(new Order[]{builder.desc((Expression)root.get(DATE))});
            return session.createQuery(query).getResultList();
        });
        return this.resolveAttachmentContents(deletedAttachments, bTransaction);
    }

    private List<DeletedAttachment> resolveAttachmentContents(List<DeletedAttachment> deletedAttachments, boolean bTransaction) throws XWikiException {
        ArrayList<DeletedAttachment> resolvedAttachments = new ArrayList<DeletedAttachment>(deletedAttachments.size());
        for (DeletedAttachment deletedAttachment : deletedAttachments) {
            resolvedAttachments.add(this.resolveDeletedAttachmentContent(deletedAttachment, bTransaction, false));
        }
        return resolvedAttachments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFromRecycleBin(final long index, XWikiContext inputxcontext, final boolean bTransaction) throws XWikiException {
        final XWikiContext context = this.getExecutionXContext(inputxcontext, true);
        try {
            this.executeWrite(context, new XWikiHibernateBaseStore.HibernateCallback<Object>(){

                @Override
                public Object doInHibernate(Session session) throws XWikiException {
                    DeletedAttachment deletedDocument = HibernateAttachmentRecycleBinStore.this.loadDeletedAttachment(index, context, false);
                    try {
                        session.createQuery("delete from " + DeletedAttachment.class.getName() + " where id=:id").setParameter("id", (Object)index).executeUpdate();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    HibernateAttachmentRecycleBinStore.this.deleteDeletedAttachmentContent(deletedDocument, bTransaction);
                    return null;
                }
            });
        }
        finally {
            this.restoreExecutionXContext();
        }
    }

    private AttachmentRecycleBinContentStore getDefaultAttachmentRecycleBinContentStore() throws XWikiException {
        try {
            return this.storeConfiguration.getAttachmentRecycleBinContentStore();
        }
        catch (ComponentLookupException e) {
            throw new XWikiException(3, 0, "Failed to lookup attachment recycle bin content store", e);
        }
    }

    protected AttachmentRecycleBinContentStore getAttachmentRecycleBinContentStore(String storeType) {
        if (storeType != null && !storeType.equals("hibernate")) {
            try {
                return (AttachmentRecycleBinContentStore)this.componentManager.getInstance(AttachmentRecycleBinContentStore.class, storeType);
            }
            catch (ComponentLookupException e) {
                this.logger.warn("Can't find attachment recycle bin content store for type [{}]", (Object)storeType, (Object)e);
            }
        }
        return null;
    }

    private DeletedAttachment resolveDeletedAttachmentContent(DeletedAttachment deletedAttachment, boolean bTransaction, boolean failIfNoContent) throws XWikiException {
        AttachmentRecycleBinContentStore contentStore = this.getAttachmentRecycleBinContentStore(deletedAttachment.getContentStore());
        if (contentStore != null) {
            AttachmentReference reference = deletedAttachment.getAttachmentReference();
            DeletedAttachmentContent content = contentStore.get(reference, deletedAttachment.getDate(), deletedAttachment.getId(), bTransaction);
            if (content == null) {
                if (failIfNoContent) {
                    throw new XWikiException(3, 0, "Can't find any content for deleted attachment [" + String.valueOf(reference) + "] with id [" + deletedAttachment.getId() + "]");
                }
                this.logger.warn("Can't find any content for deleted attachment [{}] with id [{}]", (Object)reference, (Object)deletedAttachment.getId());
            }
            try {
                FieldUtils.writeDeclaredField((Object)deletedAttachment, (String)"content", (Object)content, (boolean)true);
            }
            catch (IllegalAccessException e) {
                throw new XWikiException(3, 0, "Failed to set deleted document content", e);
            }
        }
        return deletedAttachment;
    }

    private DeletedAttachment createDeletedAttachment(XWikiAttachment attachment, String deleter, Date date, AttachmentRecycleBinContentStore contentStore) throws XWikiException {
        String storeType = null;
        HibernateDeletedAttachmentContent deletedDocumentContent = null;
        if (contentStore != null) {
            storeType = contentStore.getHint();
        } else {
            deletedDocumentContent = new HibernateDeletedAttachmentContent(attachment);
        }
        DeletedAttachment trashdoc = new DeletedAttachment(attachment.getDocId(), attachment.getDoc().getFullName(), attachment.getFilename(), storeType, deleter, date, deletedDocumentContent);
        return trashdoc;
    }

    private void deleteDeletedAttachmentContent(DeletedAttachment deletedAttachment, boolean bTransaction) throws XWikiException {
        AttachmentRecycleBinContentStore contentStore = this.getAttachmentRecycleBinContentStore(deletedAttachment.getContentStore());
        if (contentStore != null) {
            contentStore.delete(deletedAttachment.getAttachmentReference(), deletedAttachment.getDate(), deletedAttachment.getId(), bTransaction);
        }
    }
}

