/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.store;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.criteria.impl.RevisionCriteria;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.doc.XWikiDocumentArchive;
import com.xpn.xwiki.doc.rcs.XWikiRCSNodeContent;
import com.xpn.xwiki.doc.rcs.XWikiRCSNodeId;
import com.xpn.xwiki.doc.rcs.XWikiRCSNodeInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.suigeneris.jrcs.rcs.Version;
import org.xwiki.component.annotation.Role;
import org.xwiki.stability.Unstable;

@Role
public interface XWikiVersioningStoreInterface {
    public void loadXWikiDocArchive(XWikiDocumentArchive var1, boolean var2, XWikiContext var3) throws XWikiException;

    public void saveXWikiDocArchive(XWikiDocumentArchive var1, boolean var2, XWikiContext var3) throws XWikiException;

    public void updateXWikiDocArchive(XWikiDocument var1, boolean var2, XWikiContext var3) throws XWikiException;

    public Version[] getXWikiDocVersions(XWikiDocument var1, XWikiContext var2) throws XWikiException;

    private boolean matchCriteria(XWikiRCSNodeInfo nodeinfo, RevisionCriteria criteria) {
        if (criteria.getAuthor().isEmpty() || criteria.getAuthor().equals(nodeinfo.getAuthor())) {
            Date versionDate = nodeinfo.getDate();
            return versionDate.after(criteria.getMinDate()) && versionDate.before(criteria.getMaxDate());
        }
        return false;
    }

    default public Collection<String> filterVersions(XWikiDocumentArchive archive, RevisionCriteria criteria) {
        ArrayList<String> results = new ArrayList<String>();
        ArrayList<XWikiRCSNodeInfo> nodes = new ArrayList<XWikiRCSNodeInfo>(archive.getNodes());
        Collections.reverse(nodes);
        Iterator nodesIterator = nodes.iterator();
        if (!nodesIterator.hasNext()) {
            return List.of();
        }
        XWikiRCSNodeInfo nodeinfo = (XWikiRCSNodeInfo)nodesIterator.next();
        while (nodesIterator.hasNext()) {
            XWikiRCSNodeInfo nextNodeinfo = (XWikiRCSNodeInfo)nodesIterator.next();
            if ((criteria.getIncludeMinorVersions() || !nextNodeinfo.isMinorEdit()) && this.matchCriteria(nodeinfo, criteria)) {
                results.add(nodeinfo.getVersion().toString());
            }
            nodeinfo = nextNodeinfo;
        }
        if (this.matchCriteria(nodeinfo, criteria)) {
            results.add(nodeinfo.getVersion().toString());
        }
        return criteria.getRange().subList(results);
    }

    @Unstable
    default public Collection<Version> getXWikiDocVersions(XWikiDocument doc, RevisionCriteria criteria, XWikiContext context) throws XWikiException {
        return this.filterVersions(this.getXWikiDocumentArchive(doc, context), criteria).stream().map(Version::new).collect(Collectors.toList());
    }

    @Unstable
    default public long getXWikiDocVersionsCount(XWikiDocument doc, RevisionCriteria criteria, XWikiContext context) throws XWikiException {
        return this.filterVersions(this.getXWikiDocumentArchive(doc, context), criteria).size();
    }

    public XWikiDocument loadXWikiDoc(XWikiDocument var1, String var2, XWikiContext var3) throws XWikiException;

    public void resetRCSArchive(XWikiDocument var1, boolean var2, XWikiContext var3) throws XWikiException;

    public XWikiDocumentArchive getXWikiDocumentArchive(XWikiDocument var1, XWikiContext var2) throws XWikiException;

    public void deleteArchive(XWikiDocument var1, boolean var2, XWikiContext var3) throws XWikiException;

    public XWikiRCSNodeContent loadRCSNodeContent(XWikiRCSNodeId var1, boolean var2, XWikiContext var3) throws XWikiException;
}

