/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.store;

public final class DatabaseProduct {
    public static final DatabaseProduct ORACLE = new DatabaseProduct("Oracle", "oracle");
    public static final DatabaseProduct DERBY = new DatabaseProduct("Apache Derby", "derby");
    public static final DatabaseProduct HSQLDB = new DatabaseProduct("HSQL Database Engine", "hsqldb");
    public static final DatabaseProduct DB2 = new DatabaseProduct("DB2/", "db2");
    public static final DatabaseProduct MYSQL = new DatabaseProduct("MySQL", "mysql");
    public static final DatabaseProduct POSTGRESQL = new DatabaseProduct("PostgreSQL", "postgresql");
    public static final DatabaseProduct MSSQL = new DatabaseProduct("Microsoft SQL Server", "sqlserver");
    public static final DatabaseProduct H2 = new DatabaseProduct("H2", "h2");
    public static final DatabaseProduct UNKNOWN = new DatabaseProduct("Unknown", "unknown");
    private static final DatabaseProduct MARIADB = new DatabaseProduct("MariaDB", "mariadb");
    private String productName;
    private String jdbcScheme;

    private DatabaseProduct(String productName, String jdbcScheme) {
        this.productName = productName;
        this.jdbcScheme = jdbcScheme;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getJDBCScheme() {
        return this.jdbcScheme;
    }

    public boolean equals(Object object) {
        DatabaseProduct product;
        boolean result = false;
        if (object instanceof DatabaseProduct && (product = (DatabaseProduct)object).getProductName().equals(this.getProductName())) {
            result = true;
        }
        return result;
    }

    public static DatabaseProduct toProduct(String productNameOrJDBCScheme) {
        DatabaseProduct product = DatabaseProduct.matches(productNameOrJDBCScheme, ORACLE) ? ORACLE : (DatabaseProduct.matches(productNameOrJDBCScheme, DERBY) ? DERBY : (DatabaseProduct.matches(productNameOrJDBCScheme, HSQLDB) ? HSQLDB : (DatabaseProduct.matches(productNameOrJDBCScheme, H2) ? H2 : (productNameOrJDBCScheme.startsWith(DB2.getProductName()) || DatabaseProduct.DB2.jdbcScheme.equalsIgnoreCase(productNameOrJDBCScheme) ? DB2 : (DatabaseProduct.isMySQL(productNameOrJDBCScheme) ? MYSQL : (DatabaseProduct.matches(productNameOrJDBCScheme, POSTGRESQL) ? POSTGRESQL : (DatabaseProduct.matches(productNameOrJDBCScheme, MSSQL) ? MSSQL : UNKNOWN)))))));
        return product;
    }

    private static boolean isMySQL(String productNameOrJDBCScheme) {
        return DatabaseProduct.matches(productNameOrJDBCScheme, MYSQL) || DatabaseProduct.matches(productNameOrJDBCScheme, MARIADB);
    }

    private static boolean matches(String productNameOrJDBCScheme, DatabaseProduct product) {
        return product.getProductName().equalsIgnoreCase(productNameOrJDBCScheme) || product.jdbcScheme.equalsIgnoreCase(productNameOrJDBCScheme);
    }

    public int hashCode() {
        return this.getProductName().hashCode();
    }

    public String toString() {
        return this.getProductName();
    }
}

