/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.stats.impl.xwiki;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.stats.impl.StatsUtil;
import com.xpn.xwiki.stats.impl.VisitStats;
import com.xpn.xwiki.stats.impl.xwiki.DocumentStatsStoreItem;
import com.xpn.xwiki.stats.impl.xwiki.RefererStatsStoreItem;
import com.xpn.xwiki.stats.impl.xwiki.StopStatsRegisterObject;
import com.xpn.xwiki.stats.impl.xwiki.StopStatsStoreException;
import com.xpn.xwiki.stats.impl.xwiki.VisitStatsStoreItem;
import com.xpn.xwiki.stats.impl.xwiki.XWikiStatsStoreItem;
import com.xpn.xwiki.util.AbstractXWikiRunnable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.context.ExecutionContext;

public class XWikiStatsStoreService
extends AbstractXWikiRunnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(XWikiStatsStoreService.class);
    private ArrayBlockingQueue<XWikiStatsStoreItem> queue;
    private Thread thread;
    private XWikiContext xwikiContext;

    public XWikiStatsStoreService(XWikiContext context) {
        this.xwikiContext = context.clone();
        long queueSize = context.getWiki().ParamAsLong("stats.queue.size", 200L);
        this.queue = new ArrayBlockingQueue((int)queueSize);
    }

    @Override
    protected void declareProperties(ExecutionContext executionContext) {
        this.xwikiContext.declareInExecutionContext(executionContext);
        this.xwikiContext = null;
    }

    public void start() {
        if (this.thread == null) {
            this.thread = new Thread((Runnable)this, "Statistics storing daemon");
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    public void stop() {
        block2: {
            this.queue.clear();
            try {
                this.queue.put(new StopStatsRegisterObject());
                this.thread.join();
                this.thread = null;
            }
            catch (InterruptedException e) {
                if (!LOGGER.isWarnEnabled()) break block2;
                LOGGER.warn("Thread join has been interrupted", (Throwable)e);
            }
        }
    }

    @Override
    public void runInternal() throws InterruptedException {
        try {
            while (true) {
                this.register();
            }
        }
        catch (InterruptedException e) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Statistics storing thread has been interrupted.", (Throwable)e);
            }
            throw e;
        }
        catch (StopStatsStoreException e) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.warn("Statistics storing thread received stop order.", (Throwable)e);
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void register() throws InterruptedException, StopStatsStoreException {
        XWikiStatsStoreItem stat = this.queue.take();
        ArrayList statsList = new ArrayList();
        HashMap statsMap = new HashMap();
        do {
            void var5_5;
            if (stat instanceof StopStatsRegisterObject) {
                throw new StopStatsStoreException();
            }
            String statId = stat.getId();
            List list = (List)statsMap.get(statId);
            if (list == null) {
                ArrayList arrayList = new ArrayList();
                statsMap.put(statId, arrayList);
                statsList.add(arrayList);
            }
            var5_5.add(stat);
        } while ((stat = this.queue.poll()) != null);
        for (List list : statsList) {
            ((XWikiStatsStoreItem)list.get(0)).store(list);
        }
    }

    public void add(XWikiStatsStoreItem statsRegisterItem) {
        try {
            this.queue.put(statsRegisterItem);
        }
        catch (InterruptedException e) {
            LOGGER.error("Statistics storage thread has been interrupted", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStats(XWikiDocument doc, String action, XWikiContext context) {
        VisitStats vobject;
        VisitStats visitStats = vobject = StatsUtil.findVisit(context);
        synchronized (visitStats) {
            if (action.equals("view")) {
                vobject.incPageViews();
            } else if (action.equals("save")) {
                vobject.incPageSaves();
            } else if (action.equals("download")) {
                vobject.incDownloads();
            }
            this.addVisitStats(vobject, context);
            boolean isVisit = vobject.getPageViews() == 1 && action.equals("view");
            this.addDocumentStats(doc, action, isVisit, context);
        }
        if (action.equals("view")) {
            this.addRefererStats(doc, context);
        }
    }

    private void addVisitStats(VisitStats vobject, XWikiContext context) {
        Date currentDate = new Date();
        vobject.setEndDate(currentDate);
        this.add(new VisitStatsStoreItem(vobject, context));
        vobject.unrememberOldObject();
    }

    private void addDocumentStats(XWikiDocument doc, String action, boolean isVisit, XWikiContext context) {
        Date currentDate = new Date();
        this.add(new DocumentStatsStoreItem(doc.getFullName(), currentDate, StatsUtil.PeriodType.MONTH, action, isVisit, context));
        this.add(new DocumentStatsStoreItem(doc.getSpace(), currentDate, StatsUtil.PeriodType.MONTH, action, isVisit, context));
        this.add(new DocumentStatsStoreItem("", currentDate, StatsUtil.PeriodType.MONTH, action, false, context));
        this.add(new DocumentStatsStoreItem(doc.getFullName(), currentDate, StatsUtil.PeriodType.DAY, action, isVisit, context));
        this.add(new DocumentStatsStoreItem(doc.getSpace(), currentDate, StatsUtil.PeriodType.DAY, action, isVisit, context));
        this.add(new DocumentStatsStoreItem("", currentDate, StatsUtil.PeriodType.DAY, action, false, context));
    }

    private void addRefererStats(XWikiDocument doc, XWikiContext context) {
        String referer = StatsUtil.getReferer(context);
        if (referer != null && !referer.equals("")) {
            this.add(new RefererStatsStoreItem(doc.getFullName(), new Date(), StatsUtil.PeriodType.MONTH, referer, context));
        }
    }
}

