/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.stats.impl.xwiki;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.criteria.impl.Duration;
import com.xpn.xwiki.criteria.impl.Period;
import com.xpn.xwiki.criteria.impl.Range;
import com.xpn.xwiki.criteria.impl.RangeFactory;
import com.xpn.xwiki.criteria.impl.Scope;
import com.xpn.xwiki.stats.impl.DocumentStats;
import com.xpn.xwiki.stats.impl.RefererStats;
import com.xpn.xwiki.stats.impl.StatsUtil;
import com.xpn.xwiki.stats.impl.VisitStats;
import com.xpn.xwiki.store.XWikiHibernateStore;
import com.xpn.xwiki.web.Utils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;

public class XWikiStatsReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(XWikiStatsReader.class);
    private EntityReferenceSerializer<String> compactwikiEntityReferenceSerializer = (EntityReferenceSerializer)Utils.getComponent(EntityReferenceSerializer.TYPE_STRING, "compactwiki");
    private QueryManager queryManager = Utils.getComponent(QueryManager.class);

    public Collection<Object> getRecentActions(String action, int size, XWikiContext context) {
        Collection<?> actions;
        ArrayList<Object> list = new ArrayList<Object>();
        if ((action.equals("view") || action.equals("save")) && (actions = StatsUtil.getRecentActionFromSessions(context, action)) != null) {
            Object[] actionsarray = actions.toArray();
            CollectionUtils.reverseArray((Object[])actionsarray);
            int nb = Math.min(actions.size(), size);
            for (int i = 0; i < nb; ++i) {
                list.add(actionsarray[i]);
            }
        }
        return list;
    }

    private String getHqlSortOrderFromRange(Range range) {
        String sortOrder = range.getSize() < 0 ? "asc" : "desc";
        return sortOrder;
    }

    private String getHqlValidDomain(String domain) {
        if (domain == null || domain.trim().length() == 0) {
            return "%";
        }
        return domain;
    }

    private String getHqlNameFilterFromScope(Scope scope, Map<String, Object> params) {
        String nameFilter;
        if (scope.getType() == 2 && StringUtils.isEmpty((CharSequence)scope.getName())) {
            nameFilter = "name not like '%.%' and (name <> '' or (name is not null and '' is null))";
        } else if (scope.getType() == 4 && StringUtils.isEmpty((CharSequence)scope.getName())) {
            nameFilter = "name = '' or name is null";
        } else if (scope.getType() == 1 && StringUtils.isEmpty((CharSequence)scope.getName())) {
            nameFilter = "name like '%.%'";
        } else {
            nameFilter = "name like :nameFilter";
            params.put("nameFilter", scope.getPattern());
        }
        return nameFilter;
    }

    public Map<DateTime, Integer> getActionStatistics(String action, Scope scope, Period period, Duration step, XWikiContext context) {
        DateTime stepStart = new DateTime(period.getStart());
        DateTime periodEnd = new DateTime(period.getEnd());
        org.joda.time.Period stepDuration = new org.joda.time.Period(step.getYears(), step.getMonths(), step.getWeeks(), step.getDays(), 0, 0, 0, 0);
        HashMap<DateTime, Integer> activity = new HashMap<DateTime, Integer>();
        while (stepStart.compareTo((ReadableInstant)periodEnd) < 0) {
            DateTime stepEnd = stepStart.plus((ReadablePeriod)stepDuration);
            if (stepEnd.compareTo((ReadableInstant)periodEnd) > 0) {
                stepEnd = periodEnd;
            }
            List<DocumentStats> stats = this.getDocumentStatistics(action, scope, new Period(stepStart.getMillis(), stepEnd.getMillis()), RangeFactory.FIRST, context);
            int actionCount = 0;
            if (!stats.isEmpty()) {
                actionCount = stats.get(0).getPageViews();
            }
            activity.put(stepStart, actionCount);
            stepStart = stepEnd;
        }
        return activity;
    }

    public List<DocumentStats> getDocumentStatistics(String action, Scope scope, Period period, Range range, XWikiContext context) {
        List<DocumentStats> documentStatsList;
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        String nameFilter = this.getHqlNameFilterFromScope(scope, params);
        String sortOrder = this.getHqlSortOrderFromRange(range);
        try {
            String statement = MessageFormat.format("select name, sum(pageViews) from DocumentStats where ({0}) and action=:action and :start <= period and period < :end group by name order by sum(pageViews) {1}", nameFilter, sortOrder);
            params.put("action", action);
            params.put("start", period.getStartCode());
            params.put("end", period.getEndCode());
            Query query = this.queryManager.createQuery(statement, "hql");
            query.bindValues(params);
            query.setLimit(range.getAbsoluteSize());
            query.setOffset(range.getAbsoluteStart());
            List solist = query.execute();
            documentStatsList = this.getDocumentStatistics(solist, action);
            if (range.getSize() < 0) {
                Collections.reverse(documentStatsList);
            }
        }
        catch (QueryException e) {
            documentStatsList = Collections.emptyList();
        }
        return documentStatsList;
    }

    private List<DocumentStats> getDocumentStatistics(List<?> resultSet, String action) {
        ArrayList<DocumentStats> documentStatsList = new ArrayList<DocumentStats>(resultSet.size());
        Date now = new Date();
        for (Object name : resultSet) {
            Object[] result = (Object[])name;
            DocumentStats docStats = new DocumentStats((String)result[0], action, now, StatsUtil.PeriodType.DAY);
            docStats.setPageViews(((Number)result[1]).intValue());
            documentStatsList.add(docStats);
        }
        return documentStatsList;
    }

    public List<DocumentStats> getBackLinkStatistics(String domain, Scope scope, Period period, Range range, XWikiContext context) {
        List<DocumentStats> documentStatsList;
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        String nameFilter = this.getHqlNameFilterFromScope(scope, params);
        String sortOrder = this.getHqlSortOrderFromRange(range);
        try {
            String statement = MessageFormat.format("select name, sum(pageViews) from RefererStats where ({0}) and referer like :referer and :start <= period and period < :end group by name order by sum(pageViews) {1}", nameFilter, sortOrder);
            params.put("referer", this.getHqlValidDomain(domain));
            params.put("start", period.getStartCode());
            params.put("end", period.getEndCode());
            Query query = this.queryManager.createQuery(statement, "hql");
            query.bindValues(params);
            query.setLimit(range.getAbsoluteSize());
            query.setOffset(range.getAbsoluteStart());
            List solist = query.execute();
            documentStatsList = this.getDocumentStatistics(solist, "refer");
            if (range.getSize() < 0) {
                Collections.reverse(documentStatsList);
            }
        }
        catch (QueryException e) {
            documentStatsList = Collections.emptyList();
        }
        return documentStatsList;
    }

    public List<RefererStats> getRefererStatistics(String domain, Scope scope, Period period, Range range, XWikiContext context) {
        List<RefererStats> refererList;
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        String nameFilter = this.getHqlNameFilterFromScope(scope, params);
        String sortOrder = this.getHqlSortOrderFromRange(range);
        try {
            String statement = MessageFormat.format("select referer, sum(pageViews) from RefererStats where ({0}) and referer like :referer and :start <= period and period < :end group by referer order by sum(pageViews) {1}", nameFilter, sortOrder);
            params.put("referer", this.getHqlValidDomain(domain));
            params.put("start", period.getStartCode());
            params.put("end", period.getEndCode());
            Query query = this.queryManager.createQuery(statement, "hql");
            query.bindValues(params);
            query.setLimit(range.getAbsoluteSize());
            query.setOffset(range.getAbsoluteStart());
            List solist = query.execute();
            refererList = this.getRefererStatistics(solist);
            if (range.getSize() < 0) {
                Collections.reverse(refererList);
            }
        }
        catch (QueryException e) {
            refererList = Collections.emptyList();
        }
        return refererList;
    }

    private List<RefererStats> getRefererStatistics(List<?> resultSet) {
        Date now = new Date();
        ArrayList<RefererStats> stats = new ArrayList<RefererStats>(resultSet.size());
        for (Object name : resultSet) {
            Object[] result = (Object[])name;
            RefererStats refStats = new RefererStats("", (String)result[0], now, StatsUtil.PeriodType.DAY);
            refStats.setPageViews(((Number)result[1]).intValue());
            stats.add(refStats);
        }
        return stats;
    }

    private String createVisitStatisticsQuery(String action, Period period, Range range, List<Object> paramList, XWikiContext context) {
        StringBuilder query = new StringBuilder("select name, sum(pageSaves), sum(pageViews), sum(downloads)");
        query.append(" from VisitStats");
        query.append(" where");
        StringBuilder userListWhere = new StringBuilder();
        try {
            for (DocumentReference user : StatsUtil.getRequestFilteredUsers(context)) {
                if (userListWhere.length() > 0) {
                    userListWhere.append(", ");
                }
                paramList.add(this.compactwikiEntityReferenceSerializer.serialize((EntityReference)user, new Object[0]));
                userListWhere.append("?" + paramList.size());
            }
        }
        catch (Exception e) {
            LOGGER.error("Faild to get filter users list", (Throwable)e);
        }
        if (userListWhere.length() > 0) {
            query.append(" name NOT IN (");
            query.append((CharSequence)userListWhere);
            query.append(") and ");
        }
        query.append(" ?" + (paramList.size() + 1) + " <= startDate and endDate < ?" + (paramList.size() + 2) + " group by name");
        paramList.add(new Date(period.getStart()));
        paramList.add(new Date(period.getEnd()));
        query.append(' ');
        String sortOrder = this.getHqlSortOrderFromRange(range);
        if (action.equals("save")) {
            query.append("order by sum(pageSaves) " + sortOrder);
        } else if (action.equals("view")) {
            query.append("order by sum(pageViews) " + sortOrder);
        } else if (action.equals("download")) {
            query.append("order by sum(downloads) " + sortOrder);
        } else {
            query.append(MessageFormat.format("order by sum(pageSaves) {0}, sum(pageViews) {0}, sum(downloads) {0}", sortOrder));
        }
        return query.toString();
    }

    public List<VisitStats> getVisitStatistics(String action, Period period, Range range, XWikiContext context) {
        List<VisitStats> visiStatList;
        ArrayList<Object> paramList = new ArrayList<Object>(2);
        String query = this.createVisitStatisticsQuery(action, period, range, paramList, context);
        XWikiHibernateStore store = context.getWiki().getHibernateStore();
        try {
            List solist = store.search(query, range.getAbsoluteSize(), range.getAbsoluteStart(), paramList, context);
            visiStatList = this.getVisitStatistics(solist, new DateTime(period.getStart()), new DateTime(period.getEnd()));
            if (range.getSize() < 0) {
                Collections.reverse(visiStatList);
            }
        }
        catch (XWikiException e) {
            LOGGER.error("Faild to search for vist statistics", (Throwable)e);
            visiStatList = Collections.emptyList();
        }
        return visiStatList;
    }

    private List<VisitStats> getVisitStatistics(List<?> resultSet, DateTime startDate, DateTime endDate) {
        ArrayList<VisitStats> stats = new ArrayList<VisitStats>(resultSet.size());
        for (Object name2 : resultSet) {
            Object[] result = (Object[])name2;
            String name = (String)result[0];
            String uniqueID = "";
            String cookie = "";
            String ip = "";
            String userAgent = "";
            int pageSaves = ((Number)result[1]).intValue();
            int pageViews = ((Number)result[2]).intValue();
            int downloads = ((Number)result[3]).intValue();
            VisitStats vs = new VisitStats(name, uniqueID, cookie, ip, userAgent, new Date(startDate.getMillis()), StatsUtil.PeriodType.DAY);
            vs.setStartDate(new Date(startDate.getMillis()));
            vs.setEndDate(new Date(endDate.getMillis()));
            vs.setPageSaves(pageSaves);
            vs.setPageViews(pageViews);
            vs.setDownloads(downloads);
            stats.add(vs);
        }
        return stats;
    }

    @Deprecated
    public DocumentStats getDocMonthStats(String docname, String action, Date month, XWikiContext context) {
        XWikiHibernateStore store = context.getWiki().getHibernateStore();
        DocumentStats object = new DocumentStats(docname, action, month, StatsUtil.PeriodType.MONTH);
        try {
            store.loadXWikiCollection(object, context, true);
            return object;
        }
        catch (XWikiException e) {
            e.printStackTrace();
            return new DocumentStats();
        }
    }

    @Deprecated
    public List<?> getRefMonthStats(String docName, Date month, XWikiContext context) throws XWikiException {
        List solist;
        XWikiHibernateStore store = context.getWiki().getHibernateStore();
        if (store != null) {
            ArrayList<String> paramList = new ArrayList<String>(1);
            paramList.add(docName);
            solist = store.search("from RefererStats as obj where obj.name=?", 0, 0, paramList, context);
        } else {
            solist = Collections.emptyList();
        }
        return solist;
    }
}

