/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.stats.impl.xwiki;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.stats.impl.DocumentStats;
import com.xpn.xwiki.stats.impl.StatsUtil;
import com.xpn.xwiki.stats.impl.xwiki.AbstractStatsStoreItem;
import com.xpn.xwiki.stats.impl.xwiki.XWikiStatsStoreItem;
import com.xpn.xwiki.store.XWikiHibernateStore;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentStatsStoreItem
extends AbstractStatsStoreItem {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentStatsStoreItem.class);
    private String action;
    private boolean isVisit;

    public DocumentStatsStoreItem(String name, Date periodDate, StatsUtil.PeriodType periodType, String action, boolean isVisit, XWikiContext context) {
        super(name, periodDate, periodType, context);
        this.action = action;
        this.isVisit = isVisit;
    }

    @Override
    public String getId() {
        return String.format("%s %s %s %s", this.getClass(), this.name, this.action, this.period);
    }

    @Override
    public void storeInternal(List<XWikiStatsStoreItem> stats) {
        DocumentStats documentStat;
        XWikiHibernateStore store;
        block6: {
            DocumentStatsStoreItem lastItem = (DocumentStatsStoreItem)stats.get(stats.size() - 1);
            store = this.context.getWiki().getHibernateStore();
            if (store == null) {
                return;
            }
            documentStat = new DocumentStats(lastItem.name, lastItem.action, lastItem.periodDate, lastItem.periodType);
            try {
                store.loadXWikiCollection(documentStat, this.context, true);
            }
            catch (XWikiException e) {
                if (!LOGGER.isDebugEnabled()) break block6;
                LOGGER.debug("Failed to load document statistics object [{}]", (Object)this.getId(), (Object)e);
            }
        }
        documentStat.setIntValue("pageViews", documentStat.getPageViews() + stats.size());
        for (XWikiStatsStoreItem statItem : stats) {
            DocumentStatsStoreItem docStat = (DocumentStatsStoreItem)statItem;
            if (!docStat.isVisit) continue;
            documentStat.incVisits();
        }
        try {
            store.saveXWikiCollection(documentStat, this.context, true);
        }
        catch (XWikiException e) {
            LOGGER.error("Failed to save document statistics object [{}]", (Object)this.getId(), (Object)e);
        }
    }
}

