/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.stats.impl;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.criteria.impl.Duration;
import com.xpn.xwiki.criteria.impl.Period;
import com.xpn.xwiki.criteria.impl.Range;
import com.xpn.xwiki.criteria.impl.Scope;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.stats.api.XWikiStatsService;
import com.xpn.xwiki.stats.impl.DocumentStats;
import com.xpn.xwiki.stats.impl.RefererStats;
import com.xpn.xwiki.stats.impl.StatsUtil;
import com.xpn.xwiki.stats.impl.VisitStats;
import com.xpn.xwiki.stats.impl.xwiki.XWikiStatsReader;
import com.xpn.xwiki.stats.impl.xwiki.XWikiStatsStoreService;
import com.xpn.xwiki.web.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.bridge.event.ActionExecutedEvent;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;
import org.xwiki.observation.remote.RemoteObservationManagerContext;

public class XWikiStatsServiceImpl
implements XWikiStatsService,
EventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(XWikiStatsServiceImpl.class);
    private static final String NAME = "statistics";
    private static final List<Event> EVENTS = new ArrayList<Event>(){
        {
            this.add(new ActionExecutedEvent("view"));
            this.add(new ActionExecutedEvent("save"));
            this.add(new ActionExecutedEvent("download"));
        }
    };
    private DocumentReferenceResolver<String> currentDocumentReferenceResolver = (DocumentReferenceResolver)Utils.getComponent(DocumentReferenceResolver.TYPE_STRING, "current");
    private XWikiStatsStoreService statsRegister;
    private XWikiStatsReader statsReader = new XWikiStatsReader();

    public String getName() {
        return NAME;
    }

    public List<Event> getEvents() {
        return EVENTS;
    }

    @Override
    public void init(XWikiContext context) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Start statistics service initialization");
        }
        if (StatsUtil.isStatsEnabled(context)) {
            this.statsRegister = new XWikiStatsStoreService(context);
            this.statsRegister.start();
            Utils.getComponent(ObservationManager.class).addListener((EventListener)this);
        }
    }

    public Collection<Object> getRecentActions(String action, int size, XWikiContext context) {
        return this.statsReader.getRecentActions(action, size, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event event, Object source, Object data) {
        if (Utils.getComponent(RemoteObservationManagerContext.class).isRemoteState()) {
            return;
        }
        ActionExecutedEvent actionEvent = (ActionExecutedEvent)event;
        XWikiDocument document = (XWikiDocument)source;
        XWikiContext context = (XWikiContext)data;
        if (context.getWiki().isReadOnly()) {
            return;
        }
        StatsUtil.findCookie(context);
        String action = actionEvent.getActionName();
        XWikiStatsServiceImpl xWikiStatsServiceImpl = this;
        synchronized (xWikiStatsServiceImpl) {
            if (!action.equals("download")) {
                String element;
                CircularFifoQueue actions = StatsUtil.getRecentActionFromSessions(context, action);
                if (actions == null) {
                    actions = new CircularFifoQueue(StatsUtil.getRecentVisitSize(context));
                    StatsUtil.setRecentActionsFromSession(context, action, actions);
                }
                if (actions.contains(element = document.getPrefixedFullName())) {
                    actions.remove(element);
                }
                actions.add(element);
            }
        }
        try {
            if (StatsUtil.isWikiStatsEnabled(context) && !StatsUtil.getStorageFilteredUsers(context).contains(this.currentDocumentReferenceResolver.resolve((Object)context.getUser(), new Object[0]))) {
                this.statsRegister.addStats(document, action, context);
            }
        }
        catch (Exception e) {
            LOGGER.error("Faild to get filter users list", (Throwable)e);
        }
    }

    @Override
    public Map<?, ?> getActionStatistics(String action, Scope scope, Period period, Duration step, XWikiContext context) {
        return this.statsReader.getActionStatistics(action, scope, period, step, context);
    }

    @Override
    public List<DocumentStats> getDocumentStatistics(String action, Scope scope, Period period, Range range, XWikiContext context) {
        return this.statsReader.getDocumentStatistics(action, scope, period, range, context);
    }

    public List<DocumentStats> getBackLinkStatistics(String domain, Scope scope, Period period, Range range, XWikiContext context) {
        return this.statsReader.getBackLinkStatistics(domain, scope, period, range, context);
    }

    @Override
    public List<RefererStats> getRefererStatistics(String domain, Scope scope, Period period, Range range, XWikiContext context) {
        return this.statsReader.getRefererStatistics(domain, scope, period, range, context);
    }

    @Override
    public List<VisitStats> getVisitStatistics(String action, Period period, Range range, XWikiContext context) {
        return this.statsReader.getVisitStatistics(action, period, range, context);
    }

    @Override
    public DocumentStats getDocTotalStats(String docname, String action, XWikiContext context) {
        return new DocumentStats();
    }

    @Override
    public DocumentStats getDocMonthStats(String docname, String action, Date month, XWikiContext context) {
        return this.statsReader.getDocMonthStats(docname, action, month, context);
    }

    @Override
    public DocumentStats getDocDayStats(String docname, String action, Date day, XWikiContext context) {
        return new DocumentStats();
    }

    @Override
    public List<?> getRefMonthStats(String docName, Date month, XWikiContext context) throws XWikiException {
        return this.statsReader.getRefMonthStats(docName, month, context);
    }
}

