/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.script.sheet;

import com.xpn.xwiki.api.Document;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.script.service.ScriptService;
import org.xwiki.sheet.SheetBinder;
import org.xwiki.sheet.SheetManager;

@Component
@Named(value="sheet")
@Singleton
public class SheetScriptService
implements ScriptService {
    @Inject
    private SheetManager sheetManager;
    @Inject
    @Named(value="class")
    private SheetBinder classSheetBinder;
    @Inject
    @Named(value="document")
    private SheetBinder documentSheetBinder;
    @Inject
    private DocumentAccessBridge documentAccessBridge;

    public List<DocumentReference> getSheets(Document document, String action) {
        return this.filterViewable(this.sheetManager.getSheets(this.getReadOnlyDocument(document), action));
    }

    public List<DocumentReference> getClassSheets(Document classDocument) {
        return this.filterViewable(this.classSheetBinder.getSheets(this.getReadOnlyDocument(classDocument)));
    }

    public boolean bindClassSheet(Document classDocument, DocumentReference sheetReference) {
        return this.classSheetBinder.bind(this.getModifiableDocument(classDocument), sheetReference);
    }

    public boolean unbindClassSheet(Document classDocument, DocumentReference sheetReference) {
        return this.classSheetBinder.unbind(this.getModifiableDocument(classDocument), sheetReference);
    }

    public List<DocumentReference> getDocumentSheets(Document document) {
        return this.filterViewable(this.documentSheetBinder.getSheets(this.getReadOnlyDocument(document)));
    }

    public boolean bindDocumentSheet(Document document, DocumentReference sheetReference) {
        return this.documentSheetBinder.bind(this.getModifiableDocument(document), sheetReference);
    }

    public boolean unbindDocumentSheet(Document document, DocumentReference sheetReference) {
        return this.documentSheetBinder.unbind(this.getModifiableDocument(document), sheetReference);
    }

    public List<DocumentReference> getDocuments(DocumentReference sheetReference) {
        ArrayList<DocumentReference> documents = new ArrayList<DocumentReference>();
        documents.addAll(this.documentSheetBinder.getDocuments(sheetReference));
        documents.addAll(this.classSheetBinder.getDocuments(sheetReference));
        return this.filterViewable(documents);
    }

    private List<DocumentReference> filterViewable(List<DocumentReference> documentReferences) {
        ArrayList<DocumentReference> viewable = new ArrayList<DocumentReference>();
        for (DocumentReference documentReference : documentReferences) {
            if (!this.documentAccessBridge.isDocumentViewable(documentReference)) continue;
            viewable.add(documentReference);
        }
        return viewable;
    }

    private DocumentModelBridge getReadOnlyDocument(Document document) {
        try {
            Field docField = Document.class.getDeclaredField("doc");
            docField.setAccessible(true);
            return (DocumentModelBridge)docField.get(document);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to access the XWikiDocument instance wrapped by the document API.", e);
        }
    }

    private DocumentModelBridge getModifiableDocument(Document document) {
        try {
            Method getDocMethod = Document.class.getDeclaredMethod("getDoc", new Class[0]);
            getDocMethod.setAccessible(true);
            return (DocumentModelBridge)getDocMethod.invoke((Object)document, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get the modifiable XWikiDocument instance wrapped by the document API.", e);
        }
    }
}

