/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.script.display;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.internal.cache.rendering.RenderingCache;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.Execution;
import org.xwiki.display.internal.DocumentDisplayer;
import org.xwiki.display.internal.DocumentDisplayerParameters;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.RenderingContext;
import org.xwiki.script.service.ScriptService;
import org.xwiki.script.service.ScriptServiceManager;

@Component
@Named(value="display")
@Singleton
public class DisplayScriptService
implements ScriptService {
    public static final String ROLEHINT = "display";
    private static final String DISPLAYER_PARAMETERS_KEY = "displayerParameters";
    @Inject
    private Logger logger;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private RenderingCache renderingCache;
    @Inject
    private Execution execution;
    @Inject
    private RenderingContext renderingContext;
    @Inject
    private ScriptServiceManager scriptServiceManager;

    private Syntax getOutputSyntax(Map<String, Object> parameters) {
        Syntax outputSyntax = (Syntax)parameters.get("outputSyntax");
        if (outputSyntax == null) {
            String outputSyntaxId = (String)parameters.get("outputSyntaxId");
            if (outputSyntaxId != null) {
                try {
                    outputSyntax = Syntax.valueOf((String)outputSyntaxId);
                }
                catch (Exception e) {
                    this.logger.error("Failed to parse output syntax ID [{}].", (Object)outputSyntaxId, (Object)e);
                    return null;
                }
            } else {
                outputSyntax = this.renderingContext.getTargetSyntax();
            }
        }
        return outputSyntax;
    }

    private String document(Document document, Map<String, Object> parameters, Syntax outputSyntax) {
        String displayerHint;
        DocumentDisplayerParameters displayerParameters = (DocumentDisplayerParameters)parameters.get(DISPLAYER_PARAMETERS_KEY);
        if (displayerParameters == null) {
            displayerParameters = new DocumentDisplayerParameters();
            displayerParameters.setTargetSyntax(outputSyntax);
        }
        if ((displayerHint = (String)parameters.get("displayerHint")) == null) {
            displayerHint = "configured";
        }
        try {
            DocumentDisplayer displayer = (DocumentDisplayer)this.componentManager.getInstance(DocumentDisplayer.class, displayerHint);
            return this.renderXDOM(displayer.display((Object)this.getDocument(document), (Object)displayerParameters), outputSyntax);
        }
        catch (Exception e) {
            this.logger.error("Failed to display document [{}].", (Object)document.getPrefixedFullName(), (Object)e);
            return null;
        }
    }

    public DocumentDisplayerParameters createDocumentDisplayerParameters() {
        return new DocumentDisplayerParameters();
    }

    public String content(Document document) {
        return this.content(document, Collections.emptyMap());
    }

    public String content(Document document, Map<String, Object> parameters) {
        XWikiContext context = this.getXWikiContext();
        String content = null;
        try {
            content = document.getTranslatedContent();
        }
        catch (XWikiException e) {
            this.logger.warn("Failed to get the translated content of document [{}].", (Object)document.getPrefixedFullName(), (Object)e);
            return null;
        }
        String renderedContent = this.renderingCache.getRenderedContent(document.getDocumentReference(), content, context);
        if (renderedContent == null) {
            HashMap<String, Object> actualParameters = new HashMap<String, Object>(parameters);
            DocumentDisplayerParameters displayerParameters = (DocumentDisplayerParameters)parameters.get(DISPLAYER_PARAMETERS_KEY);
            if (displayerParameters == null) {
                displayerParameters = new DocumentDisplayerParameters();
                displayerParameters.setExecutionContextIsolated(true);
                displayerParameters.setContentTranslated(true);
            } else if (displayerParameters.isTitleDisplayed()) {
                displayerParameters = displayerParameters.clone();
            }
            displayerParameters.setTitleDisplayed(false);
            Syntax outputSyntax = this.getOutputSyntax(parameters);
            displayerParameters.setTargetSyntax(outputSyntax);
            actualParameters.put(DISPLAYER_PARAMETERS_KEY, displayerParameters);
            renderedContent = this.document(document, actualParameters, outputSyntax);
            if (renderedContent != null) {
                this.renderingCache.setRenderedContent(document.getDocumentReference(), content, renderedContent, context);
            }
        }
        return renderedContent;
    }

    public String title(Document document, Map<String, Object> parameters) {
        HashMap<String, Object> actualParameters = new HashMap<String, Object>(parameters);
        DocumentDisplayerParameters displayerParameters = (DocumentDisplayerParameters)parameters.get(DISPLAYER_PARAMETERS_KEY);
        if (displayerParameters == null) {
            displayerParameters = new DocumentDisplayerParameters();
            displayerParameters.setExecutionContextIsolated(true);
        } else if (!displayerParameters.isTitleDisplayed()) {
            displayerParameters = displayerParameters.clone();
        }
        displayerParameters.setTitleDisplayed(true);
        Syntax outputSyntax = this.getOutputSyntax(parameters);
        displayerParameters.setTargetSyntax(outputSyntax);
        actualParameters.put(DISPLAYER_PARAMETERS_KEY, displayerParameters);
        return this.document(document, actualParameters, outputSyntax);
    }

    public String title(Document document) {
        return this.title(document, Collections.emptyMap());
    }

    public <S extends ScriptService> S get(String serviceName) {
        return (S)this.scriptServiceManager.get("display." + serviceName);
    }

    private DocumentModelBridge getDocument(Document document) {
        try {
            Field docField = Document.class.getDeclaredField("doc");
            docField.setAccessible(true);
            return (DocumentModelBridge)docField.get(document);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to access the XWikiDocument instance wrapped by the document API.", e);
        }
    }

    private String renderXDOM(XDOM content, Syntax targetSyntax) throws XWikiException {
        try {
            BlockRenderer renderer = (BlockRenderer)this.componentManager.getInstance(BlockRenderer.class, targetSyntax.toIdString());
            DefaultWikiPrinter printer = new DefaultWikiPrinter();
            renderer.render((Block)content, (WikiPrinter)printer);
            return printer.toString();
        }
        catch (Exception e) {
            throw new XWikiException(4, 0, "Failed to render XDOM to syntax [" + String.valueOf(targetSyntax) + "]", e);
        }
    }

    @Deprecated
    private XWikiContext getXWikiContext() {
        return (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
    }
}

