/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.render;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

public class ScriptHttpSession
implements HttpSession,
HttpSessionContext {
    private static final String KEY_SAFESESSION = ScriptHttpSession.class.getName();
    private final HttpSession session;
    private final ContextualAuthorizationManager authorization;

    public ScriptHttpSession(HttpSession session, ContextualAuthorizationManager authorization) {
        this.session = session;
        this.authorization = authorization;
    }

    public long getCreationTime() {
        return this.session.getCreationTime();
    }

    public String getId() {
        return this.session.getId();
    }

    public long getLastAccessedTime() {
        return this.session.getLastAccessedTime();
    }

    public ServletContext getServletContext() {
        if (this.authorization.hasAccess(Right.PROGRAM)) {
            return this.session.getServletContext();
        }
        return null;
    }

    public void setMaxInactiveInterval(int interval) {
        this.session.setMaxInactiveInterval(interval);
    }

    public int getMaxInactiveInterval() {
        return this.session.getMaxInactiveInterval();
    }

    public HttpSessionContext getSessionContext() {
        return this;
    }

    public Object getSafeAttribute(String name) {
        Map safeSession = (Map)this.session.getAttribute(KEY_SAFESESSION);
        return safeSession != null ? safeSession.get(name) : null;
    }

    public void setSafeAttribute(String name, Object value) {
        ConcurrentHashMap<String, Object> safeSession = (ConcurrentHashMap<String, Object>)this.session.getAttribute(KEY_SAFESESSION);
        if (safeSession == null) {
            safeSession = new ConcurrentHashMap<String, Object>();
            this.session.setAttribute(KEY_SAFESESSION, safeSession);
        }
        safeSession.put(name, value);
    }

    public void removeSafeAttribute(String name) {
        Map safeSession = (Map)this.session.getAttribute(KEY_SAFESESSION);
        if (safeSession != null) {
            safeSession.remove(name);
        }
    }

    public Enumeration<String> getSafeAttributeNames() {
        Map safeSession = (Map)this.session.getAttribute(KEY_SAFESESSION);
        return safeSession != null ? Collections.enumeration(safeSession.keySet()) : Collections.emptyEnumeration();
    }

    public Object getAttribute(String name) {
        return this.authorization.hasAccess(Right.PROGRAM) ? this.session.getAttribute(name) : this.getSafeAttribute(name);
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return this.authorization.hasAccess(Right.PROGRAM) ? this.session.getAttributeNames() : this.getSafeAttributeNames();
    }

    public String[] getValueNames() {
        return this.session.getValueNames();
    }

    public void setAttribute(String name, Object value) {
        if (this.authorization.hasAccess(Right.PROGRAM)) {
            this.session.setAttribute(name, value);
        } else {
            this.setSafeAttribute(name, value);
        }
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        if (this.authorization.hasAccess(Right.PROGRAM)) {
            this.session.removeAttribute(name);
        } else {
            this.removeSafeAttribute(name);
        }
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public void invalidate() {
        if (this.authorization.hasAccess(Right.PROGRAM)) {
            this.session.invalidate();
        }
    }

    public boolean isNew() {
        return this.session.isNew();
    }

    public HttpSession getSession(String sessionId) {
        return this;
    }

    public Enumeration<String> getIds() {
        return this.session.getSessionContext().getIds();
    }
}

