/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.rightsmanager;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Api;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.rightsmanager.RightsManager;
import com.xpn.xwiki.plugin.rightsmanager.RightsManagerException;
import com.xpn.xwiki.plugin.rightsmanager.RightsManagerPluginApi;
import com.xpn.xwiki.plugin.rightsmanager.utils.RequestLimit;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RightsManagerUsersApi
extends Api {
    public static final String CONTEXT_LASTERRORCODE = "lasterrorcode";
    public static final String CONTEXT_LASTEXCEPTION = "lastexception";
    protected static final Logger LOGGER = LoggerFactory.getLogger(RightsManagerUsersApi.class);

    public RightsManagerUsersApi(XWikiContext context) {
        super(context);
    }

    private void logError(String comment, XWikiException e) {
        LOGGER.error(comment, (Throwable)e);
        this.context.put(CONTEXT_LASTERRORCODE, (Object)e.getCode());
        this.context.put(CONTEXT_LASTEXCEPTION, e);
    }

    public int countAllUsers() throws XWikiException {
        return this.countAllMatchedUsers(null);
    }

    public int countAllMatchedUsers(Map<?, ?> matchFields) throws XWikiException {
        int count = 0;
        try {
            count = RightsManager.getInstance().countAllUsersOrGroups(true, RightsManagerPluginApi.createMatchingTable(matchFields), this.context);
        }
        catch (RightsManagerException e) {
            this.logError("Try to count all users", e);
        }
        return count;
    }

    public int countAllWikiUsers(String wikiName) throws XWikiException {
        return this.countAllMatchedWikiUsers(wikiName, null);
    }

    public int countAllMatchedWikiUsers(String wikiName, Map<?, ?> matchFields) throws XWikiException {
        int count = 0;
        try {
            count = RightsManager.getInstance().countAllWikiUsersOrGroups(true, wikiName, RightsManagerPluginApi.createMatchingTable(matchFields), this.context);
        }
        catch (RightsManagerException e) {
            this.logError(MessageFormat.format("Try to count all users in wiki [{0}]", wikiName), e);
        }
        return count;
    }

    public int countAllGlobalUsers() throws XWikiException {
        return this.countAllMatchedGlobalUsers(null);
    }

    public int countAllMatchedGlobalUsers(Map<?, ?> matchFields) throws XWikiException {
        int count = 0;
        try {
            count = RightsManager.getInstance().countAllGlobalUsersOrGroups(true, RightsManagerPluginApi.createMatchingTable(matchFields), this.context);
        }
        catch (RightsManagerException e) {
            this.logError("Try to count all users in main wiki", e);
        }
        return count;
    }

    public int countAllLocalUsers() throws XWikiException {
        return this.countAllMatchedLocalUsers(null);
    }

    public int countAllMatchedLocalUsers(Map<?, ?> matchFields) throws XWikiException {
        int count = 0;
        try {
            count = RightsManager.getInstance().countAllLocalUsersOrGroups(true, RightsManagerPluginApi.createMatchingTable(matchFields), this.context);
        }
        catch (RightsManagerException e) {
            this.logError("Try to count all users in current wiki", e);
        }
        return count;
    }

    public List<String> getAllUsersNames(int nb, int start) throws XWikiException {
        return this.getAllMatchedUsersNames(null, nb, start);
    }

    public List<String> getAllUsersNames() throws XWikiException {
        return this.getAllMatchedUsersNames(null);
    }

    public List<String> getAllMatchedUsersNames(Map<?, ?> matchFields) throws XWikiException {
        return this.getAllMatchedUsersNames(matchFields, 0, 0, null);
    }

    public List<String> getAllMatchedUsersNames(Map<?, ?> matchFields, int nb, int start) throws XWikiException {
        return this.getAllMatchedUsersNames(matchFields, nb, start, null);
    }

    public List<String> getAllMatchedUsersNames(Map<?, ?> matchFields, int nb, int start, List<?> order) throws XWikiException {
        List<String> userList;
        try {
            userList = RightsManager.getInstance().getAllMatchedUsersOrGroups(true, RightsManagerPluginApi.createMatchingTable(matchFields), false, new RequestLimit(nb, start), RightsManagerPluginApi.createOrderTable(order), this.context);
        }
        catch (RightsManagerException e) {
            this.logError("Try to get all matched users names", e);
            userList = Collections.emptyList();
        }
        return userList;
    }

    public List<String> getAllGlobalUsersNames(int nb, int start) throws XWikiException {
        return this.getAllMatchedGlobalUsersNames(null, nb, start);
    }

    public List<String> getAllGlobalUsersNames() throws XWikiException {
        return this.getAllMatchedGlobalUsersNames(null);
    }

    public List<String> getAllMatchedGlobalUsersNames(Map<?, ?> matchFields) throws XWikiException {
        return this.getAllMatchedGlobalUsersNames(matchFields, 0, 0, null);
    }

    public List<String> getAllMatchedGlobalUsersNames(Map<?, ?> matchFields, int nb, int start) throws XWikiException {
        return this.getAllMatchedGlobalUsersNames(matchFields, nb, start, null);
    }

    public List<String> getAllMatchedGlobalUsersNames(Map<?, ?> matchFields, int nb, int start, List<?> order) throws XWikiException {
        List<String> userList;
        try {
            userList = RightsManager.getInstance().getAllMatchedGlobalUsersOrGroups(true, RightsManagerPluginApi.createMatchingTable(matchFields), false, new RequestLimit(nb, start), RightsManagerPluginApi.createOrderTable(order), this.context);
        }
        catch (RightsManagerException e) {
            this.logError("Try to get all matched users names from global wiki", e);
            userList = Collections.emptyList();
        }
        return userList;
    }

    public List<String> getAllWikiUsersNames(String wikiName, int nb, int start) throws XWikiException {
        return this.getAllMatchedWikiUsersNames(wikiName, null, nb, start);
    }

    public List<String> getAllWikiUsersNames(String wikiName) throws XWikiException {
        return this.getAllMatchedWikiUsersNames(wikiName, null);
    }

    public List<String> getAllMatchedWikiUsersNames(String wikiName, Map<?, ?> matchFields) throws XWikiException {
        return this.getAllMatchedWikiUsersNames(wikiName, matchFields, 0, 0, null);
    }

    public List<String> getAllMatchedWikiUsersNames(String wikiName, Map<?, ?> matchFields, int nb, int start) throws XWikiException {
        return this.getAllMatchedWikiUsersNames(wikiName, matchFields, nb, start, null);
    }

    public List<String> getAllMatchedWikiUsersNames(String wikiName, Map<?, ?> matchFields, int nb, int start, List<?> order) throws XWikiException {
        List<String> userList;
        try {
            userList = RightsManager.getInstance().getAllMatchedWikiUsersOrGroups(true, wikiName, RightsManagerPluginApi.createMatchingTable(matchFields), false, new RequestLimit(nb, start), RightsManagerPluginApi.createOrderTable(order), this.context);
        }
        catch (RightsManagerException e) {
            this.logError("Try to get all matched users names from provided wiki", e);
            userList = Collections.emptyList();
        }
        return userList;
    }

    public List<String> getAllLocalUsersNames(int nb, int start) throws XWikiException {
        return this.getAllMatchedLocalUsersNames(null, nb, start);
    }

    public List<String> getAllLocalUsersNames() throws XWikiException {
        return this.getAllMatchedLocalUsersNames(null);
    }

    public List<String> getAllMatchedLocalUsersNames(Map<?, ?> matchFields) throws XWikiException {
        return this.getAllMatchedLocalUsersNames(matchFields, 0, 0, null);
    }

    public List<String> getAllMatchedLocalUsersNames(Map<?, ?> matchFields, int nb, int start) throws XWikiException {
        return this.getAllMatchedLocalUsersNames(matchFields, nb, start, null);
    }

    public List<String> getAllMatchedLocalUsersNames(Map<?, ?> matchFields, int nb, int start, List<?> order) throws XWikiException {
        List<String> userList;
        try {
            userList = RightsManager.getInstance().getAllMatchedLocalUsersOrGroups(true, RightsManagerPluginApi.createMatchingTable(matchFields), false, new RequestLimit(nb, start), RightsManagerPluginApi.createOrderTable(order), this.context);
        }
        catch (RightsManagerException e) {
            this.logError("Try to get all matched users names from local wiki", e);
            userList = Collections.emptyList();
        }
        return userList;
    }

    public List<Document> getAllUsers(int nb, int start) throws XWikiException {
        return this.getAllMatchedUsers(null, nb, start);
    }

    public List<Document> getAllUsers() throws XWikiException {
        return this.getAllMatchedUsers(null);
    }

    public List<Document> getAllMatchedUsers(Map<?, ?> matchFields) throws XWikiException {
        return this.getAllMatchedUsers(matchFields, 0, 0, null);
    }

    public List<Document> getAllMatchedUsers(Map<?, ?> matchFields, int nb, int start) throws XWikiException {
        return this.getAllMatchedUsers(matchFields, nb, start, null);
    }

    public List<Document> getAllMatchedUsers(Map<?, ?> matchFields, int nb, int start, List<?> order) throws XWikiException {
        List<Document> userList;
        try {
            List<XWikiDocument> xdocList = RightsManager.getInstance().getAllMatchedUsersOrGroups(true, RightsManagerPluginApi.createMatchingTable(matchFields), true, new RequestLimit(nb, start), RightsManagerPluginApi.createOrderTable(order), this.context);
            userList = this.convert(xdocList);
        }
        catch (RightsManagerException e) {
            this.logError("Try to get all matched users", e);
            userList = Collections.emptyList();
        }
        return userList;
    }

    public List<Document> getAllGlobalUsers(int nb, int start) throws XWikiException {
        return this.getAllMatchedGlobalUsers(null, nb, start);
    }

    public List<Document> getAllGlobalUsers() throws XWikiException {
        return this.getAllMatchedGlobalUsers(null);
    }

    public List<Document> getAllMatchedGlobalUsers(Map<?, ?> matchFields) throws XWikiException {
        return this.getAllMatchedGlobalUsers(matchFields, 0, 0, null);
    }

    public List<Document> getAllMatchedGlobalUsers(Map<?, ?> matchFields, int nb, int start) throws XWikiException {
        return this.getAllMatchedGlobalUsers(matchFields, nb, start, null);
    }

    public List<Document> getAllMatchedGlobalUsers(Map<?, ?> matchFields, int nb, int start, List<?> order) throws XWikiException {
        List<Document> userList;
        try {
            List<XWikiDocument> xdocList = RightsManager.getInstance().getAllMatchedGlobalUsersOrGroups(true, RightsManagerPluginApi.createMatchingTable(matchFields), true, new RequestLimit(nb, start), RightsManagerPluginApi.createOrderTable(order), this.context);
            userList = this.convert(xdocList);
        }
        catch (RightsManagerException e) {
            this.logError("Try to get all matched users from global wiki", e);
            userList = Collections.emptyList();
        }
        return userList;
    }

    public List<Document> getAllWikiUsers(String wikiName, int nb, int start) throws XWikiException {
        return this.getAllMatchedWikiUsers(wikiName, null, nb, start);
    }

    public List<Document> getAllWikiUsers(String wikiName) throws XWikiException {
        return this.getAllMatchedWikiUsers(wikiName, null);
    }

    public List<Document> getAllMatchedWikiUsers(String wikiName, Map<?, ?> matchFields) throws XWikiException {
        return this.getAllMatchedWikiUsers(wikiName, matchFields, 0, 0, null);
    }

    public List<Document> getAllMatchedWikiUsers(String wikiName, Map<?, ?> matchFields, int nb, int start) throws XWikiException {
        return this.getAllMatchedWikiUsers(wikiName, matchFields, nb, start, null);
    }

    public List<Document> getAllMatchedWikiUsers(String wikiName, Map<?, ?> matchFields, int nb, int start, List<?> order) throws XWikiException {
        List<Document> userList;
        try {
            List<XWikiDocument> xdocList = RightsManager.getInstance().getAllMatchedWikiUsersOrGroups(true, wikiName, RightsManagerPluginApi.createMatchingTable(matchFields), true, new RequestLimit(nb, start), RightsManagerPluginApi.createOrderTable(order), this.context);
            userList = this.convert(xdocList);
        }
        catch (RightsManagerException e) {
            this.logError("Try to get all matched users from provided wiki", e);
            userList = Collections.emptyList();
        }
        return userList;
    }

    public List<Document> getAllLocalUsers(int nb, int start) throws XWikiException {
        return this.getAllMatchedLocalUsers(null, nb, start);
    }

    public List<Document> getAllLocalUsers() throws XWikiException {
        return this.getAllMatchedLocalUsers(null);
    }

    public List<Document> getAllMatchedLocalUsers(Map<?, ?> matchFields) throws XWikiException {
        return this.getAllMatchedLocalUsers(matchFields, 0, 0, null);
    }

    public List<Document> getAllMatchedLocalUsers(Map<?, ?> matchFields, int nb, int start) throws XWikiException {
        return this.getAllMatchedLocalUsers(matchFields, nb, start, null);
    }

    public List<Document> getAllMatchedLocalUsers(Map<?, ?> matchFields, int nb, int start, List<?> order) throws XWikiException {
        List<Document> userList;
        try {
            List<XWikiDocument> xdocList = RightsManager.getInstance().getAllMatchedLocalUsersOrGroups(true, RightsManagerPluginApi.createMatchingTable(matchFields), true, new RequestLimit(nb, start), RightsManagerPluginApi.createOrderTable(order), this.context);
            userList = this.convert(xdocList);
        }
        catch (RightsManagerException e) {
            this.logError("Try to get all matched users from local wiki", e);
            userList = Collections.emptyList();
        }
        return userList;
    }
}

