/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.rightsmanager;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.plugin.PluginApi;
import com.xpn.xwiki.plugin.rightsmanager.RightsManager;
import com.xpn.xwiki.plugin.rightsmanager.RightsManagerException;
import com.xpn.xwiki.plugin.rightsmanager.RightsManagerGroupsApi;
import com.xpn.xwiki.plugin.rightsmanager.RightsManagerPlugin;
import com.xpn.xwiki.plugin.rightsmanager.RightsManagerRightsApi;
import com.xpn.xwiki.plugin.rightsmanager.RightsManagerUsersApi;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RightsManagerPluginApi
extends PluginApi<RightsManagerPlugin> {
    public static final String CONTEXT_LASTERRORCODE = "lasterrorcode";
    public static final String CONTEXT_LASTEXCEPTION = "lastexception";
    protected static final Logger LOGGER = LoggerFactory.getLogger(RightsManagerPluginApi.class);
    private RightsManagerRightsApi rightsApi;
    private RightsManagerUsersApi usersApi;
    private RightsManagerGroupsApi groupsApi;

    public RightsManagerPluginApi(RightsManagerPlugin plugin, XWikiContext context) {
        super(plugin, context);
        this.rightsApi = new RightsManagerRightsApi(context);
        this.usersApi = new RightsManagerUsersApi(context);
        this.groupsApi = new RightsManagerGroupsApi(context);
    }

    public RightsManagerRightsApi getRightsApi() {
        return this.rightsApi;
    }

    public RightsManagerUsersApi getUsersApi() {
        return this.usersApi;
    }

    public RightsManagerGroupsApi getGroupsApi() {
        return this.groupsApi;
    }

    static Object[][] createMatchingTable(Map<?, ?> map) {
        if (map == null || map.size() == 0) {
            return null;
        }
        Object[][] table = new Object[map.size()][3];
        int i = 0;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            table[i][0] = entry.getKey();
            if (entry.getValue() instanceof List) {
                List typeValue = (List)entry.getValue();
                table[i][1] = typeValue.get(0);
                if (typeValue.size() > 1) {
                    table[i][2] = typeValue.get(1);
                }
            } else {
                table[i][2] = entry.getValue();
            }
            ++i;
        }
        return table;
    }

    static Object[][] createOrderTable(List<?> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        Object[][] table = new Object[list.size()][3];
        int i = 0;
        for (Object entry : list) {
            if (entry instanceof List) {
                List fieldParams = (List)entry;
                table[i][0] = fieldParams.get(0);
                if (fieldParams.size() > 1) {
                    table[i][1] = fieldParams.get(1);
                }
                if (fieldParams.size() > 2) {
                    table[i][2] = fieldParams.get(2);
                }
            } else {
                table[i][0] = entry.toString();
            }
            ++i;
        }
        return table;
    }

    private void logError(String comment, XWikiException e) {
        LOGGER.error(comment, (Throwable)e);
        this.context.put(CONTEXT_LASTERRORCODE, (Object)e.getCode());
        this.context.put(CONTEXT_LASTEXCEPTION, e);
    }

    @Deprecated
    public Collection<String> getAllGroupsNamesForMember(String member) throws XWikiException {
        Collection<String> memberList;
        try {
            memberList = RightsManager.getInstance().getAllGroupsNamesForMember(member, 0, 0, this.context);
        }
        catch (RightsManagerException e) {
            this.logError(MessageFormat.format("Try to get all groups containing user [{0}]", member), e);
            memberList = Collections.emptyList();
        }
        return memberList;
    }

    @Deprecated
    public Collection<String> getAllMembersNamesForGroup(String group) throws XWikiException {
        return this.getAllMembersNamesForGroup(group, 0, 0);
    }

    @Deprecated
    public Collection<String> getAllMembersNamesForGroup(String group, int nb, int start) throws XWikiException {
        return this.getAllMatchedMembersNamesForGroup(group, null, nb, start, null);
    }

    public Collection<String> getAllMatchedMembersNamesForGroup(String group, String matchField, int nb, int start, Boolean orderAsc) throws XWikiException {
        Collection<String> memberList;
        try {
            memberList = RightsManager.getInstance().getAllMatchedMembersNamesForGroup(group, matchField, nb, start, orderAsc, this.context);
        }
        catch (RightsManagerException e) {
            this.logError(MessageFormat.format("Try to get all matched member of group [{0}]", group), e);
            memberList = Collections.emptyList();
        }
        return memberList;
    }

    public int countAllMatchedMembersNamesForGroup(String group, String filter) {
        try {
            return RightsManager.getInstance().countAllMatchedMembersNamesForGroup(group, filter, this.context);
        }
        catch (XWikiException e) {
            this.logError("Failed to count the group members that match a given text filter.", e);
            return 0;
        }
    }

    @Deprecated
    public int countAllGroupsNamesForMember(String member) throws XWikiException {
        int count = 0;
        try {
            count = RightsManager.getInstance().countAllGroupsNamesForMember(member, this.context);
        }
        catch (RightsManagerException e) {
            this.logError("Try to count groups containing provided user", e);
        }
        return count;
    }

    @Deprecated
    public int countAllMembersNamesForGroup(String group) throws XWikiException {
        int count = 0;
        try {
            count = RightsManager.getInstance().countAllMembersNamesForGroup(group, this.context);
        }
        catch (RightsManagerException e) {
            this.logError("Try to count all members provided group contains", e);
        }
        return count;
    }
}

