/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.rightsmanager;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.rightsmanager.RightsManager;
import com.xpn.xwiki.web.Utils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.bridge.event.DocumentDeletedEvent;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationContext;
import org.xwiki.observation.event.BeginEvent;
import org.xwiki.observation.event.Event;
import org.xwiki.observation.remote.RemoteObservationManagerContext;
import org.xwiki.refactoring.event.DocumentRenamingEvent;

public final class RightsManagerListener
implements EventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(RightsManagerListener.class);
    private static final String NAME = "rightsmanager";
    private static final List<Event> EVENTS = new ArrayList<Event>(){
        {
            this.add(new DocumentDeletedEvent());
        }
    };
    private static final DocumentRenamingEvent DOCUMENT_RENAMING_EVENT = new DocumentRenamingEvent();
    private static RightsManagerListener instance;

    private RightsManagerListener() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RightsManagerListener getInstance() {
        Class<RightsManagerListener> clazz = RightsManagerListener.class;
        synchronized (RightsManagerListener.class) {
            if (instance == null) {
                instance = new RightsManagerListener();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public String getName() {
        return NAME;
    }

    public List<Event> getEvents() {
        return EVENTS;
    }

    public void onEvent(Event event, Object source, Object data) {
        if (!Utils.getComponent(RemoteObservationManagerContext.class).isRemoteState() && !this.isInRenamingEvent()) {
            XWikiDocument document = ((XWikiDocument)source).getOriginalDocument();
            XWikiContext context = (XWikiContext)data;
            String userOrGroupWiki = document.getDatabase();
            String userOrGroupSpace = document.getSpace();
            String userOrGroupName = document.getName();
            if (document.getObject("XWiki.XWikiUsers") != null) {
                try {
                    this.cleanDeletedUserOrGroup(userOrGroupWiki, userOrGroupSpace, userOrGroupName, true, context);
                }
                catch (XWikiException e) {
                    LOGGER.warn("Error when cleaning for deleted user", (Throwable)e);
                }
            } else if (document.getObject("XWiki.XWikiGroups") != null) {
                try {
                    this.cleanDeletedUserOrGroup(userOrGroupWiki, userOrGroupSpace, userOrGroupName, false, context);
                }
                catch (XWikiException e) {
                    LOGGER.warn("Error when cleaning for deleted group", (Throwable)e);
                }
            }
        }
    }

    private boolean isInRenamingEvent() {
        return Utils.getComponent(ObservationContext.class).isIn((BeginEvent)DOCUMENT_RENAMING_EVENT);
    }

    private void cleanDeletedUserOrGroupInLocalWiki(String userOrGroupWiki, String userOrGroupSpace, String userOrGroupName, boolean user, XWikiContext context) throws XWikiException {
        RightsManager.getInstance().removeUserOrGroupFromAllRights(userOrGroupWiki, userOrGroupSpace, userOrGroupName, user, context);
        context.getWiki().getGroupService(context).removeUserOrGroupFromAllGroups(userOrGroupWiki, userOrGroupSpace, userOrGroupName, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanDeletedUserOrGroup(String userOrGroupWiki, String userOrGroupSpace, String userOrGroupName, boolean user, XWikiContext context) throws XWikiException {
        List<String> wikiList = context.getWiki().getVirtualWikisDatabaseNames(context);
        String database = context.getWikiId();
        try {
            for (String wikiName : wikiList) {
                context.setWikiId(wikiName);
                this.cleanDeletedUserOrGroupInLocalWiki(userOrGroupWiki, userOrGroupSpace, userOrGroupName, user, context);
            }
        }
        finally {
            context.setWikiId(database);
        }
    }
}

