/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.rightsmanager;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Api;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.rightsmanager.RightsManager;
import com.xpn.xwiki.plugin.rightsmanager.RightsManagerException;
import com.xpn.xwiki.plugin.rightsmanager.RightsManagerPluginApi;
import com.xpn.xwiki.plugin.rightsmanager.utils.RequestLimit;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RightsManagerGroupsApi
extends Api {
    public static final String CONTEXT_LASTERRORCODE = "lasterrorcode";
    public static final String CONTEXT_LASTEXCEPTION = "lastexception";
    protected static final Logger LOGGER = LoggerFactory.getLogger(RightsManagerGroupsApi.class);

    public RightsManagerGroupsApi(XWikiContext context) {
        super(context);
    }

    private void logError(String comment, XWikiException e) {
        LOGGER.error(comment, (Throwable)e);
        this.context.put(CONTEXT_LASTERRORCODE, (Object)e.getCode());
        this.context.put(CONTEXT_LASTEXCEPTION, e);
    }

    public int countAllGroups() throws XWikiException {
        return this.countAllMatchedGroups(null);
    }

    public int countAllMatchedGroups(Map<?, ?> matchFields) throws XWikiException {
        int count = 0;
        try {
            count = RightsManager.getInstance().countAllUsersOrGroups(false, RightsManagerPluginApi.createMatchingTable(matchFields), this.context);
        }
        catch (RightsManagerException e) {
            this.logError("Try to count all groups", e);
        }
        return count;
    }

    public int countAllWikiGroups(String wikiName) throws XWikiException {
        return this.countAllMatchedWikiGroups(wikiName, null);
    }

    public int countAllMatchedWikiGroups(String wikiName, Map<?, ?> matchFields) throws XWikiException {
        int count = 0;
        try {
            count = RightsManager.getInstance().countAllWikiUsersOrGroups(false, wikiName, RightsManagerPluginApi.createMatchingTable(matchFields), this.context);
        }
        catch (RightsManagerException e) {
            this.logError(MessageFormat.format("Try to count all groups in wiki [{0}]", wikiName), e);
        }
        return count;
    }

    public int countAllGlobalGroups() throws XWikiException {
        return this.countAllMatchedGlobalGroups(null);
    }

    public int countAllMatchedGlobalGroups(Map<?, ?> matchFields) throws XWikiException {
        int count = 0;
        try {
            count = RightsManager.getInstance().countAllGlobalUsersOrGroups(false, RightsManagerPluginApi.createMatchingTable(matchFields), this.context);
        }
        catch (RightsManagerException e) {
            this.logError("Try to count all groups in main wiki", e);
        }
        return count;
    }

    public int countAllLocalGroups() throws XWikiException {
        return this.countAllMatchedLocalGroups(null);
    }

    public int countAllMatchedLocalGroups(Map<?, ?> matchFields) throws XWikiException {
        int count = 0;
        try {
            count = RightsManager.getInstance().countAllLocalUsersOrGroups(false, RightsManagerPluginApi.createMatchingTable(matchFields), this.context);
        }
        catch (RightsManagerException e) {
            this.logError("Try to count all groups in current wiki", e);
        }
        return count;
    }

    public List<String> getAllGroupsNames(int nb, int start) throws XWikiException {
        return this.getAllMatchedGroupsNames(null, nb, start);
    }

    public List<String> getAllGroupsNames() throws XWikiException {
        return this.getAllMatchedGroupsNames(null);
    }

    public List<String> getAllMatchedGroupsNames(Map<?, ?> matchFields) throws XWikiException {
        return this.getAllMatchedGroupsNames(matchFields, 0, 0, null);
    }

    public List<String> getAllMatchedGroupsNames(Map<?, ?> matchFields, int nb, int start) throws XWikiException {
        return this.getAllMatchedGroupsNames(matchFields, nb, start, null);
    }

    public List<String> getAllMatchedGroupsNames(Map<?, ?> matchFields, int nb, int start, List<?> order) throws XWikiException {
        List<String> groupList;
        try {
            groupList = RightsManager.getInstance().getAllMatchedUsersOrGroups(false, RightsManagerPluginApi.createMatchingTable(matchFields), false, new RequestLimit(nb, start), RightsManagerPluginApi.createOrderTable(order), this.context);
        }
        catch (RightsManagerException e) {
            this.logError("Try to get all matched groups names", e);
            groupList = Collections.emptyList();
        }
        return groupList;
    }

    public List<String> getAllGlobalGroupsNames(int nb, int start) throws XWikiException {
        return this.getAllMatchedGlobalGroupsNames(null, nb, start);
    }

    public List<String> getAllGlobalGroupsNames() throws XWikiException {
        return this.getAllMatchedGlobalGroupsNames(null);
    }

    public List<String> getAllMatchedGlobalGroupsNames(Map<?, ?> matchFields) throws XWikiException {
        return this.getAllMatchedGlobalGroupsNames(matchFields, 0, 0, null);
    }

    public List<String> getAllMatchedGlobalGroupsNames(Map<?, ?> matchFields, int nb, int start) throws XWikiException {
        return this.getAllMatchedGlobalGroupsNames(matchFields, nb, start, null);
    }

    public List<String> getAllMatchedGlobalGroupsNames(Map<?, ?> matchFields, int nb, int start, List<?> order) throws XWikiException {
        List<String> groupList;
        try {
            groupList = RightsManager.getInstance().getAllMatchedGlobalUsersOrGroups(false, RightsManagerPluginApi.createMatchingTable(matchFields), false, new RequestLimit(nb, start), RightsManagerPluginApi.createOrderTable(order), this.context);
        }
        catch (RightsManagerException e) {
            this.logError("Try to get all matched groups names from global wiki", e);
            groupList = Collections.emptyList();
        }
        return groupList;
    }

    public List<String> getAllWikiGroupsNames(String wikiName, int nb, int start) throws XWikiException {
        return this.getAllMatchedWikiGroupsNames(wikiName, null, nb, start);
    }

    public List<String> getAllWikiGroupsNames(String wikiName) throws XWikiException {
        return this.getAllMatchedWikiGroupsNames(wikiName, null);
    }

    public List<String> getAllMatchedWikiGroupsNames(String wikiName, Map<?, ?> matchFields) throws XWikiException {
        return this.getAllMatchedWikiGroupsNames(wikiName, matchFields, 0, 0, null);
    }

    public List<String> getAllMatchedWikiGroupsNames(String wikiName, Map<?, ?> matchFields, int nb, int start) throws XWikiException {
        return this.getAllMatchedWikiGroupsNames(wikiName, matchFields, nb, start, null);
    }

    public List<String> getAllMatchedWikiGroupsNames(String wikiName, Map<?, ?> matchFields, int nb, int start, List<?> order) throws XWikiException {
        List<String> groupList;
        try {
            groupList = RightsManager.getInstance().getAllMatchedWikiUsersOrGroups(false, wikiName, RightsManagerPluginApi.createMatchingTable(matchFields), false, new RequestLimit(nb, start), RightsManagerPluginApi.createOrderTable(order), this.context);
        }
        catch (RightsManagerException e) {
            this.logError("Try to get all matched groups names from provided wiki", e);
            groupList = Collections.emptyList();
        }
        return groupList;
    }

    public List<String> getAllLocalGroupsNames(int nb, int start) throws XWikiException {
        return this.getAllMatchedLocalGroupsNames(null, nb, start);
    }

    public List<String> getAllLocalGroupsNames() throws XWikiException {
        return this.getAllMatchedLocalGroupsNames(null);
    }

    public List<String> getAllMatchedLocalGroupsNames(Map<?, ?> matchFields) throws XWikiException {
        return this.getAllMatchedLocalGroupsNames(matchFields, 0, 0, null);
    }

    public List<String> getAllMatchedLocalGroupsNames(Map<?, ?> matchFields, int nb, int start) throws XWikiException {
        return this.getAllMatchedLocalGroupsNames(matchFields, nb, start, null);
    }

    public List<String> getAllMatchedLocalGroupsNames(Map<?, ?> matchFields, int nb, int start, List<?> order) throws XWikiException {
        List<String> groupList;
        try {
            groupList = RightsManager.getInstance().getAllMatchedLocalUsersOrGroups(false, RightsManagerPluginApi.createMatchingTable(matchFields), false, new RequestLimit(nb, start), RightsManagerPluginApi.createOrderTable(order), this.context);
        }
        catch (RightsManagerException e) {
            this.logError("Try to get all matched groups names from local wiki", e);
            groupList = Collections.emptyList();
        }
        return groupList;
    }

    public List<Document> getAllGroups(int nb, int start) throws XWikiException {
        return this.getAllMatchedGroups(null, nb, start);
    }

    public List<Document> getAllGroups() throws XWikiException {
        return this.getAllMatchedGroups(null);
    }

    public List<Document> getAllMatchedGroups(Map<?, ?> matchFields) throws XWikiException {
        return this.getAllMatchedGroups(matchFields, 0, 0, null);
    }

    public List<Document> getAllMatchedGroups(Map<?, ?> matchFields, int nb, int start) throws XWikiException {
        return this.getAllMatchedGroups(matchFields, nb, start, null);
    }

    public List<Document> getAllMatchedGroups(Map<?, ?> matchFields, int nb, int start, List<?> order) throws XWikiException {
        List<Document> groupList;
        try {
            List<XWikiDocument> xdocList = RightsManager.getInstance().getAllMatchedUsersOrGroups(false, RightsManagerPluginApi.createMatchingTable(matchFields), true, new RequestLimit(nb, start), RightsManagerPluginApi.createOrderTable(order), this.context);
            groupList = this.convert(xdocList);
        }
        catch (RightsManagerException e) {
            this.logError("Try to get all matched groups documents", e);
            groupList = Collections.emptyList();
        }
        return groupList;
    }

    public List<Document> getAllGlobalGroups(int nb, int start) throws XWikiException {
        return this.getAllMatchedGlobalGroups(null, nb, start);
    }

    public List<Document> getAllGlobalGroups() throws XWikiException {
        return this.getAllMatchedGlobalGroups(null);
    }

    public List<Document> getAllMatchedGlobalGroups(Map<?, ?> matchFields) throws XWikiException {
        return this.getAllMatchedGlobalGroups(matchFields, 0, 0, null);
    }

    public List<Document> getAllMatchedGlobalGroups(Map<?, ?> matchFields, int nb, int start) throws XWikiException {
        return this.getAllMatchedGlobalGroups(matchFields, nb, start, null);
    }

    public List<Document> getAllMatchedGlobalGroups(Map<?, ?> matchFields, int nb, int start, List<?> order) throws XWikiException {
        List<Document> groupList;
        try {
            List<XWikiDocument> xdocList = RightsManager.getInstance().getAllMatchedGlobalUsersOrGroups(false, RightsManagerPluginApi.createMatchingTable(matchFields), true, new RequestLimit(nb, start), RightsManagerPluginApi.createOrderTable(order), this.context);
            groupList = this.convert(xdocList);
        }
        catch (RightsManagerException e) {
            this.logError("Try to get all matched groups documents from global wiki", e);
            groupList = Collections.emptyList();
        }
        return groupList;
    }

    public List<Document> getAllWikiGroups(String wikiName, int nb, int start) throws XWikiException {
        return this.getAllMatchedWikiGroups(wikiName, null, nb, start);
    }

    public List<Document> getAllWikiGroups(String wikiName) throws XWikiException {
        return this.getAllMatchedWikiGroups(wikiName, null);
    }

    public List<Document> getAllMatchedWikiGroups(String wikiName, Map<?, ?> matchFields) throws XWikiException {
        return this.getAllMatchedWikiGroups(wikiName, matchFields, 0, 0, null);
    }

    public List<Document> getAllMatchedWikiGroups(String wikiName, Map<?, ?> matchFields, int nb, int start) throws XWikiException {
        return this.getAllMatchedWikiGroups(wikiName, matchFields, nb, start, null);
    }

    public List<Document> getAllMatchedWikiGroups(String wikiName, Map<?, ?> matchFields, int nb, int start, List<?> order) throws XWikiException {
        List<Document> groupList;
        try {
            List<XWikiDocument> xdocList = RightsManager.getInstance().getAllMatchedWikiUsersOrGroups(false, wikiName, RightsManagerPluginApi.createMatchingTable(matchFields), true, new RequestLimit(nb, start), RightsManagerPluginApi.createOrderTable(order), this.context);
            groupList = this.convert(xdocList);
        }
        catch (RightsManagerException e) {
            this.logError("Try to get all matched groups documents from provided wiki", e);
            groupList = Collections.emptyList();
        }
        return groupList;
    }

    public List<Document> getAllLocalGroups(int nb, int start) throws XWikiException {
        return this.getAllMatchedLocalGroups(null, nb, start);
    }

    public List<Document> getAllLocalGroups() throws XWikiException {
        return this.getAllMatchedLocalGroups(null);
    }

    public List<Document> getAllMatchedLocalGroups(Map<?, ?> matchFields) throws XWikiException {
        return this.getAllMatchedLocalGroups(matchFields, 0, 0, null);
    }

    public List<Document> getAllMatchedLocalGroups(Map<?, ?> matchFields, int nb, int start) throws XWikiException {
        return this.getAllMatchedLocalGroups(matchFields, nb, start, null);
    }

    public List<Document> getAllMatchedLocalGroups(Map<?, ?> matchFields, int nb, int start, List<?> order) throws XWikiException {
        List<Document> groupList;
        try {
            List<XWikiDocument> xdocList = RightsManager.getInstance().getAllMatchedLocalUsersOrGroups(false, RightsManagerPluginApi.createMatchingTable(matchFields), true, new RequestLimit(nb, start), RightsManagerPluginApi.createOrderTable(order), this.context);
            groupList = this.convert(xdocList);
        }
        catch (RightsManagerException e) {
            this.logError("Try to get all matched groups documents from local wiki", e);
            groupList = Collections.emptyList();
        }
        return groupList;
    }
}

