/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.packaging;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Api;
import com.xpn.xwiki.plugin.packaging.DocumentInfo;
import com.xpn.xwiki.plugin.packaging.DocumentInfoAPI;
import com.xpn.xwiki.plugin.packaging.Package;
import com.xpn.xwiki.plugin.packaging.PackageException;
import com.xpn.xwiki.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONObject;

public class PackageAPI
extends Api {
    Package pack;

    public PackageAPI(Package plugin, XWikiContext context) throws PackageException {
        super(context);
        if (!this.hasAdminRights()) {
            throw new PackageException(9001, "Admin right is needed to use this plugin");
        }
        this.setPlugin(plugin);
    }

    private void setPlugin(Package plugin) {
        this.pack = plugin;
    }

    public String getName() {
        return this.pack.getName();
    }

    public void setName(String name) {
        this.pack.setName(name);
    }

    public Package getPackage() {
        if (this.hasProgrammingRights()) {
            return this.pack;
        }
        return null;
    }

    public String getDescription() {
        return this.pack.getDescription();
    }

    public void setDescription(String description) {
        this.pack.setDescription(description);
    }

    public String getVersion() {
        return this.pack.getVersion();
    }

    public void setVersion(String version) {
        this.pack.setVersion(version);
    }

    public String getLicence() {
        return this.pack.getLicence();
    }

    public void setLicence(String licence) {
        this.pack.setLicence(licence);
    }

    public String getAuthorName() {
        return this.pack.getAuthorName();
    }

    public void setAuthorName(String authorName) {
        this.pack.setAuthorName(authorName);
    }

    public boolean isBackupPack() {
        return this.pack.isBackupPack();
    }

    public void setBackupPack(boolean backupPack) {
        this.pack.setBackupPack(backupPack);
    }

    public boolean hasBackupPackImportRights() {
        return this.pack.hasBackupPackImportRights(this.context);
    }

    public boolean isVersionPreserved() {
        return this.pack.isVersionPreserved();
    }

    public void setPreserveVersion(boolean preserveVersion) {
        this.pack.setPreserveVersion(preserveVersion);
    }

    public boolean isWithVersions() {
        return this.pack.isWithVersions();
    }

    public void setWithVersions(boolean withVersions) {
        this.pack.setWithVersions(withVersions);
    }

    public void addDocumentFilter(Object filter) throws PackageException {
        this.pack.addDocumentFilter(filter);
    }

    public List<DocumentInfoAPI> getFiles() {
        List<DocumentInfo> files = this.pack.getFiles();
        ArrayList<DocumentInfoAPI> apiFiles = new ArrayList<DocumentInfoAPI>(files.size());
        for (DocumentInfo docInfo : files) {
            apiFiles.add(new DocumentInfoAPI(docInfo, this.getXWikiContext()));
        }
        return apiFiles;
    }

    public boolean add(String docFullName, int DefaultAction) throws XWikiException {
        return this.pack.add(docFullName, DefaultAction, this.getXWikiContext());
    }

    public boolean add(String docFullName) throws XWikiException {
        return this.pack.add(docFullName, this.getXWikiContext());
    }

    public void setDocumentAction(String docFullName, int action) {
        for (DocumentInfo docInfo : this.pack.getFiles()) {
            if (docInfo.getFullName().compareTo(docFullName) != 0) continue;
            docInfo.setAction(action);
        }
    }

    public void setDocumentAction(String docFullName, String language, int action) {
        for (DocumentInfo docInfo : this.pack.getFiles()) {
            if (docInfo.getFullName().compareTo(docFullName) != 0 || !language.equals(docInfo.getLanguage())) continue;
            docInfo.setAction(action);
        }
    }

    public String export() throws IOException, XWikiException {
        this.getXWikiContext().getResponse().setContentType("application/zip");
        this.getXWikiContext().getResponse().addHeader("Content-disposition", "attachment; filename=" + Util.encodeURI(this.pack.getName(), this.context) + ".xar");
        this.getXWikiContext().setFinished(true);
        return this.pack.export((OutputStream)this.getXWikiContext().getResponse().getOutputStream(), this.getXWikiContext());
    }

    public boolean importPackageFromByteArray(byte[] data) {
        try {
            this.pack.Import(data, this.getXWikiContext());
            return true;
        }
        catch (XWikiException e) {
            this.getXWikiContext().put("import_error", e.getMessage());
            return false;
        }
        catch (IOException e) {
            this.getXWikiContext().put("import_error", e.getMessage());
            return false;
        }
    }

    public String Import(byte[] file) throws IOException, XWikiException {
        return this.pack.Import(file, this.getXWikiContext());
    }

    public String Import(InputStream file) throws IOException, XWikiException {
        return this.pack.Import(file, this.getXWikiContext());
    }

    public int testInstall() {
        return this.pack.testInstall(false, this.getXWikiContext());
    }

    public int testInstall(boolean isAdmin) {
        return this.pack.testInstall(isAdmin, this.getXWikiContext());
    }

    public void backupWiki() throws XWikiException, IOException {
        this.pack.addAllWikiDocuments(this.getXWikiContext());
        this.export();
    }

    public String toXml() {
        return this.pack.toXml(this.getXWikiContext());
    }

    public JSONObject toJSON() {
        return this.pack.toJSON(this.getXWikiContext());
    }

    public int install() throws XWikiException {
        return this.pack.install(this.getXWikiContext());
    }

    public List<String> getErrors() {
        return this.pack.getErrors(this.getXWikiContext());
    }

    public List<String> getSkipped() {
        return this.pack.getSkipped(this.getXWikiContext());
    }

    public List<String> getInstalled() {
        return this.pack.getInstalled(this.getXWikiContext());
    }

    public int getStatus() {
        return this.pack.getStatus(this.getXWikiContext());
    }
}

