/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XWikiPluginManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(XWikiPluginManager.class);
    private Vector<String> plugins = new Vector();
    private Vector<String> pluginClassNames = new Vector();
    private Map<String, XWikiPluginInterface> plugins_classes = new HashMap<String, XWikiPluginInterface>();
    private Map<String, Vector<XWikiPluginInterface>> functionList = new HashMap<String, Vector<XWikiPluginInterface>>();

    public XWikiPluginManager() {
    }

    public XWikiPluginManager(String classList, XWikiContext context) {
        String[] classNames = StringUtils.split((String)classList, (String)" ,");
        this.addPlugins(classNames, context);
    }

    public XWikiPluginManager(String[] classNames, XWikiContext context) {
        this.addPlugins(classNames, context);
    }

    public void addPlugin(String name, String className, XWikiContext context) {
        if (this.pluginClassNames.contains(className)) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("Skipping already registered plugin [%s]", name));
            }
            return;
        }
        try {
            Class[] classes = new Class[]{String.class, String.class, context.getClass()};
            Object[] args = new Object[]{name, className, context};
            Class<XWikiPluginInterface> pluginClass = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            XWikiPluginInterface plugin = (XWikiPluginInterface)pluginClass.getConstructor(classes).newInstance(args);
            if (plugin != null) {
                this.plugins.add(plugin.getName());
                this.plugins_classes.put(plugin.getName(), plugin);
                this.pluginClassNames.add(className);
                this.initPlugin(plugin, pluginClass, context);
            }
        }
        catch (Exception ex) {
            LOGGER.error("Cannot initialize plugin [" + className + "]. This plugin will not be available.", (Throwable)ex);
        }
    }

    public void removePlugin(String className) {
        this.plugins.remove(className);
        XWikiPluginInterface plugin = this.plugins_classes.get(className);
        this.plugins_classes.remove(className);
        for (String name : this.functionList.keySet()) {
            Vector<XWikiPluginInterface> pluginList = this.functionList.get(name);
            pluginList.remove(plugin);
        }
    }

    public void addPlugins(String[] classNames, XWikiContext context) {
        if (context.getURLFactory() == null) {
            context.setURLFactory(context.getWiki().getURLFactoryService().createURLFactory(context.getMode(), context));
        }
        this.initInterface();
        for (String className : classNames) {
            this.addPlugin(className, className, context);
        }
    }

    public XWikiPluginInterface getPlugin(String className) {
        return this.plugins_classes.get(className);
    }

    public Vector<String> getPlugins() {
        return this.plugins;
    }

    public void setPlugins(Vector<String> plugins) {
        this.plugins = plugins;
    }

    public void initInterface() {
        for (Method method : XWikiPluginInterface.class.getMethods()) {
            String name = method.getName();
            this.functionList.put(name, new Vector());
        }
    }

    public void initPlugin(Object plugin, Class<XWikiPluginInterface> pluginClass, XWikiContext context) throws XWikiException {
        for (Method method : pluginClass.getDeclaredMethods()) {
            String name = method.getName();
            if (!this.functionList.containsKey(name)) continue;
            this.functionList.get(name).add((XWikiPluginInterface)plugin);
        }
        ((XWikiPluginInterface)plugin).init(context);
    }

    public Vector<XWikiPluginInterface> getPlugins(String functionName) {
        return this.functionList.get(functionName);
    }

    public void virtualInit(XWikiContext context) {
        for (XWikiPluginInterface plugin : this.getPlugins("virtualInit")) {
            try {
                plugin.virtualInit(context);
            }
            catch (Exception exception) {}
        }
    }

    public void flushCache(XWikiContext context) {
        for (XWikiPluginInterface plugin : this.getPlugins("flushCache")) {
            try {
                plugin.flushCache(context);
            }
            catch (Exception e) {
                LOGGER.error("Failed to flush cache in plugin [" + String.valueOf(plugin.getClass()) + "]", (Throwable)e);
            }
        }
    }

    public String commonTagsHandler(String text, XWikiContext context) {
        for (XWikiPluginInterface plugin : this.getPlugins("commonTagsHandler")) {
            try {
                text = plugin.commonTagsHandler(text, context);
            }
            catch (Exception exception) {}
        }
        return text;
    }

    public String startRenderingHandler(String text, XWikiContext context) {
        for (XWikiPluginInterface plugin : this.getPlugins("startRenderingHandler")) {
            try {
                text = plugin.startRenderingHandler(text, context);
            }
            catch (Exception exception) {}
        }
        return text;
    }

    public String outsidePREHandler(String text, XWikiContext context) {
        for (XWikiPluginInterface plugin : this.getPlugins("outsidePREHandler")) {
            try {
                text = plugin.outsidePREHandler(text, context);
            }
            catch (Exception exception) {}
        }
        return text;
    }

    public String insidePREHandler(String text, XWikiContext context) {
        for (XWikiPluginInterface plugin : this.getPlugins("insidePREHandler")) {
            try {
                text = plugin.insidePREHandler(text, context);
            }
            catch (Exception exception) {}
        }
        return text;
    }

    public String endRenderingHandler(String text, XWikiContext context) {
        for (XWikiPluginInterface plugin : this.getPlugins("endRenderingHandler")) {
            try {
                text = plugin.endRenderingHandler(text, context);
            }
            catch (Exception exception) {}
        }
        return text;
    }

    public void beginRendering(XWikiContext context) {
        for (XWikiPluginInterface plugin : this.getPlugins("beginRendering")) {
            try {
                plugin.beginRendering(context);
            }
            catch (Exception exception) {}
        }
    }

    public void endRendering(XWikiContext context) {
        for (XWikiPluginInterface plugin : this.getPlugins("endRendering")) {
            try {
                plugin.endRendering(context);
            }
            catch (Exception exception) {}
        }
    }

    public void beginParsing(XWikiContext context) {
        for (XWikiPluginInterface plugin : this.getPlugins("beginParsing")) {
            try {
                plugin.beginParsing(context);
            }
            catch (Exception exception) {}
        }
    }

    public String endParsing(String content, XWikiContext context) {
        for (XWikiPluginInterface plugin : this.getPlugins("endParsing")) {
            try {
                content = plugin.endParsing(content, context);
            }
            catch (Exception exception) {}
        }
        return content;
    }

    public XWikiAttachment downloadAttachment(XWikiAttachment attachment, XWikiContext context) {
        XWikiAttachment attach = attachment;
        for (XWikiPluginInterface plugin : this.getPlugins("downloadAttachment")) {
            try {
                attach = plugin.downloadAttachment(attach, context);
            }
            catch (Exception ex) {
                LOGGER.warn("downloadAttachment failed for plugin [" + plugin.getName() + "]: " + ex.getMessage());
            }
        }
        return attach;
    }
}

