/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.pdf.impl;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.model.LegacySpaceResolver;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiServletURLFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.model.reference.DocumentReference;

public class FileSystemURLFactory
extends XWikiServletURLFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemURLFactory.class);
    private static final char SEPARATOR = '/';
    private LegacySpaceResolver legacySpaceResolver = Utils.getComponent(LegacySpaceResolver.class);

    @Override
    public URL createAttachmentURL(String filename, String spaces, String name, String action, String querystring, String wiki, XWikiContext context) {
        try {
            return this.getURL(wiki, spaces, name, filename, null, context);
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to save image for PDF export", (Throwable)ex);
            return super.createAttachmentURL(filename, spaces, name, action, null, wiki, context);
        }
    }

    @Override
    public URL createAttachmentRevisionURL(String filename, String spaces, String name, String revision, String wiki, XWikiContext context) {
        try {
            return this.getURL(wiki, spaces, name, filename, revision, context);
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to save image for PDF export: " + ex.getMessage());
            return super.createAttachmentRevisionURL(filename, spaces, name, revision, wiki, context);
        }
    }

    @Override
    public URL createSkinURL(String filename, String skin, XWikiContext context) {
        try {
            Map<String, File> usedFiles = this.getFileMapping(context);
            String key = this.getSkinfileKey(filename, skin);
            if (!usedFiles.containsKey(key) && !this.copyResource("/skins/" + skin + "/" + filename, key, usedFiles, context)) {
                return super.createSkinURL(filename, skin, context);
            }
            return usedFiles.get(key).toURI().toURL();
        }
        catch (Exception ex) {
            return super.createSkinURL(filename, skin, context);
        }
    }

    @Override
    public URL createResourceURL(String filename, boolean forceSkinAction, XWikiContext context) {
        try {
            Map<String, File> usedFiles = this.getFileMapping(context);
            String key = this.getResourceKey(filename);
            if (!usedFiles.containsKey(key) && !this.copyResource("/resources/" + filename, key, usedFiles, context)) {
                return super.createResourceURL(filename, forceSkinAction, context);
            }
            return usedFiles.get(key).toURI().toURL();
        }
        catch (Exception ex) {
            return super.createResourceURL(filename, forceSkinAction, context);
        }
    }

    @Override
    public String getURL(URL url, XWikiContext context) {
        if (url == null) {
            return "";
        }
        return url.toString();
    }

    private URL getURL(String wiki, String spaces, String name, String filename, String revision, XWikiContext context) throws Exception {
        List<String> spaceNames;
        String key;
        Map<String, File> usedFiles = this.getFileMapping(context);
        if (!usedFiles.containsKey(key = this.getAttachmentKey(spaceNames = this.legacySpaceResolver.resolve(spaces), name, filename, revision))) {
            File file = this.getTemporaryFile(key, context);
            LOGGER.debug("Temporary PDF export file [{}]", (Object)file.toString());
            XWikiDocument doc = context.getWiki().getDocument(new DocumentReference(StringUtils.defaultString((String)wiki, (String)context.getWikiId()), spaceNames, name), context);
            XWikiAttachment attachment = doc.getAttachment(filename);
            if (attachment == null) {
                LOGGER.warn("Attachment [{}] doesn't exist in [{}]. Generated content will have invalid content (empty image or broken link)", (Object)filename, (Object)doc.getDocumentReference());
                return null;
            }
            if (StringUtils.isNotEmpty((CharSequence)revision)) {
                attachment = attachment.getAttachmentRevision(revision, context);
            }
            try (FileOutputStream fos = new FileOutputStream(file);){
                IOUtils.copy((InputStream)attachment.getContentInputStream(context), (OutputStream)fos);
            }
            usedFiles.put(key, file);
        }
        return usedFiles.get(key).toURI().toURL();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean copyResource(String resourceName, String key, Map<String, File> usedFiles, XWikiContext context) {
        try (InputStream data = context.getWiki().getResourceAsStream(resourceName);){
            if (data == null) return false;
            File file = this.getTemporaryFile(key, context);
            FileUtils.copyInputStreamToFile((InputStream)data, (File)file);
            usedFiles.put(key, file);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private String getAttachmentKey(List<String> spaceNames, String name, String filename, String revision) {
        StringBuilder builder = new StringBuilder();
        try {
            builder.append("attachment").append('/');
            for (String spaceName : spaceNames) {
                builder.append(URLEncoder.encode(spaceName, "UTF-8"));
                builder.append('/');
            }
            builder.append(URLEncoder.encode(name, "UTF-8")).append('/');
            builder.append(URLEncoder.encode(filename, "UTF-8"));
            if (!StringUtils.isEmpty((CharSequence)revision)) {
                builder.append('/');
                builder.append(URLEncoder.encode(revision, "UTF-8"));
            }
            return builder.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(String.format("Failed to compute unique Attachment key for spaces [%s[, page [%s], filename [%s], revision [%s], while exporting.", StringUtils.join(spaceNames, (String)", "), name, filename, revision), e);
        }
    }

    private String getResourceKey(String filename) {
        try {
            return "resource/" + URLEncoder.encode(filename, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            return filename;
        }
    }

    private String getSkinfileKey(String filename, String skin) {
        try {
            return "skin/" + URLEncoder.encode(skin, "UTF-8") + "/" + URLEncoder.encode(filename, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            return skin + "/" + filename;
        }
    }

    private Map<String, File> getFileMapping(XWikiContext context) {
        Map usedFiles = (Map)context.get("pdfexport-file-mapping");
        return usedFiles;
    }

    private File getTemporaryFile(String key, XWikiContext context) throws IOException {
        File tempdir = (File)context.get("pdfexportdir");
        String prefix = "pdf";
        try {
            return File.createTempFile(prefix, null, tempdir);
        }
        catch (IOException e) {
            throw new IOException(String.format("Failed to create temporary file during PDF export, for key [%s], prefix [%s], in directory [%s] (exist: [%s])", key, prefix, tempdir, tempdir.exists()), e);
        }
    }
}

