/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.objects.meta;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.internal.objects.classes.PropertyClassProvider;
import com.xpn.xwiki.internal.objects.meta.PropertyMetaClassInterface;
import com.xpn.xwiki.objects.BaseCollection;
import com.xpn.xwiki.objects.PropertyInterface;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.PropertyClass;
import com.xpn.xwiki.web.Utils;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.manager.ComponentLookupException;

public class MetaClass
extends BaseClass {
    private static final long serialVersionUID = 1L;
    private static final String PROPERTY_NAME_PREFIX = "meta";
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaClass.class);
    private static MetaClass metaClass;

    public MetaClass() {
        try {
            List providers = Utils.getContextComponentManager().getInstanceList(PropertyClassProvider.class);
            for (PropertyClassProvider provider : providers) {
                PropertyMetaClassInterface property = provider.getDefinition();
                this.safeput(property.getName(), property);
            }
        }
        catch (ComponentLookupException e) {
            LOGGER.error("Failed to initialize the meta class.", (Throwable)e);
        }
    }

    @Override
    public void safeput(String name, PropertyInterface property) {
        this.addField(PROPERTY_NAME_PREFIX + name, property);
        if (property instanceof PropertyClass) {
            ((PropertyClass)property).setObject(this);
            ((PropertyClass)property).setName(name);
        }
    }

    @Override
    public PropertyInterface safeget(String name) {
        return super.safeget(PROPERTY_NAME_PREFIX + name);
    }

    @Override
    public PropertyInterface get(String name) {
        PropertyInterface property = this.safeget(name);
        if (property == null) {
            property = this.safeget(StringUtils.removeEnd((String)StringUtils.substringAfterLast((String)name, (String)"."), (String)"Class"));
        }
        return property;
    }

    @Override
    public void put(String name, PropertyInterface property) {
        this.safeput(name, property);
    }

    public static MetaClass getMetaClass() {
        if (metaClass == null) {
            metaClass = new MetaClass();
        }
        return metaClass;
    }

    public static void setMetaClass(MetaClass metaClass) {
        MetaClass.metaClass = metaClass;
    }

    @Override
    public BaseCollection newObject(XWikiContext context) {
        return new BaseClass();
    }
}

